/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.util.function.BiFunction;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1025)
@Scope(value=Scopes.NAMED_CACHE)
public class BiFunctionMapper
implements BiFunction {
    private final DataConversion keyDataConversion;
    private final DataConversion valueDataConversion;
    private final BiFunction biFunction;

    @Inject
    public void injectDependencies(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.keyDataConversion);
        componentRegistry.wireDependencies(this.valueDataConversion);
    }

    public BiFunctionMapper(BiFunction remappingFunction, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        this.biFunction = remappingFunction;
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
    }

    @ProtoFactory
    BiFunctionMapper(MarshallableObject<BiFunction> biFunction, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        this.biFunction = MarshallableObject.unwrap(biFunction);
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
    }

    @ProtoField(value=1)
    MarshallableObject<BiFunction> getBiFunction() {
        return MarshallableObject.create(this.biFunction);
    }

    @ProtoField(value=2)
    public DataConversion getKeyDataConversion() {
        return this.keyDataConversion;
    }

    @ProtoField(value=3)
    public DataConversion getValueDataConversion() {
        return this.valueDataConversion;
    }

    public Object apply(Object k, Object v) {
        Object value;
        Object key = this.keyDataConversion.fromStorage(k);
        Object result = this.biFunction.apply(key, value = this.valueDataConversion.fromStorage(v));
        return result != null ? this.valueDataConversion.toStorage(result) : null;
    }
}

