/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.context.Flag;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.remoting.transport.Address;
import org.infinispan.telemetry.InfinispanSpanAttributes;
import org.infinispan.util.ByteString;

public abstract class AbstractFlagAffectedCommand
implements CacheRpcCommand,
FlagAffectedCommand {
    protected ByteString cacheName;
    protected Address origin;
    protected long flags;
    protected InfinispanSpanAttributes spanAttributes;

    protected AbstractFlagAffectedCommand(long flags) {
        this.flags = flags;
    }

    public AbstractFlagAffectedCommand(ByteString cacheName, long flags) {
        this.cacheName = cacheName;
        this.flags = flags;
    }

    @Override
    @ProtoField(value=1)
    public ByteString getCacheName() {
        return this.cacheName;
    }

    @ProtoField(number=2, name="flags")
    public long getFlagsWithoutRemote() {
        return FlagBitSets.copyWithoutRemotableFlags(this.flags);
    }

    @Override
    public long getFlagsBitSet() {
        return this.flags;
    }

    @Override
    public void setFlagsBitSet(long bitSet) {
        this.flags = bitSet;
    }

    protected final boolean hasSameFlags(FlagAffectedCommand other) {
        return this.flags == other.getFlagsBitSet();
    }

    protected final String printFlags() {
        return EnumUtil.prettyPrintBitSet((long)this.flags, Flag.class);
    }

    @Override
    public Address getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(Address origin) {
        this.origin = origin;
    }

    @Override
    public void setSpanAttributes(InfinispanSpanAttributes attributes) {
        this.spanAttributes = attributes;
    }

    @Override
    public InfinispanSpanAttributes getSpanAttributes() {
        return this.spanAttributes;
    }
}

