/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TimeQuantity;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.expiration.TouchMode;
import org.infinispan.util.logging.Log;

public class ExpirationConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ExpirationConfiguration> {
    private final AttributeSet attributes = ExpirationConfiguration.attributeDefinitionSet();

    ExpirationConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ExpirationConfigurationBuilder lifespan(long l) {
        this.attributes.attribute(ExpirationConfiguration.LIFESPAN).set((Object)TimeQuantity.valueOf((long)l));
        return this;
    }

    public ExpirationConfigurationBuilder lifespan(String l) {
        this.attributes.attribute(ExpirationConfiguration.LIFESPAN).set((Object)TimeQuantity.valueOf((String)l));
        return this;
    }

    public ExpirationConfigurationBuilder lifespan(long l, TimeUnit unit) {
        return this.lifespan(unit.toMillis(l));
    }

    public ExpirationConfigurationBuilder maxIdle(long l) {
        this.attributes.attribute(ExpirationConfiguration.MAX_IDLE).set((Object)TimeQuantity.valueOf(null, (long)l));
        return this;
    }

    public ExpirationConfigurationBuilder maxIdle(String s) {
        this.attributes.attribute(ExpirationConfiguration.MAX_IDLE).set((Object)TimeQuantity.valueOf((String)s));
        return this;
    }

    public ExpirationConfigurationBuilder maxIdle(long l, TimeUnit unit) {
        return this.maxIdle(unit.toMillis(l));
    }

    public long maxIdle() {
        return ((TimeQuantity)this.attributes.attribute(ExpirationConfiguration.MAX_IDLE).get()).longValue();
    }

    public ExpirationConfigurationBuilder enableReaper() {
        this.attributes.attribute(ExpirationConfiguration.REAPER_ENABLED).set((Object)true);
        return this;
    }

    public ExpirationConfigurationBuilder reaperEnabled(boolean enabled) {
        this.attributes.attribute(ExpirationConfiguration.REAPER_ENABLED).set((Object)enabled);
        return this;
    }

    public ExpirationConfigurationBuilder disableReaper() {
        this.attributes.attribute(ExpirationConfiguration.REAPER_ENABLED).set((Object)false);
        return this;
    }

    public boolean reaperEnabled() {
        return (Boolean)this.attributes.attribute(ExpirationConfiguration.REAPER_ENABLED).get();
    }

    public ExpirationConfigurationBuilder wakeUpInterval(long l) {
        this.attributes.attribute(ExpirationConfiguration.WAKEUP_INTERVAL).set((Object)TimeQuantity.valueOf((long)l));
        return this;
    }

    public ExpirationConfigurationBuilder wakeUpInterval(String s) {
        this.attributes.attribute(ExpirationConfiguration.WAKEUP_INTERVAL).set((Object)TimeQuantity.valueOf((String)s));
        return this;
    }

    public long wakeupInterval() {
        return ((TimeQuantity)this.attributes.attribute(ExpirationConfiguration.WAKEUP_INTERVAL).get()).longValue();
    }

    public ExpirationConfigurationBuilder wakeUpInterval(long l, TimeUnit unit) {
        return this.wakeUpInterval(unit.toMillis(l));
    }

    public ExpirationConfigurationBuilder touch(TouchMode touchMode) {
        this.attributes.attribute(ExpirationConfiguration.TOUCH).set((Object)touchMode);
        return this;
    }

    public void validate() {
        Attribute touch = this.attributes.attribute(ExpirationConfiguration.TOUCH);
        Objects.requireNonNull((TouchMode)((Object)touch.get()));
        if (touch.isModified() && touch.get() == TouchMode.SYNC && !this.clustering().cacheMode().isSynchronous()) {
            throw Log.CONFIG.invalidTouchMode(this.clustering().cacheMode());
        }
        Attribute maxIdle = this.attributes.attribute(ExpirationConfiguration.MAX_IDLE);
        Attribute lifespan = this.attributes.attribute(ExpirationConfiguration.LIFESPAN);
        if (maxIdle.isModified() && lifespan.isModified()) {
            TimeQuantity maxIdleTime = (TimeQuantity)maxIdle.get();
            TimeQuantity lifespanTime = (TimeQuantity)lifespan.get();
            if (maxIdleTime.longValue() > 0L && lifespanTime.longValue() > 0L && maxIdleTime.toDuration().compareTo(lifespanTime.toDuration()) >= 0) {
                throw Log.CONFIG.maxIdleGreaterThanOrEqualLifespan(maxIdleTime.toString(), lifespanTime.toString());
            }
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public ExpirationConfiguration create() {
        return new ExpirationConfiguration(this.attributes.protect());
    }

    public ExpirationConfigurationBuilder read(ExpirationConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.valueOf(this.attributes);
    }
}

