/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1132)
public class MortalCacheEntry
extends AbstractInternalCacheEntry {
    protected long lifespan;
    protected long created;

    public MortalCacheEntry(Object key, Object value, long lifespan, long created) {
        this(key, value, null, lifespan, created);
    }

    protected MortalCacheEntry(Object key, Object value, PrivateMetadata internalMetadata, long lifespan, long created) {
        super(key, value, internalMetadata);
        this.lifespan = lifespan;
        this.created = created;
    }

    @ProtoFactory
    MortalCacheEntry(MarshallableObject<?> wrappedKey, MarshallableObject<?> wrappedValue, PrivateMetadata internalMetadata, long created, long lifespan) {
        super(wrappedKey, wrappedValue, internalMetadata);
        this.created = created;
        this.lifespan = lifespan;
    }

    @Override
    @ProtoField(value=4)
    public final long getCreated() {
        return this.created;
    }

    @Override
    @ProtoField(value=5)
    public final long getLifespan() {
        return this.lifespan;
    }

    @Override
    public final boolean isExpired(long now) {
        return ExpiryHelper.isExpiredMortal(this.lifespan, this.created, now);
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    public void setLifespan(long lifespan) {
        this.lifespan = lifespan;
    }

    @Override
    public final long getLastUsed() {
        return -1L;
    }

    @Override
    public final long getMaxIdle() {
        return -1L;
    }

    @Override
    public final long getExpiryTime() {
        return this.lifespan > -1L ? this.created + this.lifespan : -1L;
    }

    @Override
    public final void touch(long currentTimeMillis) {
    }

    @Override
    public void reincarnate(long now) {
        this.created = now;
    }

    public InternalCacheValue<?> toInternalCacheValue() {
        return new MortalCacheValue(this.value, this.internalMetadata, this.created, this.lifespan);
    }

    @Override
    public Metadata getMetadata() {
        return new EmbeddedMetadata.Builder().lifespan(this.lifespan).build();
    }

    @Override
    public void setMetadata(Metadata metadata) {
        throw new IllegalStateException("Metadata cannot be set on mortal entries. They need to be recreated via the entry factory.");
    }

    @Override
    public MortalCacheEntry clone() {
        return (MortalCacheEntry)super.clone();
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", created=").append(this.created);
        builder.append(", lifespan=").append(this.lifespan);
    }
}

