/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.io.IOException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Paths;
import java.util.Optional;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.concurrent.FileSystemLock;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.globalstate.GlobalStateManager;
import org.infinispan.globalstate.GlobalStateProvider;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.globalstate.impl.GlobalStateHandler;
import org.infinispan.util.logging.Log;

@Scope(value=Scopes.GLOBAL)
public class GlobalStateManagerImpl
implements GlobalStateManager {
    public static final String VERSION = "@version";
    public static final String TIMESTAMP = "@timestamp";
    public static final String VERSION_MAJOR = "version-major";
    @Inject
    GlobalConfiguration globalConfiguration;
    @Inject
    TimeService timeService;
    private final GlobalStateHandler handler = new GlobalStateHandler();
    private FileSystemLock globalLock;
    private boolean persistentState;
    private ScopedPersistentState globalState;

    @Start
    public void start() {
        this.persistentState = this.globalConfiguration.globalState().enabled();
        if (this.persistentState) {
            this.handler.setRoot(this.globalConfiguration.globalState().persistentLocation());
            this.handler.setTimeService(this.timeService);
            this.acquireGlobalLock();
            this.loadGlobalState();
        }
    }

    @Stop
    public void stop() {
        if (this.persistentState) {
            this.writeGlobalState();
            this.releaseGlobalLock();
        }
    }

    private void acquireGlobalLock() {
        this.globalLock = new FileSystemLock(Paths.get(this.globalConfiguration.globalState().persistentLocation(), new String[0]), "___global");
        try {
            boolean checkAcquire = true;
            if (!this.globalLock.tryLock()) {
                switch (this.globalConfiguration.globalState().uncleanShutdownAction()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case FAIL: {
                        throw Log.CONTAINER.globalStateLockFilePresent(this.globalLock);
                    }
                    case PURGE: {
                        this.deleteScopedState("___global");
                        this.globalLock.unsafeLock();
                        boolean bl = true;
                        break;
                    }
                    case IGNORE: {
                        boolean bl = checkAcquire = false;
                    }
                }
            }
            if (checkAcquire && !this.globalLock.isAcquired()) {
                throw Log.CONTAINER.globalStateCannotAcquireLockFile(null, this.globalLock);
            }
        }
        catch (IOException | OverlappingFileLockException e) {
            throw Log.CONTAINER.globalStateCannotAcquireLockFile(e, this.globalLock);
        }
    }

    private void releaseGlobalLock() {
        if (this.globalLock != null && this.globalLock.isAcquired()) {
            this.globalLock.unlock();
        }
    }

    private void loadGlobalState() {
        this.globalState = this.handler.startStateHandler();
    }

    @Override
    public void writeGlobalState() {
        if (this.persistentState) {
            this.handler.writeGlobalState();
        }
    }

    @Override
    public void writeScopedState(ScopedPersistentState state) {
        if (this.persistentState) {
            this.handler.writeScopedState(state);
        }
    }

    @Override
    public void deleteScopedState(String scope) {
        if (this.persistentState) {
            this.handler.deleteScopedState(scope);
        }
    }

    @Override
    public Optional<ScopedPersistentState> readScopedState(String scope) {
        if (!this.persistentState) {
            return Optional.empty();
        }
        return this.handler.readScopedState(scope);
    }

    @Override
    public void registerStateProvider(GlobalStateProvider provider) {
        this.handler.registerStateProvider(provider);
        if (this.globalState != null) {
            provider.prepareForRestore(this.globalState);
        }
    }
}

