/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.transport.PhysicalAddress;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheManagerInfo
implements JsonSerialization {
    private static final Log log = LogFactory.getLog(CacheManagerInfo.class);
    public static final List<String> LOCAL_NODE = Collections.singletonList("local");
    private final DefaultCacheManager cacheManager;
    private final ConfigurationManager configurationManager;
    private final InternalCacheRegistry internalCacheRegistry;
    private final LocalTopologyManager localTopologyManager;

    public CacheManagerInfo(DefaultCacheManager cacheManager, ConfigurationManager configurationManager, InternalCacheRegistry internalCacheRegistry, LocalTopologyManager localTopologyManager) {
        this.cacheManager = cacheManager;
        this.configurationManager = configurationManager;
        this.internalCacheRegistry = internalCacheRegistry;
        this.localTopologyManager = localTopologyManager;
    }

    public String getCoordinatorAddress() {
        Transport transport = this.getTransport();
        return transport == null ? "N/A" : transport.getCoordinator().toString();
    }

    public boolean isCoordinator() {
        Transport transport = this.getTransport();
        return transport != null && transport.isCoordinator();
    }

    private Transport getTransport() {
        return SecurityActions.getGlobalComponentRegistry(this.cacheManager).getComponent(Transport.class);
    }

    public String getCacheManagerStatus() {
        return this.cacheManager.getStatus().toString();
    }

    public Set<BasicCacheInfo> getDefinedCaches() {
        return this.cacheManager.getCacheNames().stream().map(c -> {
            boolean started = this.cacheManager.getCaches().containsKey(c);
            return new BasicCacheInfo((String)c, started);
        }).collect(Collectors.toSet());
    }

    public Set<String> getCacheConfigurationNames() {
        TreeSet<String> names = new TreeSet<String>(this.configurationManager.getDefinedConfigurations());
        this.internalCacheRegistry.filterPrivateCaches(names);
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        return Immutables.immutableSetWrap(names);
    }

    public long getCreatedCacheCount() {
        return this.getCacheNames().count();
    }

    public Stream<String> getCacheNames() {
        return this.cacheManager.getCaches().keySet().stream().filter(c -> !this.internalCacheRegistry.isInternalCache((String)c));
    }

    public long getRunningCacheCount() {
        return this.cacheManager.getCaches().keySet().stream().filter(c -> this.cacheManager.isRunning((String)c) && !this.internalCacheRegistry.isInternalCache((String)c)).count();
    }

    public String getVersion() {
        return Version.getVersion();
    }

    public String getName() {
        return this.configurationManager.getGlobalConfiguration().cacheManagerName();
    }

    public String getNodeName() {
        Transport transport = this.getTransport();
        if (transport == null) {
            return this.getNodeAddress();
        }
        return transport.localNodeName();
    }

    public String getNodeAddress() {
        return this.cacheManager.getLogicalAddressString();
    }

    public String getPhysicalAddresses() {
        Transport transport = this.getTransport();
        if (transport == null) {
            return "local";
        }
        List<PhysicalAddress> address = transport.getPhysicalAddresses();
        return address == null ? "local" : address.toString();
    }

    public List<String> getPhysicalAddressesRaw() {
        Transport transport = this.getTransport();
        if (transport == null) {
            return LOCAL_NODE;
        }
        List<PhysicalAddress> address = transport.getPhysicalAddresses();
        return address == null ? LOCAL_NODE : address.stream().map(Object::toString).collect(Collectors.toList());
    }

    public List<String> getClusterMembers() {
        Transport transport = this.getTransport();
        if (transport == null) {
            return LOCAL_NODE;
        }
        return transport.getMembers().stream().map(Objects::toString).collect(Collectors.toList());
    }

    public List<String> getClusterMembersPhysicalAddresses() {
        Transport transport = this.getTransport();
        if (transport == null) {
            return LOCAL_NODE;
        }
        return transport.getMembersPhysicalAddresses().stream().map(Objects::toString).toList();
    }

    public int getClusterSize() {
        Transport transport = this.getTransport();
        if (transport == null) {
            return 1;
        }
        return transport.getMembers().size();
    }

    public String getClusterName() {
        return this.configurationManager.getGlobalConfiguration().transport().clusterName();
    }

    public String getLocalSite() {
        Transport transport = this.getTransport();
        if (transport == null) {
            return "local";
        }
        return transport.localSiteName();
    }

    public Collection<String> getSites() {
        Transport transport = this.getTransport();
        return Optional.ofNullable(transport).map(Transport::getSitesView).orElseGet(Collections::emptySet);
    }

    public boolean isRelayNode() {
        Transport transport = this.getTransport();
        return transport != null && transport.isSiteCoordinator();
    }

    public Boolean isRebalancingEnabled() {
        try {
            return this.localTopologyManager.isRebalancingEnabled();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Collection<String> getRelayNodesAddress() {
        Transport transport = this.getTransport();
        if (transport == null) {
            return LOCAL_NODE;
        }
        return transport.getRelayNodesAddress().stream().map(Objects::toString).collect(Collectors.toList());
    }

    public boolean isTracingEnabled() {
        return this.cacheManager.getConfigurationManager().getGlobalConfiguration().tracing().enabled();
    }

    public boolean allCachesStopped() {
        return this.cacheManager.getCaches().keySet().stream().noneMatch(this::isCacheReady);
    }

    public boolean isCacheReady(String cacheName) {
        boolean res = this.isCacheReadyInternal(cacheName);
        if (!res) {
            log.debugf("Cache '%s' is not ready", cacheName);
        }
        return res;
    }

    private boolean isCacheReadyInternal(String cacheName) {
        try {
            GlobalComponentRegistry gcr = SecurityActions.getGlobalComponentRegistry(this.cacheManager);
            ComponentRegistry cr = gcr.getNamedComponentRegistry(cacheName);
            if (cr == null) {
                CompletableFuture cf = (CompletableFuture)this.cacheManager.getCaches().get(cacheName);
                if (cf == null) {
                    return false;
                }
                if (cf.isDone()) {
                    if (cf.isCompletedExceptionally()) {
                        return false;
                    }
                    return ((Cache)cf.join()).getStatus().allowInvocations();
                }
                return false;
            }
            if (!cr.getStatus().allowInvocations()) {
                LocalTopologyManager ltm = gcr.getLocalTopologyManager();
                return ltm != null && ltm.isCacheRecoveringShutdown(cacheName);
            }
            if (!cr.getConfiguration().clustering().cacheMode().isClustered()) {
                return true;
            }
            DistributionManager dm = cr.getDistributionManager();
            return dm != null && !dm.isRehashInProgress();
        }
        catch (Exception e) {
            log.tracef(e, "Failed to verify if cache '%s' is ready", cacheName);
            return false;
        }
    }

    public Json toJson() {
        Json result = Json.object().set("version", (Object)this.getVersion()).set("name", (Object)this.getName()).set("coordinator", (Object)this.isCoordinator()).set("cache_configuration_names", Json.make(this.getCacheConfigurationNames())).set("cluster_name", (Object)this.getClusterName()).set("physical_addresses", (Object)this.getPhysicalAddresses()).set("coordinator_address", (Object)this.getCoordinatorAddress()).set("cache_manager_status", (Object)this.getCacheManagerStatus()).set("created_cache_count", (Object)this.getCreatedCacheCount()).set("running_cache_count", (Object)this.getRunningCacheCount()).set("node_address", (Object)this.getNodeAddress()).set("cluster_members", Json.make(this.getClusterMembers())).set("cluster_members_physical_addresses", Json.make(this.getClusterMembersPhysicalAddresses())).set("cluster_size", (Object)this.getClusterSize()).set("defined_caches", Json.make(this.getDefinedCaches())).set("local_site", (Object)this.getLocalSite()).set("relay_node", (Object)this.isRelayNode()).set("relay_nodes_address", Json.make(this.getRelayNodesAddress())).set("sites_view", Json.make(this.getSites())).set("tracing_enabled", (Object)this.isTracingEnabled());
        Boolean rebalancingEnabled = this.isRebalancingEnabled();
        if (rebalancingEnabled != null) {
            result.set("rebalancing_enabled", (Object)rebalancingEnabled);
        }
        return result;
    }

    static class BasicCacheInfo
    implements JsonSerialization {
        String name;
        boolean started;

        BasicCacheInfo(String name, boolean started) {
            this.name = name;
            this.started = started;
        }

        public String getName() {
            return this.name;
        }

        public boolean isStarted() {
            return this.started;
        }

        public Json toJson() {
            return Json.object((Object[])new Object[]{"name", this.name}).set("started", (Object)this.started);
        }
    }
}

