/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import org.infinispan.remoting.transport.Address;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ClusterExecutionPolicy {
    ALL{

        @Override
        public boolean include(Address thisAddress, Address otherAddress) {
            return true;
        }
    }
    ,
    SAME_MACHINE{

        @Override
        public boolean include(Address thisAddress, Address otherAddress) {
            return thisAddress.isSameMachine(otherAddress);
        }
    }
    ,
    DIFFERENT_MACHINE{

        @Override
        public boolean include(Address thisAddress, Address otherAddress) {
            return !thisAddress.isSameMachine(otherAddress);
        }
    }
    ,
    SAME_RACK{

        @Override
        public boolean include(Address thisAddress, Address otherAddress) {
            return thisAddress.isSameRack(otherAddress);
        }
    }
    ,
    DIFFERENT_RACK{

        @Override
        public boolean include(Address thisAddress, Address otherAddress) {
            return !thisAddress.isSameRack(otherAddress);
        }
    }
    ,
    SAME_SITE{

        @Override
        public boolean include(Address thisAddress, Address otherAddress) {
            return thisAddress.isSameSite(otherAddress);
        }
    }
    ,
    DIFFERENT_SITE{

        @Override
        public boolean include(Address thisAddress, Address otherAddress) {
            return !thisAddress.isSameSite(otherAddress);
        }
    };


    public abstract boolean include(Address var1, Address var2);
}

