/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metadata;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ProtoTypeId(value=4)
public class EmbeddedMetadata
implements Metadata {
    public static final EmbeddedMetadata EMPTY = new EmbeddedMetadata(null, null);
    protected final EntryVersion version;

    private EmbeddedMetadata(EntryVersion version) {
        this.version = version;
    }

    @ProtoFactory
    EmbeddedMetadata(NumericVersion numericVersion, SimpleClusteredVersion clusteredVersion) {
        this.version = numericVersion != null ? numericVersion : clusteredVersion;
    }

    @Override
    public long lifespan() {
        return -1L;
    }

    @Override
    public long maxIdle() {
        return -1L;
    }

    @Override
    public EntryVersion version() {
        return this.version;
    }

    @ProtoField(value=1)
    public NumericVersion getNumericVersion() {
        return this.version instanceof NumericVersion ? (NumericVersion)this.version : null;
    }

    @ProtoField(value=2)
    public SimpleClusteredVersion getClusteredVersion() {
        return this.version instanceof SimpleClusteredVersion ? (SimpleClusteredVersion)this.version : null;
    }

    @Override
    public boolean isEmpty() {
        return this.version == null;
    }

    @Override
    public Metadata.Builder builder() {
        return new Builder().version(this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddedMetadata that = (EmbeddedMetadata)o;
        return this.version != null ? this.version.equals(that.version) : that.version == null;
    }

    public int hashCode() {
        return this.version != null ? this.version.hashCode() : 0;
    }

    public String toString() {
        return "EmbeddedMetadata{version=" + String.valueOf(this.version) + "}";
    }

    private static long toMillis(long duration, TimeUnit timeUnit) {
        return duration < 0L ? -1L : timeUnit.toMillis(duration);
    }

    public static class Builder
    implements Metadata.Builder {
        protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
        protected Long lifespan = null;
        protected TimeUnit lifespanUnit = TimeUnit.MILLISECONDS;
        protected Long maxIdle = null;
        protected TimeUnit maxIdleUnit = TimeUnit.MILLISECONDS;
        protected EntryVersion version;

        @Override
        public Metadata.Builder lifespan(long time, TimeUnit unit) {
            this.lifespan = time;
            this.lifespanUnit = unit;
            return this;
        }

        @Override
        public Metadata.Builder lifespan(long time) {
            return this.lifespan(time, TimeUnit.MILLISECONDS);
        }

        @Override
        public Metadata.Builder maxIdle(long time, TimeUnit unit) {
            this.maxIdle = time;
            this.maxIdleUnit = unit;
            return this;
        }

        @Override
        public Metadata.Builder maxIdle(long time) {
            return this.maxIdle(time, TimeUnit.MILLISECONDS);
        }

        @Override
        public Metadata.Builder version(EntryVersion version) {
            this.version = version;
            return this;
        }

        @Override
        public Metadata build() {
            boolean hasLifespan = this.hasLifespan();
            boolean hasMaxIdle = this.hasMaxIdle();
            if (hasLifespan && hasMaxIdle) {
                long lifespanMillis = EmbeddedMetadata.toMillis(this.lifespan, this.lifespanUnit);
                long maxIdleMillis = EmbeddedMetadata.toMillis(this.maxIdle, this.maxIdleUnit);
                if (lifespanMillis > 0L && lifespanMillis <= maxIdleMillis) {
                    log.maxIdleGreaterThanOrEqualLifespanRuntime(maxIdleMillis, lifespanMillis);
                    maxIdleMillis = -1L;
                }
                return new EmbeddedExpirableMetadata(lifespanMillis, maxIdleMillis, this.version);
            }
            if (hasLifespan) {
                return new EmbeddedLifespanExpirableMetadata(EmbeddedMetadata.toMillis(this.lifespan, this.lifespanUnit), this.version);
            }
            if (hasMaxIdle) {
                return new EmbeddedMaxIdleExpirableMetadata(EmbeddedMetadata.toMillis(this.maxIdle, this.maxIdleUnit), this.version);
            }
            return new EmbeddedMetadata(this.version);
        }

        protected boolean hasLifespan() {
            return this.lifespan != null;
        }

        protected boolean hasMaxIdle() {
            return this.maxIdle != null;
        }

        @Override
        public Metadata.Builder merge(Metadata metadata) {
            if (this.lifespan == null) {
                this.lifespan = metadata.lifespan();
                this.lifespanUnit = TimeUnit.MILLISECONDS;
            }
            if (this.maxIdle == null) {
                this.maxIdle = metadata.maxIdle();
                this.maxIdleUnit = TimeUnit.MILLISECONDS;
            }
            if (this.version == null) {
                this.version = metadata.version();
            }
            return this;
        }
    }

    @ProtoTypeId(value=7)
    public static class EmbeddedMaxIdleExpirableMetadata
    extends EmbeddedMetadata {
        private final long maxIdle;

        @ProtoFactory
        EmbeddedMaxIdleExpirableMetadata(long maxIdle, NumericVersion numericVersion, SimpleClusteredVersion clusteredVersion) {
            this(maxIdle, numericVersion != null ? numericVersion : clusteredVersion);
        }

        private EmbeddedMaxIdleExpirableMetadata(long maxIdle, EntryVersion entryVersion) {
            super(entryVersion);
            this.maxIdle = maxIdle;
        }

        @Override
        @ProtoField(number=3, defaultValue="-1")
        public long maxIdle() {
            return this.maxIdle;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && this.maxIdle < 0L;
        }

        @Override
        public Metadata.Builder builder() {
            return super.builder().maxIdle(this.maxIdle);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EmbeddedMaxIdleExpirableMetadata that = (EmbeddedMaxIdleExpirableMetadata)o;
            return this.maxIdle == that.maxIdle;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.maxIdle);
        }

        @Override
        public String toString() {
            return "EmbeddedMaxIdleExpirableMetadata{version=" + String.valueOf(this.version) + ", maxIdle=" + this.maxIdle + "}";
        }
    }

    @ProtoTypeId(value=6)
    public static class EmbeddedLifespanExpirableMetadata
    extends EmbeddedMetadata {
        private final long lifespan;

        protected EmbeddedLifespanExpirableMetadata(long lifespan, EntryVersion version) {
            super(version);
            this.lifespan = lifespan;
        }

        @ProtoFactory
        protected EmbeddedLifespanExpirableMetadata(long lifespan, NumericVersion numericVersion, SimpleClusteredVersion clusteredVersion) {
            this(lifespan, numericVersion != null ? numericVersion : clusteredVersion);
        }

        @Override
        @ProtoField(number=3, defaultValue="-1")
        public long lifespan() {
            return this.lifespan;
        }

        @Override
        public Metadata.Builder builder() {
            return super.builder().lifespan(this.lifespan);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && this.lifespan < 0L;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EmbeddedLifespanExpirableMetadata that = (EmbeddedLifespanExpirableMetadata)o;
            return this.lifespan == that.lifespan;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.lifespan);
        }

        @Override
        public String toString() {
            return "EmbeddedLifespanExpirableMetadata{lifespan=" + this.lifespan + ", version=" + String.valueOf(this.version) + "}";
        }
    }

    @ProtoTypeId(value=5)
    public static class EmbeddedExpirableMetadata
    extends EmbeddedMetadata {
        private final long lifespan;
        private final long maxIdle;

        @ProtoFactory
        EmbeddedExpirableMetadata(long lifespan, long maxIdle, NumericVersion numericVersion, SimpleClusteredVersion clusteredVersion) {
            this(lifespan, maxIdle, numericVersion != null ? numericVersion : clusteredVersion);
        }

        private EmbeddedExpirableMetadata(long lifespan, long maxIdle, EntryVersion version) {
            super(version);
            this.lifespan = lifespan;
            this.maxIdle = maxIdle;
        }

        @Override
        @ProtoField(number=3, defaultValue="-1")
        public long lifespan() {
            return this.lifespan;
        }

        @Override
        @ProtoField(number=4, defaultValue="-1")
        public long maxIdle() {
            return this.maxIdle;
        }

        @Override
        public Metadata.Builder builder() {
            return super.builder().lifespan(this.lifespan).maxIdle(this.maxIdle);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && this.lifespan < 0L && this.maxIdle < 0L;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EmbeddedExpirableMetadata that = (EmbeddedExpirableMetadata)o;
            return this.lifespan == that.lifespan && this.maxIdle == that.maxIdle;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.lifespan, this.maxIdle);
        }

        @Override
        public String toString() {
            return "EmbeddedExpirableMetadata{version=" + String.valueOf(this.version) + ", lifespan=" + this.lifespan + ", maxIdle=" + this.maxIdle + "}";
        }
    }
}

