/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.wikilink.internal;

import com.vladsch.flexmark.ext.wikilink.WikiImage;
import com.vladsch.flexmark.ext.wikilink.WikiLink;
import com.vladsch.flexmark.ext.wikilink.WikiNode;
import com.vladsch.flexmark.ext.wikilink.internal.WikiLinkOptions;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.formatter.FormattingPhase;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.PhasedNodeFormatter;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.mappers.SpaceMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WikiLinkNodeFormatter
implements PhasedNodeFormatter {
    public static final HashSet<FormattingPhase> FORMATTING_PHASES = new HashSet<FormattingPhase>(Arrays.asList(FormattingPhase.COLLECT, FormattingPhase.DOCUMENT_TOP));
    private Map<String, String> attributeUniquificationIdMap;
    private WikiLinkOptions options;

    public WikiLinkNodeFormatter(DataHolder options) {
    }

    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(WikiLink.class, this::render), new NodeFormattingHandler(WikiImage.class, this::render)));
    }

    @Nullable
    public Set<Class<?>> getNodeClasses() {
        return new HashSet(Arrays.asList(WikiLink.class, WikiImage.class));
    }

    @Nullable
    public Set<FormattingPhase> getFormattingPhases() {
        return FORMATTING_PHASES;
    }

    public void renderDocument(@NotNull NodeFormatterContext context, @NotNull MarkdownWriter markdown, @NotNull Document document, @NotNull FormattingPhase phase) {
        this.attributeUniquificationIdMap = (Map)Formatter.ATTRIBUTE_UNIQUIFICATION_ID_MAP.get((DataHolder)context.getTranslationStore());
        this.options = new WikiLinkOptions((DataHolder)document);
    }

    private void render(WikiLink node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append((CharSequence)node.getOpeningMarker());
        if (node.isLinkIsFirst()) {
            this.renderLink(node, context, markdown);
            this.renderText(node, context, markdown);
        } else {
            this.renderText(node, context, markdown);
            this.renderLink(node, context, markdown);
        }
        markdown.append((CharSequence)node.getClosingMarker());
    }

    private void render(WikiImage node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append((CharSequence)node.getOpeningMarker());
        if (node.isLinkIsFirst()) {
            this.renderLink(node, context, markdown);
            this.renderText(node, context, markdown);
        } else {
            this.renderText(node, context, markdown);
            this.renderLink(node, context, markdown);
        }
        markdown.append((CharSequence)node.getClosingMarker());
    }

    private void renderText(WikiNode node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (!context.isTransformingText()) {
            if (node.getText().isNotNull()) {
                if (node.isLinkIsFirst()) {
                    markdown.append((CharSequence)node.getTextSeparatorMarker());
                }
                if (context.getFormatterOptions().rightMargin > 0) {
                    markdown.append((CharSequence)node.getText().toMapped(SpaceMapper.toNonBreakSpace));
                } else {
                    context.renderChildren((Node)node);
                }
                if (!node.isLinkIsFirst()) {
                    markdown.append((CharSequence)node.getTextSeparatorMarker());
                }
            }
        } else {
            switch (context.getRenderPurpose()) {
                case TRANSLATION_SPANS: 
                case TRANSLATED_SPANS: {
                    BasedSequence text;
                    if (node.isLinkIsFirst()) {
                        markdown.append('|');
                    }
                    BasedSequence basedSequence = text = node.getText().isNull() ? node.getPageRef() : node.getText();
                    if (this.options.allowInlines) {
                        context.renderChildren((Node)node);
                    } else {
                        markdown.appendTranslating((CharSequence)text.unescape());
                    }
                    if (node.isLinkIsFirst()) break;
                    markdown.append('|');
                    break;
                }
                case TRANSLATED: {
                    if (node.isLinkIsFirst()) {
                        markdown.append((CharSequence)node.getTextSeparatorMarker());
                    }
                    if (this.options.allowInlines) {
                        context.renderChildren((Node)node);
                    } else {
                        CharSequence translated = context.transformTranslating(null, (CharSequence)node.getText(), null, null);
                        markdown.append(this.escapePipeAnchors(translated));
                    }
                    if (node.isLinkIsFirst()) break;
                    markdown.append((CharSequence)node.getTextSeparatorMarker());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected renderer purpose");
                }
            }
        }
    }

    private CharSequence escapeUnescapedPipeAnchors(CharSequence chars) {
        boolean isEscaped = false;
        int iMax = chars.length();
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < iMax; ++i) {
            char c = chars.charAt(i);
            switch (c) {
                case '\\': {
                    isEscaped = !isEscaped;
                    break;
                }
                case '|': {
                    if (isEscaped || !this.options.allowPipeEscape) break;
                    text.append('\\');
                    break;
                }
                case '#': {
                    if (isEscaped || !this.options.allowAnchors || !this.options.allowAnchorEscape) break;
                    text.append('\\');
                    break;
                }
                default: {
                    isEscaped = false;
                }
            }
            text.append(c);
        }
        if (isEscaped) {
            text.append('\\');
        }
        return text;
    }

    private CharSequence escapePipeAnchors(CharSequence chars) {
        int iMax = chars.length();
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < iMax; ++i) {
            char c = chars.charAt(i);
            switch (c) {
                case '\\': {
                    text.append('\\');
                    break;
                }
                case '|': {
                    if (!this.options.allowPipeEscape) break;
                    text.append('\\');
                    break;
                }
                case '#': {
                    if (!this.options.allowAnchors || !this.options.allowAnchorEscape) break;
                    text.append('\\');
                    break;
                }
            }
            text.append(c);
        }
        return text;
    }

    private void renderLink(WikiNode node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (!context.isTransformingText()) {
            if (context.getFormatterOptions().rightMargin > 0) {
                markdown.append((CharSequence)node.getLink().toMapped(SpaceMapper.toNonBreakSpace));
            } else {
                markdown.append((CharSequence)node.getLink());
            }
        } else if (context.getRenderPurpose() == RenderPurpose.TRANSLATION_SPANS) {
            markdown.appendNonTranslating((CharSequence)node.getPageRef());
            markdown.append((CharSequence)node.getAnchorMarker());
            if (node.getAnchorRef().isNotNull()) {
                CharSequence anchorRef = context.transformAnchorRef((CharSequence)node.getPageRef(), (CharSequence)node.getAnchorRef());
                markdown.append(anchorRef);
            }
        } else {
            CharSequence pageRef = context.transformNonTranslating(null, (CharSequence)node.getPageRef(), null, null);
            markdown.append(this.escapeUnescapedPipeAnchors(pageRef));
            markdown.append((CharSequence)node.getAnchorMarker());
            if (node.getAnchorRef().isNotNull()) {
                CharSequence anchorRef = context.transformAnchorRef((CharSequence)node.getPageRef(), (CharSequence)node.getAnchorRef());
                if (this.attributeUniquificationIdMap != null && context.getRenderPurpose() == RenderPurpose.TRANSLATED && context.getMergeContext() != null) {
                    String uniquifiedAnchorRef = String.valueOf(anchorRef);
                    if (pageRef.length() == 0) {
                        uniquifiedAnchorRef = this.attributeUniquificationIdMap.getOrDefault(uniquifiedAnchorRef, uniquifiedAnchorRef);
                    }
                    markdown.append((CharSequence)uniquifiedAnchorRef);
                } else {
                    markdown.append(anchorRef);
                }
            }
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        @NotNull
        public NodeFormatter create(@NotNull DataHolder options) {
            return new WikiLinkNodeFormatter(options);
        }
    }
}

