/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.AuthenticationSteps;
import org.springframework.vault.authentication.AuthenticationStepsFactory;
import org.springframework.vault.authentication.AuthenticationUtil;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.GitHubAuthenticationOptions;
import org.springframework.vault.authentication.LoginTokenUtil;
import org.springframework.vault.authentication.VaultLoginException;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

public class GitHubAuthentication
implements ClientAuthentication,
AuthenticationStepsFactory {
    private static final Log logger = LogFactory.getLog(GitHubAuthentication.class);
    private final GitHubAuthenticationOptions options;
    private final RestOperations restOperations;

    public GitHubAuthentication(GitHubAuthenticationOptions options, RestOperations restOperations) {
        Assert.notNull((Object)options, (String)"GithubAuthenticationOptions must not be null");
        Assert.notNull((Object)restOperations, (String)"RestOperations must not be null");
        this.options = options;
        this.restOperations = restOperations;
    }

    public static AuthenticationSteps createAuthenticationSteps(GitHubAuthenticationOptions options) {
        Assert.notNull((Object)options, (String)"GitHubAuthentication must not be null");
        return AuthenticationSteps.fromSupplier(options.getTokenSupplier()).map(GitHubAuthentication::getGitHubLogin).login(AuthenticationUtil.getLoginPath(options.getPath()), new String[0]);
    }

    @Override
    public AuthenticationSteps getAuthenticationSteps() {
        return GitHubAuthentication.createAuthenticationSteps(this.options);
    }

    @Override
    public VaultToken login() throws VaultException {
        Map<String, String> login = GitHubAuthentication.getGitHubLogin(this.options.getTokenSupplier().get());
        try {
            VaultResponse response = (VaultResponse)this.restOperations.postForObject(AuthenticationUtil.getLoginPath(this.options.getPath()), login, VaultResponse.class, new Object[0]);
            Assert.state((response != null && response.getAuth() != null ? 1 : 0) != 0, (String)"Auth field must not be null");
            logger.debug((Object)"Login successful using GitHub authentication");
            return LoginTokenUtil.from(response.getAuth());
        }
        catch (RestClientException e) {
            throw VaultLoginException.create("GitHub", e);
        }
    }

    private static Map<String, String> getGitHubLogin(String token) {
        return Map.of("token", token);
    }
}

