/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.HttpsSupport;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.util.Timeout;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.PemObject;
import org.springframework.vault.support.SslConfiguration;

public class ClientHttpRequestFactoryFactory {
    private static Log logger = LogFactory.getLog(ClientHttpRequestFactoryFactory.class);
    private static final boolean httpComponentsPresent = ClassUtils.isPresent((String)"org.apache.hc.client5.http.impl.classic.HttpClientBuilder", (ClassLoader)ClientHttpRequestFactoryFactory.class.getClassLoader());
    private static final boolean okHttp3Present = ClassUtils.isPresent((String)"okhttp3.OkHttpClient", (ClassLoader)ClientHttpRequestFactoryFactory.class.getClassLoader());

    public static ClientHttpRequestFactory create(ClientOptions options, SslConfiguration sslConfiguration) {
        Assert.notNull((Object)options, (String)"ClientOptions must not be null");
        Assert.notNull((Object)sslConfiguration, (String)"SslConfiguration must not be null");
        try {
            if (httpComponentsPresent) {
                return HttpComponents.usingHttpComponents(options, sslConfiguration);
            }
            if (okHttp3Present) {
                return OkHttp3.usingOkHttp3(options, sslConfiguration);
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
        if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
            logger.warn((Object)"VaultProperties has SSL configured but the SSL configuration must be applied outside the Vault Client to use the JDK HTTP client");
        }
        return SimpleClient.usingSimpleClientHttpRequest(options);
    }

    static SSLContext getSSLContext(SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
        return ClientHttpRequestFactoryFactory.getSSLContext(sslConfiguration.getKeyStoreConfiguration(), sslConfiguration.getKeyConfiguration(), ClientHttpRequestFactoryFactory.getTrustManagers(sslConfiguration));
    }

    static SSLContext getSSLContext(SslConfiguration.KeyStoreConfiguration keyStoreConfiguration, SslConfiguration.KeyConfiguration keyConfiguration, @Nullable TrustManager[] trustManagers) throws GeneralSecurityException, IOException {
        KeyManager[] keyManagers = keyStoreConfiguration.isPresent() ? ClientHttpRequestFactoryFactory.createKeyManagerFactory(keyStoreConfiguration, keyConfiguration).getKeyManagers() : null;
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    static KeyManagerFactory createKeyManagerFactory(SslConfiguration.KeyStoreConfiguration keyStoreConfiguration, SslConfiguration.KeyConfiguration keyConfiguration) throws GeneralSecurityException, IOException {
        KeyStore keyStore = ClientHttpRequestFactoryFactory.getKeyStore(keyStoreConfiguration);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        char[] keyPasswordToUse = keyConfiguration.getKeyPassword();
        if (keyPasswordToUse == null) {
            keyPasswordToUse = keyStoreConfiguration.getStorePassword() == null ? new char[]{} : keyStoreConfiguration.getStorePassword();
        }
        keyManagerFactory.init(keyStore, keyPasswordToUse);
        if (StringUtils.hasText((String)keyConfiguration.getKeyAlias())) {
            return new KeySelectingKeyManagerFactory(keyManagerFactory, keyConfiguration);
        }
        return keyManagerFactory;
    }

    static KeyStore getKeyStore(SslConfiguration.KeyStoreConfiguration keyStoreConfiguration) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(ClientHttpRequestFactoryFactory.getKeyStoreType(keyStoreConfiguration));
        ClientHttpRequestFactoryFactory.loadKeyStore(keyStoreConfiguration, keyStore);
        return keyStore;
    }

    @Nullable
    static TrustManager[] getTrustManagers(SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
        return sslConfiguration.getTrustStoreConfiguration().isPresent() ? ClientHttpRequestFactoryFactory.createTrustManagerFactory(sslConfiguration.getTrustStoreConfiguration()).getTrustManagers() : null;
    }

    private static String getKeyStoreType(SslConfiguration.KeyStoreConfiguration keyStoreConfiguration) {
        if (StringUtils.hasText((String)keyStoreConfiguration.getStoreType()) && !"PEM".equalsIgnoreCase(keyStoreConfiguration.getStoreType())) {
            return keyStoreConfiguration.getStoreType();
        }
        return KeyStore.getDefaultType();
    }

    static TrustManagerFactory createTrustManagerFactory(SslConfiguration.KeyStoreConfiguration keyStoreConfiguration) throws GeneralSecurityException, IOException {
        KeyStore trustStore = ClientHttpRequestFactoryFactory.getKeyStore(keyStoreConfiguration);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return trustManagerFactory;
    }

    private static void loadKeyStore(SslConfiguration.KeyStoreConfiguration keyStoreConfiguration, KeyStore keyStore) throws IOException, GeneralSecurityException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading keystore from %s".formatted(keyStoreConfiguration.getResource()));
        }
        try (InputStream inputStream = null;){
            inputStream = keyStoreConfiguration.getResource().getInputStream();
            if ("PEM".equalsIgnoreCase(keyStoreConfiguration.getStoreType())) {
                keyStore.load(null);
                ClientHttpRequestFactoryFactory.loadFromPem(keyStore, inputStream);
            } else {
                keyStore.load(inputStream, keyStoreConfiguration.getStorePassword());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Keystore loaded with %d entries".formatted(keyStore.size()));
            }
        }
    }

    private static void loadFromPem(KeyStore keyStore, InputStream inputStream) throws IOException, KeyStoreException {
        List<PemObject> pemObjects = PemObject.parse(new String(FileCopyUtils.copyToByteArray((InputStream)inputStream)));
        for (PemObject pemObject : pemObjects) {
            if (!pemObject.isCertificate()) continue;
            X509Certificate cert = pemObject.getCertificate();
            String alias = cert.getSubjectX500Principal().getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Adding certificate with alias %s".formatted(alias));
            }
            keyStore.setCertificateEntry(alias, cert);
        }
    }

    static boolean hasSslConfiguration(SslConfiguration sslConfiguration) {
        return sslConfiguration.getTrustStoreConfiguration().isPresent() || sslConfiguration.getKeyStoreConfiguration().isPresent();
    }

    public static class HttpComponents {
        public static HttpComponentsClientHttpRequestFactory usingHttpComponents(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            HttpClientBuilder httpClientBuilder = HttpComponents.getHttpClientBuilder(options, sslConfiguration);
            return new HttpComponentsClientHttpRequestFactory((HttpClient)httpClientBuilder.build());
        }

        public static HttpClientBuilder getHttpClientBuilder(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner((SchemePortResolver)DefaultSchemePortResolver.INSTANCE, ProxySelector.getDefault()));
            Timeout readTimeout = Timeout.ofMilliseconds((long)options.getReadTimeout().toMillis());
            Timeout connectTimeout = Timeout.ofMilliseconds((long)options.getConnectionTimeout().toMillis());
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(readTimeout).build();
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(connectTimeout).setResponseTimeout(readTimeout).setAuthenticationEnabled(true).setRedirectsEnabled(true).build();
            PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create().setDefaultConnectionConfig(connectionConfig).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(readTimeout).build());
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                SSLContext sslContext = ClientHttpRequestFactoryFactory.getSSLContext(sslConfiguration);
                String[] enabledProtocols = null;
                if (!sslConfiguration.getEnabledProtocols().isEmpty()) {
                    enabledProtocols = sslConfiguration.getEnabledProtocols().toArray(new String[0]);
                }
                String[] enabledCipherSuites = null;
                if (!sslConfiguration.getEnabledCipherSuites().isEmpty()) {
                    enabledCipherSuites = sslConfiguration.getEnabledCipherSuites().toArray(new String[0]);
                }
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, enabledProtocols, enabledCipherSuites, HttpsSupport.getDefaultHostnameVerifier());
                connectionManagerBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
            }
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManagerBuilder.build());
            return httpClientBuilder;
        }
    }

    public static class OkHttp3 {
        public static OkHttp3ClientHttpRequestFactory usingOkHttp3(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            OkHttpClient.Builder builder = OkHttp3.getBuilder(options, sslConfiguration);
            return new OkHttp3ClientHttpRequestFactory(builder.build());
        }

        public static OkHttpClient.Builder getBuilder(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            ConnectionSpec sslConnectionSpec = ConnectionSpec.MODERN_TLS;
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                Object[] trustManagers = ClientHttpRequestFactoryFactory.getTrustManagers(sslConfiguration);
                if (trustManagers == null || trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                    throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
                }
                SSLContext sslContext = ClientHttpRequestFactoryFactory.getSSLContext(sslConfiguration.getKeyStoreConfiguration(), sslConfiguration.getKeyConfiguration(), (TrustManager[])trustManagers);
                ConnectionSpec.Builder sslConnectionSpecBuilder = new ConnectionSpec.Builder(sslConnectionSpec);
                if (!sslConfiguration.getEnabledProtocols().isEmpty()) {
                    sslConnectionSpecBuilder.tlsVersions(sslConfiguration.getEnabledProtocols().toArray(new String[0]));
                }
                if (!sslConfiguration.getEnabledCipherSuites().isEmpty()) {
                    sslConnectionSpecBuilder.cipherSuites(sslConfiguration.getEnabledCipherSuites().toArray(new String[0]));
                }
                sslConnectionSpec = sslConnectionSpecBuilder.build();
                builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagers[0]);
            }
            builder.connectionSpecs(Arrays.asList(sslConnectionSpec, ConnectionSpec.CLEARTEXT));
            builder.connectTimeout(options.getConnectionTimeout().toMillis(), TimeUnit.MILLISECONDS).readTimeout(options.getReadTimeout().toMillis(), TimeUnit.MILLISECONDS);
            return builder;
        }
    }

    public static class SimpleClient {
        public static SimpleClientHttpRequestFactory usingSimpleClientHttpRequest(ClientOptions options) {
            SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
            factory.setConnectTimeout((int)options.getConnectionTimeout().toMillis());
            factory.setReadTimeout((int)options.getReadTimeout().toMillis());
            return factory;
        }
    }

    static class KeySelectingKeyManagerFactory
    extends KeyManagerFactory {
        KeySelectingKeyManagerFactory(final KeyManagerFactory factory, final SslConfiguration.KeyConfiguration keyConfiguration) {
            super(new KeyManagerFactorySpi(){

                @Override
                protected void engineInit(KeyStore keyStore, char[] chars) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
                    factory.init(keyStore, chars);
                }

                @Override
                protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
                    factory.init(managerFactoryParameters);
                }

                @Override
                protected KeyManager[] engineGetKeyManagers() {
                    KeyManager[] keyManagers = factory.getKeyManagers();
                    if (keyManagers.length == 1 && keyManagers[0] instanceof X509ExtendedKeyManager) {
                        return new KeyManager[]{new KeySelectingX509KeyManager((X509ExtendedKeyManager)keyManagers[0], keyConfiguration)};
                    }
                    return keyManagers;
                }
            }, factory.getProvider(), factory.getAlgorithm());
        }
    }

    private static class KeySelectingX509KeyManager
    extends X509ExtendedKeyManager {
        private final X509ExtendedKeyManager delegate;
        private final SslConfiguration.KeyConfiguration keyConfiguration;

        KeySelectingX509KeyManager(X509ExtendedKeyManager delegate, SslConfiguration.KeyConfiguration keyConfiguration) {
            this.delegate = delegate;
            this.keyConfiguration = keyConfiguration;
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.delegate.getClientAliases(keyType, issuers);
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.keyConfiguration.getKeyAlias();
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            return this.keyConfiguration.getKeyAlias();
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.delegate.getServerAliases(keyType, issuers);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.delegate.chooseServerAlias(keyType, issuers, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.delegate.getCertificateChain(alias);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.delegate.getPrivateKey(alias);
        }
    }
}

