/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import java.util.Collections;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.core.KeyValueUtilities;
import org.springframework.vault.core.ReactiveVaultKeyValue2Accessor;
import org.springframework.vault.core.ReactiveVaultKeyValueOperations;
import org.springframework.vault.core.ReactiveVaultOperations;
import org.springframework.vault.core.SecretNotFoundException;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultResponseSupport;
import reactor.core.publisher.Mono;

class ReactiveVaultKeyValue2Template
extends ReactiveVaultKeyValue2Accessor
implements ReactiveVaultKeyValueOperations {
    private final String path;

    public ReactiveVaultKeyValue2Template(ReactiveVaultOperations vaultOperations, String path) {
        super(vaultOperations, path);
        this.path = path;
    }

    @Override
    public Mono<VaultResponse> get(String path) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        return this.doRead(path, Map.class, (response, data) -> {
            VaultResponse vaultResponse = new VaultResponse();
            vaultResponse.applyMetadata((VaultResponseSupport<?>)response);
            vaultResponse.setData(data);
            return vaultResponse;
        });
    }

    @Override
    public <T> Mono<VaultResponseSupport<T>> get(String path, Class<T> responseType) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        Assert.notNull(responseType, (String)"Response type must not be null");
        return this.doRead(path, responseType, (response, data) -> {
            VaultResponseSupport result = response;
            result.setData(data);
            return result;
        });
    }

    @Override
    public Mono<Boolean> patch(String path, Map<String, ?> patch) {
        Assert.notNull(patch, (String)"Patch body must not be null");
        return this.get(path).filter(it -> it.getData() != null).switchIfEmpty(Mono.error((Throwable)((Object)new SecretNotFoundException("No data found at %s; patch only works on existing data".formatted(this.createDataPath(path)), this.createLogicalPath(path))))).flatMap(readResponse -> {
            if (readResponse.getMetadata() == null) {
                return Mono.error((Throwable)((Object)new VaultException("Metadata must not be null")));
            }
            Map<String, Object> body = KeyValueUtilities.createPatchRequest(patch, (Map)readResponse.getRequiredData(), readResponse.getMetadata());
            return this.doWrite(this.createDataPath(path), body).thenReturn((Object)true).onErrorResume(VaultException.class, e -> {
                if (e.getMessage() != null && (e.getMessage().contains("check-and-set") || e.getMessage().contains("did not match the current version"))) {
                    return Mono.just((Object)Boolean.FALSE);
                }
                return Mono.error((Throwable)((Object)e));
            });
        });
    }

    @Override
    public Mono<Void> put(String path, Object body) {
        return this.doWrite(this.createDataPath(path), Collections.singletonMap("data", body)).then();
    }

    private String createLogicalPath(String path) {
        return "%s/%s".formatted(this.path, path);
    }
}

