/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import java.util.Arrays;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class VaultTransformContext {
    private static final VaultTransformContext EMPTY = new VaultTransformContext("", new byte[0], null);
    private final String transformation;
    private final byte[] tweak;
    @Nullable
    private final String reference;

    private VaultTransformContext(String transformation, byte[] tweak, @Nullable String reference) {
        this.transformation = transformation;
        this.tweak = tweak;
        this.reference = reference;
    }

    public static VaultTransformRequestBuilder builder() {
        return new VaultTransformRequestBuilder();
    }

    public static VaultTransformContext empty() {
        return EMPTY;
    }

    public static VaultTransformContext fromTransformation(String transformation) {
        return VaultTransformContext.builder().transformation(transformation).build();
    }

    public static VaultTransformContext fromTweak(byte[] tweak) {
        return VaultTransformContext.builder().tweak(tweak).build();
    }

    public boolean isEmpty() {
        return ObjectUtils.isEmpty((Object)this.transformation) && ObjectUtils.isEmpty((Object)this.tweak) && ObjectUtils.isEmpty((Object)this.reference);
    }

    public String getTransformation() {
        return this.transformation;
    }

    public byte[] getTweak() {
        return this.tweak;
    }

    @Nullable
    public String getReference() {
        return this.reference;
    }

    public VaultTransformRequestBuilder mutate() {
        return new VaultTransformRequestBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VaultTransformContext)) {
            return false;
        }
        VaultTransformContext that = (VaultTransformContext)o;
        return this.transformation.equals(that.transformation) && Arrays.equals(this.tweak, that.tweak) && ObjectUtils.nullSafeEquals((Object)this.reference, (Object)that.reference);
    }

    public int hashCode() {
        int result = this.transformation.hashCode();
        result = 31 * result + Arrays.hashCode(this.tweak);
        result = 31 * result + ObjectUtils.nullSafeHash((Object[])new Object[]{this.reference});
        return result;
    }

    public static class VaultTransformRequestBuilder {
        private String transformation = "";
        private byte[] tweak = new byte[0];
        @Nullable
        private String reference;

        private VaultTransformRequestBuilder() {
        }

        private VaultTransformRequestBuilder(VaultTransformContext context) {
            this.transformation = context.transformation;
            this.tweak = Arrays.copyOf(context.tweak, context.tweak.length);
            this.reference = context.reference;
        }

        public VaultTransformRequestBuilder transformation(String transformation) {
            Assert.notNull((Object)transformation, (String)"Transformation must not be null");
            this.transformation = transformation;
            return this;
        }

        public VaultTransformRequestBuilder tweak(byte[] tweak) {
            Assert.notNull((Object)tweak, (String)"Tweak must not be null");
            this.tweak = tweak;
            return this;
        }

        public VaultTransformRequestBuilder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public VaultTransformContext build() {
            return new VaultTransformContext(this.transformation, this.tweak, this.reference);
        }
    }
}

