/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs;

import org.jgroups.Address;
import org.jgroups.blocks.cs.BaseServer;
import org.jgroups.blocks.cs.TcpConnection;
import org.jgroups.blocks.cs.TcpConnectionNonBlocking;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;

public abstract class TcpBaseServer
extends BaseServer {
    protected int peer_addr_read_timeout = 2000;
    protected int buffered_inputstream_size = 8192;
    protected int buffered_outputstream_size = 8192;
    protected boolean non_blocking_sends;
    protected int max_send_queue = 1024;
    protected boolean use_lock_to_send = true;

    protected TcpBaseServer(ThreadFactory f, SocketFactory sf, int recv_buf_size) {
        super(f, sf, recv_buf_size);
    }

    @Override
    protected TcpConnection createConnection(Address dest) throws Exception {
        return this.non_blocking_sends ? (TcpConnection)new TcpConnectionNonBlocking(dest, this, this.max_send_queue).useLockToSend(this.use_lock_to_send) : (TcpConnection)new TcpConnection(dest, this).useLockToSend(this.use_lock_to_send);
    }

    public int peerAddressReadTimeout() {
        return this.peer_addr_read_timeout;
    }

    public TcpBaseServer peerAddressReadTimeout(int t) {
        this.peer_addr_read_timeout = t;
        return this;
    }

    public int getBufferedInputStreamSize() {
        return this.buffered_inputstream_size;
    }

    public TcpBaseServer setBufferedInputStreamSize(int s) {
        this.buffered_inputstream_size = s;
        return this;
    }

    public int getBufferedOutputStreamSize() {
        return this.buffered_outputstream_size;
    }

    public TcpBaseServer setBufferedOutputStreamSize(int s) {
        this.buffered_outputstream_size = s;
        return this;
    }

    public boolean nonBlockingSends() {
        return this.non_blocking_sends;
    }

    public TcpBaseServer nonBlockingSends(boolean b) {
        this.non_blocking_sends = b;
        return this;
    }

    public int maxSendQueue() {
        return this.max_send_queue;
    }

    public TcpBaseServer maxSendQueue(int s) {
        this.max_send_queue = s;
        return this;
    }

    public boolean useLockToSend() {
        return this.use_lock_to_send;
    }

    public TcpBaseServer useLockToSend(boolean u) {
        this.use_lock_to_send = u;
        return this;
    }
}

