/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.LongAdder;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.jgroups.Address;
import org.jgroups.blocks.cs.TcpBaseServer;
import org.jgroups.blocks.cs.TcpConnection;
import org.jgroups.blocks.cs.TcpServer;
import org.jgroups.util.ByteArray;
import org.jgroups.util.ConcurrentLinkedBlockingQueue;
import org.jgroups.util.FastArray;
import org.jgroups.util.Runner;
import org.jgroups.util.Util;

public class TcpConnectionNonBlocking
extends TcpConnection
implements Runnable {
    protected final BlockingQueue<ByteArray> queue;
    protected int max_size = 1024;
    protected final Runner sender;
    protected final LongAdder dropped_msgs = new LongAdder();
    protected final FastArray<ByteArray> remove_queue;
    protected int rq_capacity;

    public TcpConnectionNonBlocking(Address peer_addr, TcpBaseServer server, int max_size) throws Exception {
        super(peer_addr, server);
        this.max_size = max_size;
        this.queue = new ConcurrentLinkedBlockingQueue<ByteArray>(max_size, true, false);
        this.rq_capacity = max_size / 5;
        this.remove_queue = new FastArray(this.rq_capacity);
        this.sender = new Runner(server.factory, String.format("sender to %s", peer_addr), this, null);
    }

    public TcpConnectionNonBlocking(Socket s, TcpServer server, int max_size) throws Exception {
        super(s, server);
        this.max_size = max_size;
        this.queue = new ConcurrentLinkedBlockingQueue<ByteArray>(max_size, true, false);
        this.rq_capacity = max_size / 5;
        this.remove_queue = new FastArray(this.rq_capacity);
        this.sender = new Runner(server.factory, String.format("sender to %s", this.peer_addr), this, null);
    }

    public int maxSize() {
        return this.max_size;
    }

    public long droppedMessages() {
        return this.dropped_msgs.sum();
    }

    public int queueSize() {
        return this.queue != null ? this.queue.size() : 0;
    }

    public boolean senderRunning() {
        return this.sender.isRunning();
    }

    @Override
    public void start() {
        super.start();
        this.sender.start();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.sender.stop();
    }

    @Override
    public void send(byte[] data, int offset, int length) throws Exception {
        ByteArray buf = new ByteArray(data, offset, length).copy();
        boolean added = this.queue.offer(buf);
        if (!added) {
            this.dropped_msgs.increment();
        }
    }

    @Override
    public void run() {
        block9: {
            try {
                if (!this.isConnected()) {
                    return;
                }
                do {
                    this.remove_queue.clear(false);
                    this.remove_queue.add(this.queue.take());
                    this.queue.drainTo(this.remove_queue, this.rq_capacity - 1);
                    for (ByteArray data : this.remove_queue) {
                        this.doSend(data.array(), data.offset(), data.length(), false);
                    }
                    this.flush();
                } while (!this.queue.isEmpty());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (EOFException | SocketException iOException) {
            }
            catch (Exception e) {
                if (e instanceof SSLException && e.getMessage().contains("Socket closed") || e instanceof SSLHandshakeException && e.getCause() instanceof EOFException) break block9;
                if (this.server.logDetails()) {
                    this.server.log.warn("failed sending message", e);
                } else {
                    this.server.log.warn("failed sending message: " + String.valueOf(e));
                }
                this.server.notifyConnectionClosed(this);
            }
        }
    }

    @Override
    public String toString() {
        return String.format("%s [%d/%d, %d drops, sender: %b]", super.toString(), this.queueSize(), this.maxSize(), this.droppedMessages(), this.senderRunning());
    }

    protected String name() {
        InetAddress local = this.sock.getLocalAddress();
        InetAddress remote = this.sock.getInetAddress();
        String l = local != null ? Util.shortName(local) : "<null>";
        String r = remote != null ? Util.shortName(remote) : "<null>";
        return String.format("Connection.Sender [%s:%s-%s:%s]", l, this.sock.getLocalPort(), r, this.sock.getPort());
    }
}

