/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlNode;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

public class XmlConfigurator
implements ProtocolStackConfigurator {
    private final List<ProtocolConfiguration> configuration = new ArrayList<ProtocolConfiguration>();
    protected static final Log log = LogFactory.getLog(XmlConfigurator.class);

    protected XmlConfigurator(List<ProtocolConfiguration> protocols) {
        this.configuration.addAll(protocols);
    }

    public static XmlConfigurator getInstance(InputStream stream) throws IOException {
        return XmlConfigurator.parse(stream);
    }

    public String getProtocolStackString(boolean convert) {
        StringBuilder buf = new StringBuilder();
        Iterator<ProtocolConfiguration> it = this.configuration.iterator();
        if (convert) {
            buf.append("<config>\n");
        }
        while (it.hasNext()) {
            ProtocolConfiguration d = it.next();
            if (convert) {
                buf.append("    <");
            }
            buf.append(d.getProtocolString(convert));
            if (convert) {
                buf.append("/>");
            }
            if (!it.hasNext()) continue;
            if (convert) {
                buf.append('\n');
                continue;
            }
            buf.append(':');
        }
        if (convert) {
            buf.append("\n</config>");
        }
        return buf.toString();
    }

    @Override
    public String getProtocolStackString() {
        return this.getProtocolStackString(false);
    }

    @Override
    public List<ProtocolConfiguration> getProtocolStack() {
        return this.configuration;
    }

    protected static XmlConfigurator parse(InputStream stream) throws IOException {
        try {
            XmlNode root = XmlConfigurator.parseXmlDocument(stream);
            boolean has_includes = root.getChildren().stream().anyMatch(c -> c.getName().equals("include"));
            if (has_includes) {
                List<XmlNode> children = root.getChildren();
                ArrayList<XmlNode> new_children = new ArrayList<XmlNode>(children.size() + 5);
                for (XmlNode child : children) {
                    if ("include".equals(child.getName())) {
                        String filename = child.getAttribute("file");
                        filename = Util.substituteVariable(filename);
                        child.removeAttribute("file");
                        try (InputStream input_stream = ConfiguratorFactory.getConfigStream(filename);){
                            if (input_stream == null) {
                                throw new FileNotFoundException(String.format(Util.getMessage("FileNotFound"), filename));
                            }
                            XmlNode new_child = XmlConfigurator.parseXmlDocument(input_stream);
                            if (!new_child.getName().equals("config")) {
                                new_children.add(new_child);
                            } else {
                                new_children.addAll(new_child.getChildren());
                            }
                        }
                        for (Map.Entry<String, String> e : child.getAttributes().entrySet()) {
                            String key = e.getKey();
                            String val = e.getValue();
                            for (XmlNode c2 : new_children) {
                                Map<String, String> attrs = c2.getAttributes();
                                String existing_val = attrs.put(key, val);
                                String prot = c2.getName();
                                if (existing_val != null) {
                                    log.debug("changed %s.%s: %s -> %s", prot, key, existing_val, val);
                                    continue;
                                }
                                log.debug("added %s.%s : %s", prot, key, val);
                            }
                        }
                        continue;
                    }
                    new_children.add(child);
                }
                root.setChildren(new_children);
            }
            return XmlConfigurator.parse(root);
        }
        catch (Exception x) {
            throw new IOException(String.format(Util.getMessage("ParseError"), x.getLocalizedMessage()));
        }
    }

    protected static XmlConfigurator parse(XmlNode root) throws Exception {
        return new XmlConfigurator(XmlConfigurator.parseProtocols(root));
    }

    public static List<ProtocolConfiguration> parseProtocols(XmlNode root) throws Exception {
        String root_name = root.getName().trim().toLowerCase();
        if (!"config".equals(root_name)) {
            throw new IOException("the configuration does not start with a <config> element: " + root_name);
        }
        ArrayList<ProtocolConfiguration> prot_data = new ArrayList<ProtocolConfiguration>();
        for (XmlNode node : root.getChildren()) {
            String protocol = node.getName();
            Map<String, String> attrs = node.getAttributes();
            ProtocolConfiguration cfg = new ProtocolConfiguration(protocol, attrs);
            prot_data.add(cfg);
            List<XmlNode> subnodes = node.getChildren();
            if (subnodes == null) continue;
            for (XmlNode subnode : subnodes) {
                cfg.addSubtree(subnode);
            }
        }
        return prot_data;
    }

    public static XmlNode parseXmlDocument(InputStream in) throws IOException {
        String s;
        ArrayDeque<XmlNode> stack = new ArrayDeque<XmlNode>();
        XmlNode current = null;
        while ((s = XmlConfigurator.readNode(in)) != null) {
            Tuple<String, String> tuple;
            ElementType type = XmlConfigurator.getType(s = XmlConfigurator.sanitize(s));
            if (type == ElementType.COMMENT) continue;
            s = s.replace("<", "").replace("/>", "").replace(">", "").trim();
            ByteArrayInputStream input = new ByteArrayInputStream(s.getBytes());
            String name = Util.readToken(input);
            XmlNode n = new XmlNode(name);
            while ((tuple = XmlConfigurator.readAttribute(input)) != null) {
                n.addAttribute(tuple.val1(), tuple.val2());
            }
            current = (XmlNode)stack.peekFirst();
            switch (type) {
                case COMPLETE: {
                    if (current == null) {
                        current = n;
                        break;
                    }
                    current.addChild(n);
                    break;
                }
                case START: {
                    if (current != null) {
                        current.addChild(n);
                    }
                    stack.push(n);
                    break;
                }
                case END: {
                    stack.pop();
                }
            }
        }
        return current;
    }

    protected static String readNode(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean eof = false;
        boolean in_comment = false;
        int comments = 0;
        block5: while (true) {
            int ch;
            if ((ch = in.read()) == -1) break;
            switch (ch) {
                case 60: {
                    if (!XmlConfigurator.isCommentStart(in, sb, in_comment)) continue block5;
                    ++comments;
                    in_comment = true;
                    continue block5;
                }
                case 45: {
                    if (!XmlConfigurator.isCommentEnd(in, sb, in_comment)) continue block5;
                    if (--comments < 0) {
                        throw new IllegalStateException("found '-->' without corresponding '<!--'");
                    }
                    if (comments != 0) continue block5;
                    in_comment = false;
                    continue block5;
                }
                case 62: {
                    if (in_comment) break;
                    sb.append((char)ch);
                    return sb.toString();
                }
            }
            if (in_comment) continue;
            sb.append((char)ch);
        }
        eof = true;
        String retval = sb.toString().trim();
        return eof && retval.isEmpty() ? null : retval;
    }

    protected static boolean isCommentStart(InputStream in, StringBuilder sb, boolean drop) throws IOException {
        return XmlConfigurator.find('<', "!--", in, sb, drop);
    }

    protected static boolean isCommentEnd(InputStream in, StringBuilder sb, boolean drop) throws IOException {
        return XmlConfigurator.find('-', "->", in, sb, drop);
    }

    protected static boolean find(char starting_ch, String s, InputStream in, StringBuilder sb, boolean drop) throws IOException {
        StringBuilder tmp = new StringBuilder().append(starting_ch);
        for (int i = 0; i < s.length(); ++i) {
            int ch;
            int c = s.codePointAt(i);
            do {
                if ((ch = in.read()) == -1) {
                    sb.append((CharSequence)tmp);
                    return false;
                }
                tmp.append((char)ch);
            } while (Character.isWhitespace(ch));
            if (ch == c) continue;
            if (!drop) {
                sb.append((CharSequence)tmp);
            }
            return false;
        }
        return true;
    }

    protected static String sanitize(String s) {
        return s.replaceAll("/\\s*>", "/>");
    }

    protected static Tuple<String, String> readAttribute(InputStream in) throws IOException {
        String attr_name = Util.readTillMatchingCharacter(in, '=');
        if (attr_name == null) {
            return null;
        }
        attr_name = attr_name.replace("=", "").trim();
        String val = XmlConfigurator.readQuotedString(in);
        if (val == null) {
            return null;
        }
        return new Tuple<String, String>(attr_name, val);
    }

    protected static String readQuotedString(InputStream in) throws IOException {
        int ch;
        String s = Util.readTillMatchingCharacter(in, '\"');
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        while ((ch = in.read()) != -1) {
            if (ch == 92) {
                escaped = true;
                continue;
            }
            if (escaped) {
                escaped = false;
            } else if (ch == 34) break;
            sb.append((char)ch);
        }
        return sb.toString();
    }

    protected static ElementType getType(String s) {
        if ((s = s.trim()).startsWith("<!--")) {
            return ElementType.COMMENT;
        }
        if (s.startsWith("</")) {
            return ElementType.END;
        }
        if (s.endsWith("/>")) {
            return ElementType.COMPLETE;
        }
        if (s.endsWith(">")) {
            return ElementType.START;
        }
        return ElementType.UNDEFINED;
    }

    public static void main(String[] args) throws Exception {
        InputStream input;
        String input_file = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-file")) {
                XmlConfigurator.help();
                return;
            }
            input_file = args[++i];
        }
        if (input_file != null) {
            input = null;
            try {
                input = new FileInputStream(input_file);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (input == null) {
                input = Thread.currentThread().getContextClassLoader().getResourceAsStream(input_file);
            }
        } else {
            throw new Exception("no input file given");
        }
        XmlConfigurator conf = XmlConfigurator.getInstance(input);
        String tmp = conf.getProtocolStackString();
        System.out.println("\n" + tmp);
    }

    static void help() {
        System.out.println("XmlConfigurator -file <input XML file>");
    }

    protected static enum ElementType {
        START,
        COMPLETE,
        END,
        COMMENT,
        UNDEFINED;

    }
}

