/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class XmlNode {
    protected final String name;
    protected Map<String, String> attributes;
    protected List<XmlNode> children;

    public XmlNode(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<XmlNode> getChildren() {
        return this.children;
    }

    public XmlNode setChildren(List<XmlNode> c) {
        this.children = c;
        return this;
    }

    public XmlNode setAttributes(Map<String, String> attrs) {
        this.attributes = attrs;
        return this;
    }

    public XmlNode addAttribute(String attr_name, String val) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(attr_name, val);
        return this;
    }

    public String getAttribute(String attr_name) {
        if (this.attributes == null || attr_name == null) {
            return null;
        }
        return this.attributes.get(attr_name);
    }

    public void removeAttribute(String attr_name) {
        if (this.attributes != null && attr_name != null) {
            this.attributes.remove(attr_name);
        }
    }

    public XmlNode addChild(XmlNode n) {
        if (this.children == null) {
            this.children = new ArrayList<XmlNode>();
        }
        this.children.add(n);
        return this;
    }

    public String toString() {
        return this.print(0);
    }

    protected String print(int indent) {
        StringBuilder sb = new StringBuilder(String.format("%s%s", " ".repeat(indent), this.name));
        if (this.attributes != null) {
            sb.append(" ").append(this.attributes);
        }
        sb.append("\n");
        if (this.children != null) {
            for (XmlNode child : this.children) {
                sb.append(child.print(indent + 2));
            }
        }
        return sb.toString();
    }
}

