/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.jmx;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Average;
import org.jgroups.util.Util;

public class ResourceDMBean
implements DynamicMBean {
    protected static final Class<?>[] primitives = new Class[]{Integer.TYPE, Byte.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE};
    protected static final List<Method> OBJECT_METHODS = new ArrayList<Method>(Arrays.asList(Object.class.getMethods()));
    protected final boolean expose_all;
    protected final Log log = LogFactory.getLog(ResourceDMBean.class);
    protected final Object obj;
    protected List<Object> components;
    protected final MBeanAttributeInfo[] attrInfo;
    protected final MBeanOperationInfo[] opInfo;
    protected final HashMap<String, AttributeEntry> atts = new HashMap();
    protected final List<MBeanOperationInfo> ops = new ArrayList<MBeanOperationInfo>();
    protected static final Predicate<AccessibleObject> FILTER = obj -> !obj.isAnnotationPresent(Deprecated.class) && (obj.isAnnotationPresent(ManagedAttribute.class) || obj.isAnnotationPresent(Property.class) && obj.getAnnotation(Property.class).exposeAsManagedAttribute());

    public ResourceDMBean(Object instance) {
        this(instance, null);
    }

    public ResourceDMBean(Object instance, Predicate<AccessibleObject> filter) {
        if (instance == null) {
            throw new NullPointerException("Cannot make an MBean wrapper for null instance");
        }
        this.obj = instance;
        Class<?> c = this.obj.getClass();
        this.expose_all = c.isAnnotationPresent(MBean.class) && c.getAnnotation(MBean.class).exposeAll();
        this.findFields(instance, filter, null);
        this.findMethods(instance, filter, null);
        this.fixFields(instance);
        List<Object> objects = Util.getComponents(instance);
        if (objects != null) {
            for (Object inst : objects) {
                if (inst == null) continue;
                if (this.components == null) {
                    this.components = new ArrayList<Object>();
                }
                String prefix = Util.methodNameToAttributeName(inst.getClass().getSimpleName());
                this.components.add(inst);
                this.findFields(inst, filter, prefix);
                this.findMethods(inst, filter, prefix);
                this.fixFields(inst);
            }
        }
        this.attrInfo = new MBeanAttributeInfo[this.atts.size()];
        int i = 0;
        MBeanAttributeInfo info = null;
        for (AttributeEntry entry : this.atts.values()) {
            info = entry.info;
            this.attrInfo[i++] = info;
        }
        this.opInfo = new MBeanOperationInfo[this.ops.size()];
        this.ops.toArray(this.opInfo);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this.obj.getClass().getCanonicalName(), "DynamicMBean", this.attrInfo, null, this.opInfo, null);
    }

    public void forAllAttributes(BiConsumer<String, AttributeEntry> c) {
        if (c == null) {
            return;
        }
        for (Map.Entry<String, AttributeEntry> e : this.atts.entrySet()) {
            c.accept(e.getKey(), e.getValue());
        }
    }

    @Override
    public Object getAttribute(String name) {
        if (name == null || name.isEmpty()) {
            throw new NullPointerException("Invalid attribute requested " + name);
        }
        Attribute attr = this.getNamedAttribute(name);
        return attr != null ? attr.getValue() : null;
    }

    @Override
    public void setAttribute(Attribute attribute) {
        if (attribute == null || attribute.getName() == null) {
            throw new NullPointerException("Invalid attribute requested " + String.valueOf(attribute));
        }
        this.setNamedAttribute(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        AttributeList al = new AttributeList();
        for (String name : names) {
            Attribute attr = this.getNamedAttribute(name);
            if (attr != null) {
                al.add(attr);
                continue;
            }
            this.log.warn("Did not find attribute " + name);
        }
        return al;
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        AttributeList results = new AttributeList();
        for (int i = 0; i < list.size(); ++i) {
            Attribute attr = (Attribute)list.get(i);
            if (this.setNamedAttribute(attr)) {
                results.add(attr);
                continue;
            }
            if (!this.log.isWarnEnabled()) continue;
            this.log.warn("Failed to update attribute name " + attr.getName() + " with value " + String.valueOf(attr.getValue()));
        }
        return results;
    }

    @Override
    public Object invoke(String name, Object[] args, String[] sig) throws MBeanException, ReflectionException {
        try {
            Class[] classes = new Class[sig.length];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = ResourceDMBean.getClassForName(sig[i]);
            }
            Method method = null;
            if (this.components != null) {
                for (Object o : this.components) {
                    try {
                        method = o.getClass().getMethod(name, classes);
                    }
                    catch (Throwable t) {
                        continue;
                    }
                    return method.invoke(o, args);
                }
            }
            method = this.obj.getClass().getMethod(name, classes);
            return method.invoke(this.obj, args);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public static boolean isSetMethod(Method method) {
        return method.getParameterCount() == 1;
    }

    public static boolean isGetMethod(Method method) {
        return method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    public static boolean isIsMethod(Method method) {
        return method.getParameterTypes().length == 0 && (method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class);
    }

    public static void dumpStats(Object obj, Map<String, Object> map) {
        ResourceDMBean.dumpStats(obj, "", map);
    }

    public static void dumpStats(Object obj, String prefix, Map<String, Object> map) {
        BiConsumer<Field, Object> field_func = (f, o) -> {
            Object attr_name = null;
            try {
                f.setAccessible(true);
                Object value = f.get(o);
                attr_name = Util.getNameFromAnnotation(f);
                attr_name = attr_name != null && !((String)attr_name).trim().isEmpty() ? ((String)attr_name).trim() : f.getName();
                if (prefix != null && !prefix.isEmpty()) {
                    attr_name = prefix + "." + (String)attr_name;
                }
                map.put((String)attr_name, ResourceDMBean.prettyPrint(value, f));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("could not read value of attribute \"%s\"", attr_name), e);
            }
        };
        BiConsumer<Method, Object> getter_func = (m, o) -> {
            String method_name = null;
            if (!ResourceDMBean.isGetMethod(m)) {
                return;
            }
            try {
                Object value = m.invoke(o, new Object[0]);
                method_name = Util.getNameFromAnnotation(m);
                if (method_name != null && !method_name.trim().isEmpty()) {
                    method_name = method_name.trim();
                } else {
                    String field_name = Util.methodNameToAttributeName(m.getName());
                    method_name = Util.attributeNameToMethodName(field_name);
                }
                Object attributeName = Util.methodNameToAttributeName(method_name);
                if (prefix != null && !prefix.isEmpty()) {
                    attributeName = prefix + "." + (String)attributeName;
                }
                map.put((String)attributeName, ResourceDMBean.prettyPrint(value, m));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("could not invoke getter method \"%s\"", method_name), e);
            }
        };
        Util.forAllFieldsAndMethods(obj, FILTER, field_func, getter_func);
    }

    public static String prettyPrint(Object val, AccessibleObject a) {
        if (val == null) {
            return "null";
        }
        Class<?> cl = val.getClass();
        AttributeType type = ResourceDMBean.getType(a);
        if (type != null) {
            switch (type) {
                case BYTES: {
                    return Util.printBytes(((Number)val).doubleValue());
                }
                case TIME: {
                    TimeUnit unit = ResourceDMBean.getTimeUnit(a);
                    return Util.printTime(((Number)val).doubleValue(), unit);
                }
                case SCALAR: {
                    if (ResourceDMBean.isNumeric(cl)) {
                        return String.format("%,d", val);
                    }
                    if (cl.equals(LongAdder.class)) {
                        return String.format("%,d", ((LongAdder)val).sum());
                    }
                    if (!(val instanceof Number)) break;
                    return String.format("%,d", ((Number)val).longValue());
                }
            }
        }
        if (ResourceDMBean.isNumeric(cl)) {
            return String.format("%d", val);
        }
        if (ResourceDMBean.isFractional(cl)) {
            return String.format("%,.2f", val);
        }
        if (cl.equals(String[].class)) {
            return Arrays.toString((String[])val);
        }
        return val.toString();
    }

    public static boolean isNumeric(Class<?> cl) {
        return cl.equals(Short.TYPE) || cl.equals(Short.class) || cl.equals(Integer.TYPE) || cl.equals(Integer.class) || cl.equals(Long.TYPE) || cl.equals(Long.class);
    }

    public static boolean isFractional(Class<?> cl) {
        return cl.equals(Float.TYPE) || cl.equals(Float.class) || cl.equals(Double.TYPE) || cl.equals(Double.class);
    }

    public static boolean isNumber(Class<?> cl) {
        return ResourceDMBean.isNumeric(cl) || ResourceDMBean.isFractional(cl) || Number.class.isAssignableFrom(cl) || Average.class.isAssignableFrom(cl);
    }

    protected static AttributeType getType(AccessibleObject ao) {
        Property prop = ao.getAnnotation(Property.class);
        if (prop != null) {
            return prop.type();
        }
        ManagedAttribute attr = ao.getAnnotation(ManagedAttribute.class);
        return attr != null ? attr.type() : null;
    }

    protected static TimeUnit getTimeUnit(AccessibleObject ao) {
        Property prop = ao.getAnnotation(Property.class);
        if (prop != null) {
            return prop.unit();
        }
        ManagedAttribute attr = ao.getAnnotation(ManagedAttribute.class);
        return attr != null ? attr.unit() : null;
    }

    protected static Class<?> getClassForName(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            for (int i = 0; i < primitives.length; ++i) {
                if (!name.equals(primitives[i].getName())) continue;
                return primitives[i];
            }
            throw new ClassNotFoundException("Class " + name + " cannot be found");
        }
    }

    protected void findMethods(Object instance, Predicate<AccessibleObject> filter, String prefix) {
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(instance.getClass().getMethods()));
        methods.removeAll(OBJECT_METHODS);
        for (Method method : methods) {
            if (method.isAnnotationPresent(ManagedAttribute.class) || method.isAnnotationPresent(Property.class)) {
                if (filter != null && !filter.test(method)) continue;
                this.exposeManagedAttribute(method, instance, prefix);
                continue;
            }
            if (!method.isAnnotationPresent(ManagedOperation.class) && !this.expose_all) continue;
            ManagedOperation op = method.getAnnotation(ManagedOperation.class);
            this.ops.add(new MBeanOperationInfo(op != null ? op.description() : "", method));
        }
    }

    protected void fixFields(Object instance) {
        for (AttributeEntry attr : this.atts.values()) {
            if (attr.getter == null) {
                attr.getter = ResourceDMBean.findGetter(instance, attr.name);
            }
            if (attr.setter == null) {
                attr.setter = ResourceDMBean.findSetter(instance, attr.name);
            }
            if (attr.setter != null) continue;
            attr.setter = new NoopAccessor();
        }
    }

    protected void exposeManagedAttribute(Method method, Object instance, String prefix) {
        String attr_name;
        boolean writable;
        boolean expose;
        String methodName = method.getName();
        ManagedAttribute attr_annotation = method.getAnnotation(ManagedAttribute.class);
        Property prop = method.getAnnotation(Property.class);
        boolean expose_prop = prop != null && prop.exposeAsManagedAttribute();
        boolean bl = expose = attr_annotation != null || expose_prop;
        if (!expose) {
            return;
        }
        boolean bl2 = writable = prop != null && prop.writable() || attr_annotation != null && attr_annotation.writable();
        String string = attr_annotation != null ? attr_annotation.name() : (attr_name = prop != null ? prop.name() : null);
        if (attr_name != null && !attr_name.trim().isEmpty()) {
            attr_name = attr_name.trim();
        } else {
            String tmp;
            attr_name = Util.methodNameToAttributeName(methodName);
            if (!this.atts.containsKey(attr_name) && this.atts.containsKey(tmp = Util.methodNameToJavaAttributeName(methodName))) {
                attr_name = tmp;
            }
        }
        String descr = attr_annotation != null ? attr_annotation.description() : (prop != null ? prop.description() : null);
        AttributeEntry attr = this.atts.get(ResourceDMBean.prefix(prefix, attr_name));
        if (attr != null) {
            if (ResourceDMBean.isSetMethod(method)) {
                if (attr.setter != null) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("setter for \"" + attr_name + "\" is already defined (new method=" + method.getName() + ")");
                    }
                } else {
                    attr.setter = new MethodAccessor(method, instance);
                }
            } else if (attr.getter != null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("getter for \"" + attr_name + "\" is already defined (new method=" + method.getName() + ")");
                }
            } else {
                attr.getter = new MethodAccessor(method, instance);
            }
        } else {
            boolean is_setter = ResourceDMBean.isSetMethod(method);
            String type = is_setter ? method.getParameterTypes()[0].getCanonicalName() : method.getReturnType().getCanonicalName();
            MBeanAttributeInfo info = new MBeanAttributeInfo(ResourceDMBean.prefix(attr_name, prefix), type, descr, true, writable, methodName.startsWith("is"));
            AttributeEntry entry = new AttributeEntry(method, Util.methodNameToAttributeName(methodName), info);
            if (is_setter) {
                entry.setter(new MethodAccessor(method, instance));
            } else {
                entry.getter(new MethodAccessor(method, instance));
            }
            this.atts.put(ResourceDMBean.prefix(attr_name, prefix), entry);
        }
    }

    protected static String prefix(String s, String prefix) {
        return prefix == null ? s : prefix + "." + s;
    }

    protected static Accessor findGetter(Object target, String attr_name) {
        String name = Util.attributeNameToMethodName(attr_name);
        Class<?> clazz = target.getClass();
        Method method = Util.findMethod(target, Arrays.asList("get" + name, "is" + name, ResourceDMBean.toLowerCase(name)), new Class[0]);
        if (method != null && (ResourceDMBean.isGetMethod(method) || ResourceDMBean.isIsMethod(method))) {
            return new MethodAccessor(method, target);
        }
        Field field = Util.getField(clazz, attr_name);
        if (field != null) {
            return new FieldAccessor(field, target);
        }
        return new NoopAccessor();
    }

    public static Accessor findSetter(Object target, String attr_name) {
        Method method;
        String name = Util.attributeNameToMethodName(attr_name);
        String fluent_name = ResourceDMBean.toLowerCase(name);
        Class<?> clazz = target.getClass();
        Class<?> field_type = null;
        Field field = Util.getField(clazz, attr_name);
        field_type = field != null ? field.getType() : null;
        String setter_name = "set" + name;
        if (field_type != null && (method = Util.findMethod(target, Arrays.asList(fluent_name, setter_name), field_type)) != null && ResourceDMBean.isSetMethod(method)) {
            return new MethodAccessor(method, target);
        }
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(clazz.getMethods()));
        methods.removeAll(OBJECT_METHODS);
        for (Method method2 : methods) {
            String method_name = method2.getName();
            if (!method_name.equals(name) && !method_name.equals(fluent_name) && !method_name.equals(setter_name) || !ResourceDMBean.isSetMethod(method2)) continue;
            return new MethodAccessor(method2, target);
        }
        if (field != null) {
            return new FieldAccessor(field, target);
        }
        return null;
    }

    protected static String toLowerCase(String input) {
        if (Character.isUpperCase(input.charAt(0))) {
            return input.substring(0, 1).toLowerCase() + input.substring(1);
        }
        return input;
    }

    protected void findFields(Object instance, Predicate<AccessibleObject> filter, String prefix) {
        for (Class<?> clazz = instance.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Object fieldName;
                boolean expose;
                ManagedAttribute annotation = field.getAnnotation(ManagedAttribute.class);
                Property prop = field.getAnnotation(Property.class);
                boolean expose_prop = prop != null && prop.exposeAsManagedAttribute();
                boolean bl = expose = annotation != null || expose_prop;
                if (!expose || filter != null && !filter.test(field)) continue;
                Object object = annotation != null ? annotation.name() : (fieldName = prop != null ? prop.name() : null);
                if (fieldName != null && ((String)fieldName).trim().isEmpty()) {
                    fieldName = field.getName();
                }
                if (prefix != null) {
                    fieldName = prefix + "." + (String)fieldName;
                }
                String descr = annotation != null ? annotation.description() : prop.description();
                boolean writable = annotation != null ? annotation.writable() : prop.writable();
                MBeanAttributeInfo info = new MBeanAttributeInfo((String)fieldName, field.getType().getCanonicalName(), descr, true, !Modifier.isFinal(field.getModifiers()) && writable, false);
                this.atts.put((String)fieldName, new AttributeEntry(field, field.getName(), info));
            }
        }
    }

    protected Attribute getNamedAttribute(String name) {
        AttributeEntry entry = this.atts.get(name);
        if (entry != null) {
            try {
                return new Attribute(name, entry.getter.invoke(null));
            }
            catch (Exception e) {
                this.log.warn(Util.getMessage("AttrReadFailure"), name, e);
            }
        } else {
            this.log.warn(Util.getMessage("MissingAttribute"), name);
        }
        return null;
    }

    protected boolean setNamedAttribute(Attribute attribute) {
        AttributeEntry entry = this.atts.get(attribute.getName());
        if (entry != null) {
            try {
                entry.setter.invoke(attribute.getValue());
                return true;
            }
            catch (Throwable e) {
                this.log.warn(Util.getMessage("AttrWriteFailure"), attribute.getName(), e);
            }
        } else {
            this.log.warn(Util.getMessage("MissingAttribute"), attribute.getName());
        }
        return false;
    }

    public static class AttributeEntry {
        protected final AccessibleObject type;
        protected final String name;
        protected final MBeanAttributeInfo info;
        protected Accessor getter;
        protected Accessor setter;

        public AttributeEntry(AccessibleObject type, String name, MBeanAttributeInfo info) {
            this(type, name, info, null, null);
        }

        public AttributeEntry(AccessibleObject type, String name, MBeanAttributeInfo info, Accessor getter, Accessor setter) {
            this.type = type;
            this.name = name;
            this.info = info;
            this.getter = getter;
            this.setter = setter;
        }

        public AccessibleObject type() {
            return this.type;
        }

        public String name() {
            return this.name;
        }

        public MBeanAttributeInfo info() {
            return this.info;
        }

        public Accessor getter() {
            return this.getter;
        }

        public AttributeEntry getter(Accessor new_getter) {
            this.getter = new_getter;
            return this;
        }

        public Accessor setter() {
            return this.setter;
        }

        public AttributeEntry setter(Accessor new_setter) {
            this.setter = new_setter;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("AttributeEntry[" + this.name);
            if (this.getter != null) {
                sb.append(", getter=" + String.valueOf(this.getter));
            }
            if (this.setter() != null) {
                sb.append(", setter=" + String.valueOf(this.setter));
            }
            sb.append("]");
            return sb.toString();
        }
    }

    public static interface Accessor {
        public Object invoke(Object var1) throws Exception;
    }

    public static class NoopAccessor
    implements Accessor {
        @Override
        public Object invoke(Object new_val) throws Exception {
            return null;
        }

        public String toString() {
            return "NoopAccessor";
        }
    }

    public record MethodAccessor(Method method, Object target) implements Accessor
    {
        @Override
        public Object invoke(Object new_val) throws Exception {
            return new_val != null ? this.method.invoke(this.target, new_val) : this.method.invoke(this.target, new Object[0]);
        }

        @Override
        public String toString() {
            return "method[" + this.method.getName() + "()]";
        }
    }

    public static class FieldAccessor
    implements Accessor {
        protected final Field field;
        protected final Object target;
        protected static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
        protected MethodHandle mh;

        public FieldAccessor(Field field, Object target) {
            this.field = field;
            this.target = target;
            field.setAccessible(true);
            try {
                this.mh = LOOKUP.unreflectGetter(field);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }

        public Field getField() {
            return this.field;
        }

        @Override
        public Object invoke(Object new_val) throws Exception {
            if (new_val == null) {
                if (this.mh != null) {
                    try {
                        return this.mh.invoke(this.target);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return this.field.get(this.target);
            }
            this.field.set(this.target, new_val);
            return null;
        }

        public String toString() {
            return "field[" + this.field.getName() + "]";
        }
    }
}

