/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Map;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.ReliableMulticast;
import org.jgroups.util.Buffer;
import org.jgroups.util.DynamicBuffer;

public class NAKACK3
extends ReliableMulticast {
    @Property(description="Number of rows of the matrix in the retransmission table (only for experts)", writable=false)
    protected int xmit_table_num_rows = 100;
    @Property(description="Number of elements of a row of the matrix in the retransmission table; gets rounded to the next power of 2 (only for experts). The capacity of the matrix is xmit_table_num_rows * xmit_table_msgs_per_row", writable=false)
    protected int xmit_table_msgs_per_row = 1024;
    @Property(description="Resize factor of the matrix in the retransmission table (only for experts)", writable=false)
    protected double xmit_table_resize_factor = 1.2;
    @Property(description="Number of milliseconds after which the matrix in the retransmission table is compacted (only for experts)", writable=false, type=AttributeType.TIME)
    protected long xmit_table_max_compaction_time = 10000L;

    public int getXmitTableNumRows() {
        return this.xmit_table_num_rows;
    }

    public ReliableMulticast setXmitTableNumRows(int x) {
        this.xmit_table_num_rows = x;
        return this;
    }

    public int getXmitTableMsgsPerRow() {
        return this.xmit_table_msgs_per_row;
    }

    public ReliableMulticast setXmitTableMsgsPerRow(int x) {
        this.xmit_table_msgs_per_row = x;
        return this;
    }

    public double getXmitTableResizeFactor() {
        return this.xmit_table_resize_factor;
    }

    public ReliableMulticast setXmitTableResizeFactor(double x) {
        this.xmit_table_resize_factor = x;
        return this;
    }

    public long getXmitTableMaxCompactionTime() {
        return this.xmit_table_max_compaction_time;
    }

    public ReliableMulticast setXmitTableMaxCompactionTime(long x) {
        this.xmit_table_max_compaction_time = x;
        return this;
    }

    @Override
    protected Buffer<Message> createXmitWindow(long initial_seqno) {
        return new DynamicBuffer<Message>(this.xmit_table_num_rows, this.xmit_table_msgs_per_row, initial_seqno, this.xmit_table_resize_factor, this.xmit_table_max_compaction_time);
    }

    @ManagedAttribute(description="Prints the number of rows currently allocated in the matrix. This value will not be lower than xmit_table_now_rows")
    public int getXmitTableNumCurrentRows() {
        DynamicBuffer win = (DynamicBuffer)this.getBuf(this.local_addr);
        return win != null ? win.getNumRows() : 0;
    }

    @ManagedAttribute(description="Number of retransmit table compactions")
    public int getXmitTableNumCompactions() {
        DynamicBuffer win = (DynamicBuffer)this.getBuf(this.local_addr);
        return win != null ? win.getNumCompactions() : 0;
    }

    @ManagedAttribute(description="Number of retransmit table moves")
    public int getXmitTableNumMoves() {
        DynamicBuffer win = (DynamicBuffer)this.getBuf(this.local_addr);
        return win != null ? win.getNumMoves() : 0;
    }

    @ManagedAttribute(description="Number of retransmit table resizes")
    public int getXmitTableNumResizes() {
        DynamicBuffer win = (DynamicBuffer)this.getBuf(this.local_addr);
        return win != null ? win.getNumResizes() : 0;
    }

    @ManagedAttribute(description="Number of retransmit table purges")
    public int getXmitTableNumPurges() {
        DynamicBuffer win = (DynamicBuffer)this.getBuf(this.local_addr);
        return win != null ? win.getNumPurges() : 0;
    }

    @ManagedOperation(description="Compacts the retransmit buffer")
    public void compact() {
        DynamicBuffer win = (DynamicBuffer)this.getBuf(this.local_addr);
        if (win != null) {
            win.compact();
        }
    }

    @ManagedOperation(description="Prints the number of rows currently allocated in the matrix for all members. This value will not be lower than xmit_table_now_rows")
    public String dumpXmitTablesNumCurrentRows() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : this.xmit_table.entrySet()) {
            sb.append(String.format("%s: %d\n", e.getKey(), ((DynamicBuffer)((ReliableMulticast.Entry)e.getValue()).buf()).getNumRows()));
        }
        return sb.toString();
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.reuse_message_batches) {
            this.log.warn("reuse_message_batches is true: this can lead to excessive memory use");
        }
    }
}

