/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.View;
import org.jgroups.annotations.LocalAddress;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.protocols.pbcast.StreamingStateTransfer;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.StateTransferResult;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@MBean(description="State trasnfer protocol based on streaming state transfer")
public class STATE_SOCK
extends StreamingStateTransfer {
    @LocalAddress
    @Property(description="The interface (NIC) used to accept state requests. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL and NON_LOOPBACK", systemProperty={"jgroups.bind_addr"}, writable=false)
    protected InetAddress bind_addr;
    @Property(description="Use \"external_addr\" if you have hosts on different networks, behind firewalls. On each firewall, set up a port forwarding rule (sometimes called \"virtual server\") to the local IP (e.g. 192.168.1.100) of the host then on each host, set \"external_addr\" TCP transport parameter to the external (public IP) address of the firewall.", systemProperty={"jgroups.external_addr"}, writable=false)
    protected InetAddress external_addr;
    @Property(description="Used to map the internal port (bind_port) to an external port. Only used if > 0", systemProperty={"jgroups.external_port"}, writable=false)
    protected int external_port;
    @Property(name="bind_interface", converter=PropertyConverters.BindInterface.class, description="The interface (NIC) which should be used by this transport", dependsUpon="bind_addr")
    protected String bind_interface_str;
    @Property(description="The port listening for state requests. Default value of 0 binds to any (ephemeral) port")
    protected int bind_port;
    @Property(description="The size (in bytes) of the receive buffer of the socket", type=AttributeType.BYTES)
    protected int recv_buf_size;
    protected volatile StateProviderAcceptor spawner;

    @Override
    public void stop() {
        super.stop();
        if (this.spawner != null) {
            this.spawner.stop();
        }
    }

    protected StateProviderAcceptor createAcceptor() throws Exception {
        StateProviderAcceptor retval = new StateProviderAcceptor(this.thread_pool, Util.createServerSocket(this.getSocketFactory(), "jgroups.streaming_state_transfer.srv_sock", this.bind_addr, this.bind_port, this.bind_port, this.recv_buf_size));
        Thread t = this.getThreadFactory().newThread(retval, "STATE server socket acceptor");
        t.start();
        return retval;
    }

    @Override
    protected void modifyStateResponseHeader(StreamingStateTransfer.StateHeader hdr) {
        if (this.spawner != null) {
            hdr.bind_addr = this.spawner.getServerSocketAddress();
        }
    }

    @Override
    protected Tuple<InputStream, Object> createStreamToProvider(Address provider, StreamingStateTransfer.StateHeader hdr) throws Exception {
        IpAddress address = hdr.bind_addr;
        Socket socket = null;
        try {
            socket = this.getSocketFactory().createSocket("jgroups.state_sock.sock");
            socket.bind(new InetSocketAddress(this.bind_addr, 0));
            socket.setReceiveBufferSize(this.buffer_size);
            Util.connect(socket, address.getSocketAddress(), 0);
            this.log.debug("%s: connected to state provider %s:%d", this.local_addr, address.getIpAddress(), address.getPort());
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            Util.writeAddress(this.local_addr, out);
            return new Tuple<InputStream, Object>(new BufferedInputStream(socket.getInputStream(), this.buffer_size), socket);
        }
        catch (Throwable t) {
            Util.close(socket);
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception("failed creating socket", t);
        }
    }

    @Override
    protected void close(Object resource) {
        if (resource instanceof Socket) {
            Util.close((Closeable)((Socket)resource));
        }
    }

    @Override
    protected void handleStateReq(Address requester) throws Exception {
        if (this.spawner == null || !this.spawner.isRunning()) {
            this.spawner = this.createAcceptor();
        }
        super.handleStateReq(requester);
    }

    @Override
    protected void handleViewChange(View v) {
        super.handleViewChange(v);
        if (this.state_provider != null && !v.getMembers().contains(this.state_provider)) {
            this.openBarrierAndResumeStable();
            EOFException ex = new EOFException("state provider " + String.valueOf(this.state_provider) + " left");
            this.up_prot.up(new Event(73, new StateTransferResult(ex)));
        }
    }

    @Override
    protected void handleConfig(Map<String, Object> config) {
        Object val;
        super.handleConfig(config);
        if (this.bind_addr == null) {
            this.bind_addr = (InetAddress)config.get("bind_addr");
        }
        if (this.external_addr == null) {
            this.external_addr = (InetAddress)config.get("external_addr");
        }
        if (this.external_port <= 0 && (val = config.get("external_port")) != null) {
            this.external_port = (Integer)val;
        }
    }

    protected class StateProviderAcceptor
    implements Runnable {
        protected final ExecutorService pool;
        protected final ServerSocket serverSocket;
        protected final IpAddress address;
        protected volatile boolean running = true;

        public StateProviderAcceptor(ExecutorService pool, ServerSocket stateServingSocket) {
            this.pool = pool;
            this.serverSocket = stateServingSocket;
            this.address = STATE_SOCK.this.external_addr != null ? new IpAddress(STATE_SOCK.this.external_addr, STATE_SOCK.this.external_port > 0 ? STATE_SOCK.this.external_port : this.serverSocket.getLocalPort()) : new IpAddress(STATE_SOCK.this.bind_addr, this.serverSocket.getLocalPort());
        }

        public IpAddress getServerSocketAddress() {
            return this.address;
        }

        public boolean isRunning() {
            return this.running;
        }

        @Override
        public void run() {
            if (STATE_SOCK.this.log.isDebugEnabled()) {
                STATE_SOCK.this.log.debug(String.valueOf(STATE_SOCK.this.local_addr) + ": StateProviderAcceptor listening at " + String.valueOf(this.getServerSocketAddress()));
            }
            while (this.running) {
                try {
                    Socket socket = this.serverSocket.accept();
                    try {
                        this.pool.execute(() -> this.process(socket));
                    }
                    catch (RejectedExecutionException rejected) {
                        Util.close((Closeable)socket);
                    }
                }
                catch (Throwable e) {
                    if (!this.serverSocket.isClosed()) continue;
                    this.running = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void process(Socket socket) {
            BufferedOutputStream output = null;
            try {
                socket.setSendBufferSize(STATE_SOCK.this.buffer_size);
                if (STATE_SOCK.this.log.isDebugEnabled()) {
                    STATE_SOCK.this.log.debug(String.valueOf(STATE_SOCK.this.local_addr) + ": accepted request for state transfer from " + String.valueOf(socket.getInetAddress()) + ":" + socket.getPort());
                }
                DataInputStream in = new DataInputStream(socket.getInputStream());
                Address stateRequester = Util.readAddress(in);
                output = new BufferedOutputStream(socket.getOutputStream(), STATE_SOCK.this.buffer_size);
                STATE_SOCK.this.getStateFromApplication(stateRequester, output, false);
            }
            catch (Throwable e) {
                if (STATE_SOCK.this.log.isWarnEnabled()) {
                    STATE_SOCK.this.log.warn(String.valueOf(STATE_SOCK.this.local_addr) + ": failed handling request from requester", e);
                }
            }
            finally {
                Util.close((Closeable)socket);
            }
        }

        public void stop() {
            this.running = false;
            try {
                STATE_SOCK.this.getSocketFactory().close(this.serverSocket);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

