/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Constructable;
import org.jgroups.PhysicalAddress;

public class IpAddress
implements PhysicalAddress,
Constructable<IpAddress> {
    protected InetAddress ip_addr;
    protected int port;

    public IpAddress() {
    }

    public IpAddress(String addr_port) throws Exception {
        int index = addr_port.lastIndexOf(58);
        if (index == -1) {
            this.setAddress(IpAddress.getByName(addr_port), 0);
        } else {
            this.setAddress(IpAddress.getByName(addr_port.substring(0, index)), Integer.parseInt(addr_port.substring(index + 1)));
        }
    }

    public IpAddress(String i, int p) throws UnknownHostException {
        this.setAddress(IpAddress.getByName(i), p);
    }

    public IpAddress(InetAddress i, int p) {
        this.setAddress(i, p);
    }

    public IpAddress(int p) {
        this.setAddress(IpAddress.getLocalHost(), p);
    }

    public IpAddress(InetSocketAddress sock_addr) {
        this.setAddress(sock_addr.getAddress(), sock_addr.getPort());
    }

    @Override
    public Supplier<? extends IpAddress> create() {
        return IpAddress::new;
    }

    public static InetAddress getByName(String host) throws UnknownHostException {
        if (host == null || host.isEmpty()) {
            return IpAddress.getLocalHost();
        }
        return InetAddress.getByName(host);
    }

    public static InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Exception exception) {
            try {
                return InetAddress.getByName(null);
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
    }

    @Override
    public InetAddress getIpAddress() {
        return this.ip_addr;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int compareTo(Address o) {
        int h2;
        if (this == o) {
            return 0;
        }
        if (!(o instanceof IpAddress)) {
            throw new ClassCastException("comparison between different classes: the other object is " + String.valueOf(o != null ? o.getClass() : o));
        }
        IpAddress other = (IpAddress)o;
        if (this.ip_addr == null) {
            if (other.ip_addr == null) {
                return Integer.compare(this.port, other.port);
            }
            return -1;
        }
        int h1 = this.ip_addr.hashCode();
        int rc = Integer.compare(h1, h2 = other.ip_addr.hashCode());
        return rc != 0 ? rc : Integer.compare(this.port, other.port);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IpAddress)) {
            return false;
        }
        IpAddress other = (IpAddress)obj;
        boolean sameIP = this.ip_addr != null ? this.ip_addr.equals(other.ip_addr) : other.ip_addr == null;
        return sameIP && this.port == other.port;
    }

    public int hashCode() {
        return this.ip_addr != null ? this.ip_addr.hashCode() + this.port : this.port;
    }

    public String toString() {
        return this.printIpAddress();
    }

    @Override
    public String printIpAddress() {
        return String.format("%s:%d", this.ip_addr != null ? this.ip_addr.getHostAddress() : "<null>", this.port);
    }

    public String printIpAddress2() {
        return String.format("%s[%d]", this.ip_addr != null ? this.ip_addr.getHostAddress() : "localhost", this.port);
    }

    public String printHostAddress() {
        return this.ip_addr != null ? this.ip_addr.getHostAddress() : "";
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        if (this.ip_addr != null) {
            byte[] address = this.ip_addr.getAddress();
            out.writeByte(address.length);
            out.write(address, 0, address.length);
            if (this.ip_addr instanceof Inet6Address) {
                out.writeInt(((Inet6Address)this.ip_addr).getScopeId());
            }
        } else {
            out.writeByte(0);
        }
        out.writeShort(this.port);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        InetAddress ip = null;
        byte len = in.readByte();
        if (len > 0) {
            if (len != 4 && len != 16) {
                throw new IOException(String.format("length has to be %d or %d bytes (was %d bytes)", 4, 16, (int)len));
            }
            byte[] a = new byte[len];
            in.readFully(a);
            if (len == 16) {
                int scope_id = in.readInt();
                ip = Inet6Address.getByAddress(null, a, scope_id);
            } else {
                ip = InetAddress.getByAddress(a);
            }
        }
        int p = in.readUnsignedShort();
        this.setAddress(ip, p);
    }

    @Override
    public int serializedSize() {
        int tmp_size = 3;
        if (this.ip_addr != null) {
            tmp_size += this.ip_addr instanceof Inet4Address ? 4 : 20;
        }
        return tmp_size;
    }

    public IpAddress copy() {
        return new IpAddress(this.ip_addr, this.port);
    }

    protected void setAddress(InetAddress i, int p) {
        this.ip_addr = i;
        this.port = p;
    }
}

