/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.jgroups.util.ByteArray;
import org.jgroups.util.Util;

public class ByteArrayDataInputStream
extends InputStream
implements DataInput {
    protected final byte[] buf;
    protected int pos;
    protected int marked_pos;
    protected final int limit;
    protected static final ByteBuffer EMPTY = ByteBuffer.allocate(0);

    public ByteArrayDataInputStream(byte[] buf) {
        this(buf, 0, buf != null ? buf.length : 0);
    }

    public ByteArrayDataInputStream(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.limit = Math.min(buf.length, offset + length);
        this.marked_pos = this.pos = this.checkBounds(offset);
    }

    public ByteArrayDataInputStream(ByteArray buf) {
        this(buf.array(), buf.offset(), buf.length());
    }

    public ByteArrayDataInputStream(ByteBuffer buffer) {
        int offset = buffer.hasArray() ? buffer.arrayOffset() + buffer.position() : buffer.position();
        int len = buffer.remaining();
        if (!buffer.isDirect()) {
            this.buf = buffer.array();
            this.pos = offset;
            this.limit = offset + len;
        } else {
            byte[] tmp = new byte[len];
            buffer.get(tmp, 0, len);
            this.buf = tmp;
            this.pos = 0;
            this.limit = len;
        }
        this.marked_pos = this.pos;
    }

    public ByteArrayDataInputStream position(int pos) {
        this.pos = this.checkBounds(pos);
        return this;
    }

    public byte[] buffer() {
        return this.buf;
    }

    public ByteArray getBuffer() {
        return new ByteArray(this.buf, this.pos, this.limit - this.pos);
    }

    public ByteBuffer byteBuffer() {
        return ByteBuffer.wrap(this.buf, this.pos, this.limit - this.pos);
    }

    public int position() {
        return this.pos;
    }

    public int limit() {
        return this.limit;
    }

    public int capacity() {
        return this.buf.length;
    }

    public ByteArrayDataInputStream advance(int amount) {
        if (this.pos + amount > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.pos += amount;
        return this;
    }

    @Override
    public int read() {
        return this.pos < this.limit ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        Objects.requireNonNull(b);
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.limit) {
            return -1;
        }
        int avail = this.limit - this.pos;
        if (len > avail) {
            len = avail;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        long avail = this.limit - this.pos;
        if (n > avail) {
            n = avail;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public int available() {
        return this.limit - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.marked_pos = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.marked_pos;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public ByteBuffer readBuffer(int len) {
        int avail = this.limit - this.pos;
        if (len > avail || len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return EMPTY;
        }
        ByteBuffer val = ByteBuffer.wrap(this.buf, this.pos, len);
        this.pos += len;
        return val;
    }

    @Override
    public int skipBytes(int n) {
        int k = this.limit - this.pos;
        if (n < k) {
            k = Math.max(n, 0);
        }
        this.pos += k;
        return k;
    }

    @Override
    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int index = this.pos;
        byte[] array = this.buf;
        if (index + 2 > this.limit) {
            throw new IOException();
        }
        this.pos += 2;
        return ((array[index] & 0xFF) << 8) + (array[index + 1] & 0xFF);
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        int index = this.pos;
        if (index + 4 > this.limit) {
            throw new IOException();
        }
        this.pos += 4;
        return Util.INT_ARRAY_VIEW.get(this.buf, index);
    }

    @Override
    public long readLong() throws IOException {
        int index = this.pos;
        if (index + 8 > this.limit) {
            throw new IOException();
        }
        this.pos += 8;
        return Util.LONG_ARRAY_VIEW.get(this.buf, index);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder sb = new StringBuilder(35);
        while (true) {
            int ch;
            if ((ch = this.read()) == -1) {
                return sb.isEmpty() ? null : sb.toString();
            }
            if (ch == 13) continue;
            if (ch == 10) break;
            sb.append((char)ch);
        }
        return sb.toString();
    }

    @Override
    public String readUTF() throws IOException {
        int c;
        int count;
        int utflen = this.readUnsignedShort();
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        if ((short)utflen == -1) {
            return null;
        }
        int chararr_count = 0;
        this.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }

    public String toString() {
        return "pos=" + this.pos + " lim=" + this.limit + " cap=" + this.buf.length;
    }

    protected int checkBounds(int pos) {
        if (pos < 0 || pos >= this.limit) {
            throw new IndexOutOfBoundsException("pos=" + pos + ", limit=" + this.limit);
        }
        return pos;
    }
}

