/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import org.jgroups.util.Util;

public class ConcurrentBlockingRingBuffer<T>
implements BlockingQueue<T> {
    protected final int capacity;
    protected final AtomicReferenceArray<T> array;
    protected final AtomicInteger wi = new AtomicInteger();
    protected int ri;
    protected final AtomicInteger size = new AtomicInteger(0);
    protected final boolean block_on_empty;
    protected final boolean block_on_full;
    protected final Lock lock = new ReentrantLock();
    protected final Condition not_empty = this.lock.newCondition();
    protected final Condition not_full = this.lock.newCondition();
    protected final IntUnaryOperator INCR;
    protected final IntUnaryOperator INCR_INDEX;
    protected static final IntUnaryOperator DECR = x -> x == 0 ? x : x - 1;
    protected static final IntBinaryOperator DECR_DELTA = (x, y) -> y >= x ? 0 : x - y;

    public ConcurrentBlockingRingBuffer(int capacity) {
        this(capacity, false, false);
    }

    public ConcurrentBlockingRingBuffer(int capacity, boolean block_on_empty, boolean block_on_full) {
        this.capacity = capacity;
        this.array = new AtomicReferenceArray(this.capacity);
        this.block_on_empty = block_on_empty;
        this.block_on_full = block_on_full;
        if (capacity == 0) {
            throw new IllegalArgumentException(String.format("Capacity (%d) needs to be positive", capacity));
        }
        this.INCR = x -> x >= capacity ? x : x + 1;
        this.INCR_INDEX = x -> x == capacity - 1 ? 0 : x + 1;
    }

    public static <T> ConcurrentBlockingRingBuffer<T> createBlocking(int capacity) {
        return new ConcurrentBlockingRingBuffer<T>(capacity, true, true);
    }

    public int capacity() {
        return this.array.length();
    }

    public int readIndex() {
        return this.ri;
    }

    public int writeIndex() {
        return this.wi.get();
    }

    @Override
    public void put(T t) throws InterruptedException {
        Objects.requireNonNull(t);
        if (!this.block_on_full) {
            throw new IllegalStateException(String.format("put() must not be called when block_on_full=%b", this.block_on_full));
        }
        boolean rc;
        block3: while (!(rc = this.offer(t))) {
            this.lock.lockInterruptibly();
            try {
                while (true) {
                    if (this.size.get() < this.capacity) continue block3;
                    this.not_full.await();
                }
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        return;
    }

    @Override
    public boolean add(T t) {
        boolean rc = this.offer(t);
        if (rc) {
            return rc;
        }
        throw new IllegalStateException(String.format("no space available: capacity=%d, size=%d", this.capacity, this.size.get()));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(T t) {
        int old_size = this.size.getAndUpdate(this.INCR);
        if (old_size < this.capacity) {
            int index = this.wi.getAndUpdate(this.INCR_INDEX);
            this.array.set(index, t);
            if (old_size == 0 && this.block_on_empty) {
                this.signalNotEmpty();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean offer(T t, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.ri = 0;
        this.wi.set(0);
        this.size.set(0);
        for (int i = 0; i < this.capacity; ++i) {
            this.array.set(i, null);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    @Override
    public T poll() {
        T val = this.array.get(this.ri);
        if (val == null) {
            return null;
        }
        int old_size = this.size.getAndUpdate(DECR);
        if (old_size == 0) {
            return null;
        }
        this.array.set(this.ri, null);
        this.ri = this.advance(this.ri);
        if (this.block_on_full && old_size >= this.capacity) {
            this.signalNotFull();
        }
        return val;
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super T> c, int max) {
        T el;
        if (this == Objects.requireNonNull(c)) {
            throw new IllegalArgumentException();
        }
        if (max <= 0) {
            return 0;
        }
        int drained = 0;
        max = Math.min(max, this.size.get());
        for (int i = 0; i < max && (el = this.array.get(this.ri)) != null; ++i) {
            this.array.set(this.ri, null);
            c.add(el);
            ++drained;
            this.ri = this.advance(this.ri);
        }
        if (drained > 0) {
            int old_size = this.size.getAndAccumulate(drained, DECR_DELTA);
            if (this.block_on_full && old_size >= this.capacity) {
                this.signalNotFull();
            }
        }
        return drained;
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public T element() {
        return null;
    }

    @Override
    public T peek() {
        return null;
    }

    @Override
    public T take() throws InterruptedException {
        if (!this.block_on_empty) {
            throw new IllegalStateException(String.format("take() must not be called when block_on_empty=%b", this.block_on_empty));
        }
        T retval;
        block5: while ((retval = this.poll()) == null) {
            this.lock.lockInterruptibly();
            try {
                while (true) {
                    if (this.size.get() != 0) continue block5;
                    this.not_empty.await();
                }
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
                continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        return retval;
    }

    @Override
    public T remove() {
        T el = this.poll();
        if (el != null) {
            return el;
        }
        throw new NoSuchElementException("queue is empty");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        for (T el : this) {
            if (!Objects.equals(el, o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new BufIterator();
    }

    @Override
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.size.get();
    }

    public String toString() {
        return String.format("ri=%d wi=%d size=%,d%s", this.ri, this.wi.get(), this.size.get(), this.isEmpty() ? "" : " [" + Util.printListWithDelimiter(this::iterator, ", ", this.size()) + "]");
    }

    public List<T> contents() {
        ArrayList<T> l = new ArrayList<T>(this.capacity);
        for (T el : this) {
            l.add(el);
        }
        return l;
    }

    protected int advance(int idx) {
        return idx + 1 >= this.capacity ? 0 : idx + 1;
    }

    protected int advance(int idx, int delta) {
        return idx + delta >= this.capacity ? (idx + delta) % this.capacity : idx + delta;
    }

    protected void signalNotEmpty() {
        this.lock.lock();
        try {
            this.not_empty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void signalNotFull() {
        this.lock.lock();
        try {
            this.not_full.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected class BufIterator
    implements Iterator<T> {
        int index;
        int consumed;
        int to_consume;

        protected BufIterator() {
            this.index = ConcurrentBlockingRingBuffer.this.ri;
            this.consumed = 0;
            this.to_consume = ConcurrentBlockingRingBuffer.this.size.get();
        }

        @Override
        public boolean hasNext() {
            return this.consumed < this.to_consume;
        }

        @Override
        public T next() {
            int idx = this.index;
            this.index = ConcurrentBlockingRingBuffer.this.INCR_INDEX.applyAsInt(this.index);
            ++this.consumed;
            if (idx < 0 || idx >= ConcurrentBlockingRingBuffer.this.array.length()) {
                throw new NoSuchElementException(String.format("idx: %d", idx));
            }
            return ConcurrentBlockingRingBuffer.this.array.get(idx);
        }
    }
}

