/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.json;

import java.util.List;
import java.util.Objects;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.impl.json.BaseJsonWriter;
import org.infinispan.protostream.impl.json.JsonToken;
import org.infinispan.protostream.impl.json.JsonTokenWriter;
import org.infinispan.protostream.impl.json.ObjectJsonWriter;

final class ArrayJsonWriter
extends BaseJsonWriter {
    private ObjectJsonWriter delegate = null;
    private boolean done;

    ArrayJsonWriter(ImmutableSerializationContext ctx, List<JsonTokenWriter> ast, FieldDescriptor descriptor) {
        super(ctx, ast, descriptor);
    }

    @Override
    public void onStartNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        if (fieldNumber != this.field()) {
            throw new IllegalStateException("Array handling incorrect field");
        }
        if (this.delegate != null && this.delegate.field() == fieldNumber) {
            this.delegate = null;
            this.replaceLastToken(JsonToken.RIGHT_BRACKET, JsonToken.COMMA);
            this.done = false;
        } else {
            if (JsonToken.followedByComma(this.lastToken())) {
                this.pushToken(JsonToken.COMMA);
                this.pushToken(JsonTokenWriter.string(fieldDescriptor.getName()));
                this.pushToken(JsonToken.COLON);
            }
            this.pushToken(JsonToken.LEFT_BRACKET);
        }
        this.delegate = (ObjectJsonWriter)this.objectWriter(fieldNumber, fieldDescriptor);
        if (this.delegate.isComplexObject()) {
            this.delegate.onStartNested(fieldNumber, fieldDescriptor);
        }
    }

    @Override
    public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
        Objects.requireNonNull(this.delegate, "Handling tag without starting nested");
        if (this.delegate.isComplexObject()) {
            this.delegate.onTag(fieldNumber, fieldDescriptor, tagValue);
            return;
        }
        this.writePrimitiveOrDispatch(fieldNumber, fieldDescriptor, tagValue, this.delegate);
    }

    @Override
    public void onEnd() {
        if (this.delegate.isComplexObject()) {
            this.delegate.onEnd();
        }
        if (!this.isDone()) {
            this.pushToken(JsonToken.RIGHT_BRACKET);
        }
    }

    @Override
    public void onEndNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        if (this.delegate.isComplexObject()) {
            this.delegate.onEndNested(fieldNumber, fieldDescriptor);
        }
        this.pushToken(JsonToken.RIGHT_BRACKET);
        this.done = true;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean acceptField(int fieldNumber) {
        return this.field() == fieldNumber;
    }

    @Override
    protected boolean isRoot() {
        return false;
    }
}

