/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.json;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.descriptors.AnnotatedDescriptor;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.impl.json.ArrayJsonWriter;
import org.infinispan.protostream.impl.json.ContainerObjectWriter;
import org.infinispan.protostream.impl.json.FieldAwareTagHandler;
import org.infinispan.protostream.impl.json.JsonHelper;
import org.infinispan.protostream.impl.json.JsonToken;
import org.infinispan.protostream.impl.json.JsonTokenWriter;
import org.infinispan.protostream.impl.json.MapJsonWriter;
import org.infinispan.protostream.impl.json.ObjectJsonWriter;
import org.infinispan.protostream.impl.json.RootJsonWriter;

abstract class BaseJsonWriter
implements FieldAwareTagHandler {
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    static final int EMPTY_FIELD_NUMBER = Integer.MIN_VALUE;
    protected final FieldDescriptor descriptor;
    protected final List<JsonTokenWriter> ast;
    protected final ImmutableSerializationContext ctx;
    private FieldAwareTagHandler delegate;
    protected Integer wrappedTypeId;
    protected String wrappedTypeName;
    private static final ThreadLocal<DateFormat> timestampFormat = ThreadLocal.withInitial(() -> {
        SimpleDateFormat sdf = new SimpleDateFormat(RFC_3339_DATE_FORMAT);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        sdf.setCalendar(calendar);
        return sdf;
    });

    protected BaseJsonWriter(ImmutableSerializationContext ctx, List<JsonTokenWriter> ast, FieldDescriptor descriptor) {
        this.ctx = ctx;
        this.ast = ast;
        this.descriptor = descriptor;
    }

    protected BaseJsonWriter(ImmutableSerializationContext ctx, List<JsonTokenWriter> ast) {
        this(ctx, ast, null);
    }

    @Override
    public int field() {
        return this.descriptor != null ? this.descriptor.getNumber() : Integer.MIN_VALUE;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean acceptField(int fieldNumber) {
        return true;
    }

    protected abstract boolean isRoot();

    @Override
    public final void onStart(GenericDescriptor descriptor) {
        if (JsonHelper.isContainerAdapter(this.ctx, descriptor)) {
            this.delegate = new ContainerObjectWriter(this.ctx, this.ast, null);
        }
        this.pushToken(JsonToken.LEFT_BRACE);
        if (descriptor == null) {
            return;
        }
        this.writeType(descriptor);
    }

    @Override
    public abstract void onStartNested(int var1, FieldDescriptor var2);

    @Override
    public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
        if (this.delegate != null) {
            if (this.delegate.field() != fieldNumber && !this.delegate.acceptField(fieldNumber)) {
                this.delegate.onEndNested(this.delegate.field(), null);
                this.delegate = null;
                this.onTag(fieldNumber, fieldDescriptor, tagValue);
                return;
            }
            this.delegate.onTag(fieldNumber, fieldDescriptor, tagValue);
            return;
        }
        if (fieldDescriptor == null) {
            return;
        }
        if (fieldDescriptor.getMessageType() == null && fieldDescriptor.getEnumType() == null && !WrappedMessage.isWrappedMessageField(fieldDescriptor)) {
            this.writeTerminalField(fieldNumber, fieldDescriptor, tagValue);
            return;
        }
        switch (fieldNumber) {
            case 19: {
                this.wrappedTypeId = (Integer)tagValue;
                this.pushToken(JsonToken.COMMA);
                break;
            }
            case 16: {
                this.wrappedTypeName = (String)tagValue;
                this.pushToken(JsonToken.COMMA);
                break;
            }
            case 18: {
                if (this.field() != fieldNumber) {
                    this.pushToken(JsonTokenWriter.string(fieldDescriptor.getName()));
                    this.pushToken(JsonToken.COLON);
                    EnumDescriptor descriptor = (EnumDescriptor)this.getDescriptor();
                    String enumConstantName = descriptor.findValueByNumber((Integer)tagValue).getName();
                    FieldAwareTagHandler child = this.objectWriter(fieldNumber, fieldDescriptor);
                    child.onStart(descriptor);
                    child.onTag(fieldNumber, fieldDescriptor, enumConstantName);
                    child.onEnd();
                    break;
                }
                this.writeValue(fieldDescriptor, tagValue, true);
                break;
            }
            case 17: {
                JsonToken lt = this.lastToken();
                if (lt != null && lt != JsonToken.COLON) {
                    if (JsonToken.followedByComma(lt)) {
                        this.pushToken(JsonToken.COMMA);
                    }
                    this.pushToken(JsonTokenWriter.string(fieldDescriptor.getName()));
                    this.pushToken(JsonToken.COLON);
                }
                this.wrappedMessage((byte[])tagValue, fieldDescriptor);
                break;
            }
            case 28: {
                if (this.field() == fieldNumber) break;
                String type = (String)tagValue;
                GenericDescriptor descriptor = this.ctx.getDescriptorByName(type);
                this.delegate = this.objectWriter(fieldNumber, fieldDescriptor);
                if (JsonToken.followedByComma(this.lastToken())) {
                    this.pushToken(JsonToken.COMMA);
                    this.pushToken(JsonTokenWriter.string(fieldDescriptor.getName()));
                    this.pushToken(JsonToken.COLON);
                }
                this.delegate.onStart(descriptor);
                break;
            }
            case 24: 
            case 25: {
                if (this.field() == Integer.MIN_VALUE) {
                    GenericDescriptor descriptor = this.getProtoStreamDescriptor(Instant.class);
                    this.delegate = this.objectWriter(fieldNumber, fieldDescriptor);
                    this.delegate.onStart(descriptor);
                    this.delegate.onTag(fieldNumber, fieldDescriptor, tagValue);
                    break;
                }
                this.writeValue(fieldDescriptor, tagValue, false);
                break;
            }
            case 23: {
                if (this.field() != fieldNumber) {
                    GenericDescriptor descriptor = this.getProtoStreamDescriptor(Date.class);
                    this.delegate = this.objectWriter(fieldNumber, fieldDescriptor);
                    this.delegate.onStart(descriptor);
                    this.delegate.onTag(fieldNumber, fieldDescriptor, tagValue);
                    break;
                }
                this.writeValue(fieldDescriptor, tagValue, false);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 27: 
            case 30: {
                this.writeTerminalField(fieldNumber, fieldDescriptor, tagValue);
            }
        }
    }

    @Override
    public void onEnd() {
        if (this.delegate != null) {
            this.delegate.onEnd();
            this.delegate = null;
        }
        this.pushToken(JsonToken.RIGHT_BRACE);
    }

    private void writeTerminalField(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
        if (this.field() != fieldNumber) {
            if (fieldDescriptor.isRepeated()) {
                this.delegate = this.repeatedWriter(fieldNumber, fieldDescriptor);
                this.delegate.onStartNested(fieldNumber, fieldDescriptor);
                this.delegate.onTag(fieldNumber, fieldDescriptor, tagValue);
                return;
            }
            if (this.isRoot()) {
                RootJsonWriter root = new RootJsonWriter(this.ctx, this.ast, fieldDescriptor, true);
                root.onStartNested(fieldNumber, fieldDescriptor);
                root.onTag(fieldNumber, fieldDescriptor, tagValue);
                root.onEndNested(fieldNumber, fieldDescriptor);
                return;
            }
        }
        this.writeValue(fieldDescriptor, tagValue, false);
    }

    private void writeValue(FieldDescriptor fieldDescriptor, Object tagValue, boolean forceValueField) {
        if (JsonToken.followedByComma(this.lastToken())) {
            this.pushToken(JsonToken.COMMA);
        }
        String name = forceValueField || this.isRoot() ? "_value" : fieldDescriptor.getName();
        this.pushToken(JsonTokenWriter.string(name));
        this.pushToken(JsonToken.COLON);
        this.writeTagValue(fieldDescriptor, tagValue);
    }

    protected final void writePrimitiveOrDispatch(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue, TagHandler dispatcher) {
        switch (fieldNumber) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                this.writeRawPrimitive(fieldDescriptor, tagValue);
                break;
            }
            default: {
                if (dispatcher == null) {
                    throw new IllegalStateException("Dispatcher required to handle field: " + String.valueOf(fieldDescriptor));
                }
                dispatcher.onTag(fieldNumber, fieldDescriptor, tagValue);
            }
        }
    }

    private void writeRawPrimitive(FieldDescriptor fieldDescriptor, Object tagValue) {
        if (JsonToken.followedByComma(this.lastToken())) {
            this.pushToken(JsonToken.COMMA);
        }
        this.writeTagValue(fieldDescriptor, tagValue);
    }

    protected final void writeType(AnnotatedDescriptor descriptor) {
        String type;
        if (descriptor instanceof FieldDescriptor) {
            FieldDescriptor fd = (FieldDescriptor)descriptor;
            if (fd.getType() == Type.MESSAGE) {
                this.writeType(fd.getMessageType());
                return;
            }
            type = fd.getTypeName();
        } else {
            type = descriptor.getFullName();
        }
        this.pushToken(JsonTokenWriter.string("_type"));
        this.pushToken(JsonToken.COLON);
        this.pushToken(JsonTokenWriter.value(type, true));
    }

    private GenericDescriptor getDescriptor() {
        if (this.wrappedTypeId != null) {
            return this.ctx.getDescriptorByTypeId(this.wrappedTypeId);
        }
        if (this.wrappedTypeName != null) {
            return this.ctx.getDescriptorByName(this.wrappedTypeName);
        }
        return this.ctx.getDescriptorByTypeId(0);
    }

    private void wrappedMessage(byte[] message, FieldDescriptor fd) {
        try {
            Descriptor descriptor = (Descriptor)this.getDescriptor();
            ObjectJsonWriter handler = new ObjectJsonWriter(this.ctx, this.ast, fd);
            ProtobufParser.INSTANCE.parse((TagHandler)handler, descriptor, message);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed handling nested message", e);
        }
    }

    private GenericDescriptor getProtoStreamDescriptor(Class<?> clazz) {
        BaseMarshaller<?> marshaller = this.ctx.getMarshaller(clazz);
        if (marshaller == null) {
            throw new IllegalStateException(String.format("Unable to convert %s to JSON", clazz));
        }
        return this.ctx.getDescriptorByName(marshaller.getTypeName());
    }

    protected void pushToken(JsonTokenWriter token) {
        this.ast.add(token);
    }

    protected void replaceLastToken(JsonToken prev, JsonTokenWriter curr) {
        if (this.ast.isEmpty()) {
            return;
        }
        int last = this.ast.size() - 1;
        JsonTokenWriter jtw = Objects.requireNonNull(this.ast.get(last));
        if (jtw.token() != prev) {
            throw new IllegalArgumentException("Last token is not " + String.valueOf(prev));
        }
        this.ast.set(last, curr);
    }

    protected final JsonToken lastToken() {
        if (this.ast.isEmpty()) {
            return null;
        }
        JsonTokenWriter jtw = Objects.requireNonNull(this.ast.get(this.ast.size() - 1));
        return jtw.token();
    }

    protected final void writeTagValue(FieldDescriptor fd, Object tagValue) {
        switch (fd.getType()) {
            case STRING: {
                this.pushToken(JsonTokenWriter.value(BaseJsonWriter.escapeJson((String)tagValue, true), true));
                break;
            }
            case UINT64: 
            case FIXED64: {
                this.pushToken(JsonTokenWriter.value(Long.toUnsignedString((Long)tagValue), false));
                break;
            }
            case UINT32: 
            case FIXED32: {
                this.pushToken(JsonTokenWriter.value(Integer.toUnsignedString((Integer)tagValue), false));
                break;
            }
            case FLOAT: {
                Float f = (Float)tagValue;
                if (f.isInfinite() || f.isNaN()) {
                    this.pushToken(JsonTokenWriter.value(Float.toString(((Float)tagValue).floatValue()), true));
                    break;
                }
                this.pushToken(JsonTokenWriter.value(tagValue, false));
                break;
            }
            case DOUBLE: {
                Double d = (Double)tagValue;
                if (d.isInfinite() || d.isNaN()) {
                    this.pushToken(JsonTokenWriter.value(Double.toString((Double)tagValue), true));
                    break;
                }
                this.pushToken(JsonTokenWriter.value(tagValue, false));
                break;
            }
            case ENUM: {
                EnumValueDescriptor evd = fd.getEnumType().findValueByNumber((Integer)tagValue);
                this.pushToken(JsonTokenWriter.value(evd.getName(), true));
                break;
            }
            case BYTES: {
                String encoded = Base64.getEncoder().encodeToString((byte[])tagValue);
                this.pushToken(JsonTokenWriter.value(encoded, true));
                break;
            }
            default: {
                if (tagValue instanceof Date) {
                    Date d = (Date)tagValue;
                    this.pushToken(JsonTokenWriter.value(BaseJsonWriter.formatDate(d), true));
                    break;
                }
                this.pushToken(JsonTokenWriter.value(tagValue, tagValue instanceof CharSequence));
            }
        }
    }

    protected final FieldAwareTagHandler objectWriter(int fieldNumber, FieldDescriptor fd) {
        FieldAwareTagHandler d = this.verifyDelegate(fieldNumber, fd);
        return d == null ? new ObjectJsonWriter(this.ctx, this.ast, fd) : d;
    }

    protected final FieldAwareTagHandler repeatedWriter(int fieldNumber, FieldDescriptor fd) {
        FieldAwareTagHandler d = this.verifyDelegate(fieldNumber, fd);
        return d == null ? new ArrayJsonWriter(this.ctx, this.ast, fd) : d;
    }

    protected final FieldAwareTagHandler mapWriter(int fieldNumber, FieldDescriptor fd) {
        FieldAwareTagHandler d = this.verifyDelegate(fieldNumber, fd);
        return d == null ? new MapJsonWriter(this.ctx, this.ast, fd) : d;
    }

    private FieldAwareTagHandler verifyDelegate(int fieldNumber, FieldDescriptor fd) {
        if (this.delegate == null) {
            return null;
        }
        if (this.delegate.field() == fieldNumber) {
            return this.delegate;
        }
        this.delegate.onEndNested(fieldNumber, fd);
        this.delegate = null;
        return null;
    }

    private static String escapeJson(String unsafe, boolean htmlSafe) {
        StringBuilder out = new StringBuilder();
        int prev = 0;
        int len = unsafe.length();
        for (int cur = 0; cur < len; ++cur) {
            char ch = unsafe.charAt(cur);
            String esc = null;
            if (ch < ' ') {
                esc = switch (ch) {
                    case '\t' -> "\\t";
                    case '\b' -> "\\b";
                    case '\n' -> "\\n";
                    case '\r' -> "\\r";
                    case '\f' -> "\\f";
                    default -> String.format("\\u%04x", ch);
                };
            } else if (ch < '\u0080') {
                if (ch == '\"') {
                    esc = "\\\"";
                } else if (ch == '\\') {
                    esc = "\\\\";
                } else if (htmlSafe) {
                    esc = switch (ch) {
                        case '<' -> "\\u003c";
                        case '>' -> "\\u003e";
                        case '&' -> "\\u0026";
                        case '=' -> "\\u003d";
                        case '\'' -> "\\u0027";
                        default -> null;
                    };
                }
            } else if (ch == '\u2028') {
                esc = "\\u2028";
            } else {
                if (ch != '\u2029') continue;
                esc = "\\u2029";
            }
            if (esc == null) continue;
            if (prev < cur) {
                out.append(unsafe, prev, cur);
            }
            prev = cur + 1;
            out.append(esc);
        }
        if (prev < len) {
            out.append(unsafe, prev, len);
        }
        return out.toString();
    }

    private static String formatDate(Date date) {
        return timestampFormat.get().format(date);
    }

    static boolean isComplexType(FieldDescriptor descriptor) {
        Objects.requireNonNull(descriptor, "descriptor is null");
        return descriptor.getMessageType() != null && descriptor.getMessageType().getFields().size() > 1;
    }
}

