/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.json;

import java.util.List;
import java.util.Objects;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.impl.json.BaseJsonWriter;
import org.infinispan.protostream.impl.json.FieldAwareTagHandler;
import org.infinispan.protostream.impl.json.JsonToken;
import org.infinispan.protostream.impl.json.JsonTokenWriter;

final class MapJsonWriter
extends BaseJsonWriter {
    private FieldAwareTagHandler delegate;
    private int lastField = 0;
    private boolean done;

    public MapJsonWriter(ImmutableSerializationContext ctx, List<JsonTokenWriter> ast, FieldDescriptor descriptor) {
        super(ctx, ast, descriptor);
    }

    @Override
    public void onStartNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        if (fieldNumber == this.field() && fieldDescriptor == this.descriptor) {
            if (this.done) {
                this.replaceLastToken(JsonToken.RIGHT_BRACE, JsonToken.COMMA);
                this.done = false;
                return;
            }
            if (JsonToken.followedByComma(this.lastToken())) {
                this.pushToken(JsonToken.COMMA);
                this.pushToken(JsonTokenWriter.string(fieldDescriptor.getName()));
                this.pushToken(JsonToken.COLON);
            } else if (JsonToken.isOpen(this.lastToken())) {
                this.pushToken(JsonTokenWriter.string(fieldDescriptor.getName()));
                this.pushToken(JsonToken.COLON);
            }
            return;
        }
        if (fieldNumber != 2) {
            throw new IllegalStateException("Maps only have nested objects for values");
        }
        this.delegate = this.createDelegate(fieldNumber, fieldDescriptor);
        this.pushToken(JsonToken.LEFT_BRACE);
    }

    @Override
    public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
        this.lastField = fieldNumber;
        if (fieldNumber == 1) {
            if (this.lastToken() == JsonToken.COLON) {
                this.pushToken(JsonToken.LEFT_BRACE);
            }
            this.pushToken(JsonTokenWriter.string(Objects.toString(tagValue)));
            this.pushToken(JsonToken.COLON);
            return;
        }
        if (this.delegate != null) {
            this.lastField = this.delegate.field();
            this.delegate.onTag(fieldNumber, fieldDescriptor, tagValue);
            return;
        }
        this.writePrimitiveOrDispatch(fieldNumber, fieldDescriptor, tagValue, null);
    }

    @Override
    public void onEndNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        if (this.delegate != null) {
            this.delegate.onEndNested(fieldNumber, fieldDescriptor);
            this.delegate = null;
            return;
        }
        if (fieldDescriptor != this.descriptor) {
            return;
        }
        if (this.lastField == 2) {
            this.pushToken(JsonToken.RIGHT_BRACE);
        }
        this.done = true;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    protected boolean isRoot() {
        return false;
    }

    private FieldAwareTagHandler createDelegate(int fieldNumber, FieldDescriptor fd) {
        if (this.delegate == null) {
            if (!fd.isRepeated()) {
                return this.objectWriter(fieldNumber, fd);
            }
            if (fd.isMap()) {
                return this.mapWriter(fieldNumber, fd);
            }
            return this.repeatedWriter(fieldNumber, fd);
        }
        if (this.delegate.field() == fieldNumber) {
            return this.delegate;
        }
        if (!this.delegate.isDone()) {
            return this.delegate;
        }
        this.delegate.onEndNested(fieldNumber, fd);
        this.delegate = null;
        return this.createDelegate(fieldNumber, fd);
    }
}

