/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import org.dbunit.DatabaseUnitRuntimeException;
import org.dbunit.DefaultOperationListener;
import org.dbunit.IDatabaseTester;
import org.dbunit.IOperationListener;
import org.dbunit.assertion.DefaultFailureHandler;
import org.dbunit.assertion.SimpleAssert;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseTester
extends SimpleAssert
implements IDatabaseTester {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDatabaseTester.class);
    private IDataSet dataSet;
    private String schema;
    private DatabaseOperation setUpOperation = DatabaseOperation.CLEAN_INSERT;
    private DatabaseOperation tearDownOperation = DatabaseOperation.NONE;
    private IOperationListener operationListener;

    public AbstractDatabaseTester() {
        this((String)null);
    }

    public AbstractDatabaseTester(String schema) {
        super(new DefaultFailureHandler());
        this.schema = schema;
    }

    @Override
    public void closeConnection(IDatabaseConnection connection) throws Exception {
        logger.debug("closeConnection(connection={}) - start", (Object)connection);
        connection.close();
    }

    @Override
    public IDataSet getDataSet() {
        logger.debug("getDataSet() - start");
        return this.dataSet;
    }

    @Override
    public void onSetup() throws Exception {
        logger.debug("onSetup() - start");
        this.executeOperation(this.getSetUpOperation(), OperationType.SET_UP);
    }

    @Override
    public void onTearDown() throws Exception {
        logger.debug("onTearDown() - start");
        this.executeOperation(this.getTearDownOperation(), OperationType.TEAR_DOWN);
    }

    @Override
    public void setDataSet(IDataSet dataSet) {
        logger.debug("setDataSet(dataSet={}) - start", (Object)dataSet);
        this.dataSet = dataSet;
    }

    @Override
    public void setSchema(String schema) {
        logger.debug("setSchema(schema={}) - start", (Object)schema);
        logger.warn("setSchema() should not be used anymore");
        this.schema = schema;
    }

    @Override
    public void setSetUpOperation(DatabaseOperation setUpOperation) {
        logger.debug("setSetUpOperation(setUpOperation={}) - start", (Object)setUpOperation);
        this.setUpOperation = setUpOperation;
    }

    @Override
    public void setTearDownOperation(DatabaseOperation tearDownOperation) {
        logger.debug("setTearDownOperation(tearDownOperation={}) - start", (Object)tearDownOperation);
        this.tearDownOperation = tearDownOperation;
    }

    protected String getSchema() {
        logger.trace("getSchema() - start");
        return this.schema;
    }

    @Override
    public DatabaseOperation getSetUpOperation() {
        logger.trace("getSetUpOperation() - start");
        return this.setUpOperation;
    }

    @Override
    public DatabaseOperation getTearDownOperation() {
        logger.trace("getTearDownOperation() - start");
        return this.tearDownOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeOperation(DatabaseOperation operation, OperationType type) throws Exception {
        logger.debug("executeOperation(operation={}) - start", (Object)operation);
        if (operation != DatabaseOperation.NONE) {
            if (this.operationListener == null) {
                logger.debug("OperationListener is null and will be defaulted.");
                this.operationListener = new DefaultOperationListener();
            }
            IDatabaseConnection connection = this.getConnection();
            this.operationListener.connectionRetrieved(connection);
            try {
                operation.execute(connection, this.getDataSet());
            }
            finally {
                if (type == OperationType.SET_UP) {
                    this.operationListener.operationSetUpFinished(connection);
                } else if (type == OperationType.TEAR_DOWN) {
                    this.operationListener.operationTearDownFinished(connection);
                } else {
                    throw new DatabaseUnitRuntimeException("Cannot happen - unknown OperationType specified: " + type);
                }
            }
        }
    }

    @Override
    public void setOperationListener(IOperationListener operationListener) {
        logger.debug("setOperationListener(operationListener={}) - start", (Object)operationListener);
        this.operationListener = operationListener;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append("[");
        sb.append("schema=").append(this.schema);
        sb.append(", dataSet=").append(this.dataSet);
        sb.append(", setUpOperation=").append(this.setUpOperation);
        sb.append(", tearDownOperation=").append(this.tearDownOperation);
        sb.append(", operationListener=").append(this.operationListener);
        sb.append("]");
        return sb.toString();
    }

    private static final class OperationType {
        public static final OperationType SET_UP = new OperationType("setUp");
        public static final OperationType TEAR_DOWN = new OperationType("tearDown");
        private final String key;

        private OperationType(String key) {
            this.key = key;
        }

        public String toString() {
            return "OperationType: " + this.key;
        }
    }
}

