/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;

public class TableDecoratorDataSet
extends AbstractDataSet {
    private final IDataSet _dataSet;
    private final TableDecoratorFunction _decoratorFunction;

    public TableDecoratorDataSet(IDataSet dataSet, TableDecoratorFunction decoratorFunction) {
        this._dataSet = dataSet;
        this._decoratorFunction = decoratorFunction;
    }

    @Override
    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        return new FilterIterator(reversed ? this._dataSet.reverseIterator() : this._dataSet.iterator());
    }

    @FunctionalInterface
    public static interface TableDecoratorFunction {
        public ITable apply(ITable var1) throws DataSetException;
    }

    private class FilterIterator
    implements ITableIterator {
        private final ITableIterator _iterator;

        public FilterIterator(ITableIterator _iterator) {
            this._iterator = _iterator;
        }

        @Override
        public boolean next() throws DataSetException {
            return this._iterator.next();
        }

        @Override
        public ITableMetaData getTableMetaData() throws DataSetException {
            return this.getTable().getTableMetaData();
        }

        @Override
        public ITable getTable() throws DataSetException {
            return TableDecoratorDataSet.this._decoratorFunction.apply(this._iterator.getTable());
        }
    }
}

