/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger(LongDataType.class);

    LongDataType() {
        super("BIGINT", -5, Long.class, true);
    }

    @Override
    public Object typeCast(Object value) throws TypeCastException {
        logger.debug("typeCast(value={}) - start", value);
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        try {
            return this.typeCast(new BigDecimal(value.toString()));
        }
        catch (NumberFormatException e) {
            throw new TypeCastException(value, this, e);
        }
    }

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)column, (Object)resultSet);
        long rawValue = resultSet.getLong(column);
        Long value = resultSet.wasNull() ? null : Long.valueOf(rawValue);
        logger.debug("getSqlValue: column={}, value={}", (Object)column, (Object)value);
        return value;
    }

    @Override
    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, column, statement});
        statement.setLong(column, ((Number)this.typeCast(value)).longValue());
    }
}

