/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.yaml;

import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

class YamlWriter {
    private Yaml _yaml;
    private Writer _out;
    private boolean _useFlowStyle;

    public YamlWriter(Writer out) {
        this(out, false);
    }

    public YamlWriter(Writer out, boolean useFlowStyle) {
        this._out = out;
        this._useFlowStyle = useFlowStyle;
    }

    public void setUseFlowStyle(boolean useFlowStyle) {
        this._useFlowStyle = useFlowStyle;
    }

    public void write(IDataSet dataSet) throws DataSetException {
        LinkedHashMap<String, List<LinkedHashMap<String, Object>>> dataSetAsMap = this.dataSetAsMap(dataSet);
        DumperOptions options = new DumperOptions();
        if (this._useFlowStyle) {
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
            options.setPrettyFlow(true);
        } else {
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setIndent(4);
            options.setIndicatorIndent(2);
        }
        this._yaml = new Yaml(options);
        this._yaml.dump(dataSetAsMap, this._out);
    }

    private LinkedHashMap<String, List<LinkedHashMap<String, Object>>> dataSetAsMap(IDataSet dataSet) throws DataSetException {
        LinkedHashMap<String, List<LinkedHashMap<String, Object>>> result = new LinkedHashMap<String, List<LinkedHashMap<String, Object>>>();
        ITableIterator iterator = dataSet.iterator();
        while (iterator.next()) {
            ITableMetaData tableMetaData = iterator.getTableMetaData();
            ArrayList tableRows = new ArrayList();
            ITable table = iterator.getTable();
            for (int row = 0; row < table.getRowCount(); ++row) {
                LinkedHashMap<String, Object> rowMap = new LinkedHashMap<String, Object>();
                for (Column column : tableMetaData.getColumns()) {
                    String columnName = column.getColumnName();
                    Object value = table.getValue(row, columnName);
                    if (value == null) continue;
                    rowMap.put(columnName, value);
                }
                tableRows.add(rowMap);
            }
            result.put(tableMetaData.getTableName(), tableRows);
        }
        return result;
    }
}

