/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.mssql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.IColumnFilter;
import org.dbunit.operation.AbstractOperation;
import org.dbunit.operation.CompositeOperation;
import org.dbunit.operation.DatabaseOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertIdentityOperation
extends AbstractOperation {
    private static final Logger logger = LoggerFactory.getLogger(InsertIdentityOperation.class);
    public static final DatabaseOperation INSERT = new InsertIdentityOperation(DatabaseOperation.INSERT);
    public static final DatabaseOperation CLEAN_INSERT = new CompositeOperation(DatabaseOperation.DELETE_ALL, new InsertIdentityOperation(DatabaseOperation.INSERT));
    public static final DatabaseOperation REFRESH = new InsertIdentityOperation(DatabaseOperation.REFRESH);
    private static final IColumnFilter DEFAULT_IDENTITY_FILTER = new IColumnFilter(){

        @Override
        public boolean accept(String tableName, Column column) {
            return column.getSqlTypeName().endsWith("identity");
        }
    };
    public static final IColumnFilter IDENTITY_FILTER_EXTENDED = new IColumnFilter(){

        @Override
        public boolean accept(String tableName, Column column) {
            boolean isIdentityCol;
            String remarks = column.getRemarks();
            boolean bl = isIdentityCol = remarks != null && (remarks.indexOf("GENERATED BY DEFAULT AS IDENTITY") > -1 || remarks.indexOf("GENERATED ALWAYS AS IDENTITY") > -1);
            if (!isIdentityCol) {
                isIdentityCol = Column.AutoIncrement.YES == column.getAutoIncrement();
            }
            return isIdentityCol;
        }
    };
    private final DatabaseOperation _operation;

    public InsertIdentityOperation(DatabaseOperation operation) {
        this._operation = operation;
    }

    boolean hasIdentityColumn(ITableMetaData metaData, IDatabaseConnection connection) throws DataSetException {
        logger.debug("hasIdentityColumn(metaData={}, connection={}) - start", (Object)metaData, (Object)connection);
        DatabaseConfig config = connection.getConfig();
        IColumnFilter identityFilter = (IColumnFilter)config.getProperty("http://www.dbunit.org/properties/mssql/identityColumnFilter");
        if (identityFilter == null) {
            identityFilter = DEFAULT_IDENTITY_FILTER;
        }
        Column[] columns = metaData.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!identityFilter.accept(metaData.getTableName(), columns[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        logger.debug("execute(connection={}, dataSet={}) - start", (Object)connection, (Object)dataSet);
        Connection jdbcConnection = connection.getConnection();
        Statement statement = jdbcConnection.createStatement();
        boolean wasAutoCommit = false;
        try {
            IDataSet databaseDataSet = connection.createDataSet();
            if (jdbcConnection.getAutoCommit()) {
                wasAutoCommit = true;
                jdbcConnection.setAutoCommit(false);
            }
            ITableIterator iterator = dataSet.iterator();
            while (iterator.next()) {
                StringBuilder sqlBuffer;
                ITable table = iterator.getTable();
                String tableName = table.getTableMetaData().getTableName();
                ITableMetaData metaData = databaseDataSet.getTableMetaData(tableName);
                boolean hasIdentityColumn = this.hasIdentityColumn(metaData, connection);
                if (hasIdentityColumn) {
                    sqlBuffer = new StringBuilder(128);
                    sqlBuffer.append("SET IDENTITY_INSERT ");
                    sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
                    sqlBuffer.append(" ON");
                    statement.execute(sqlBuffer.toString());
                }
                try {
                    this._operation.execute(connection, new DefaultDataSet(table));
                }
                finally {
                    if (hasIdentityColumn) {
                        sqlBuffer = new StringBuilder(128);
                        sqlBuffer.append("SET IDENTITY_INSERT ");
                        sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
                        sqlBuffer.append(" OFF");
                        statement.execute(sqlBuffer.toString());
                    }
                    if (!wasAutoCommit) continue;
                    jdbcConnection.commit();
                }
            }
        }
        finally {
            if (wasAutoCommit) {
                jdbcConnection.setAutoCommit(true);
            }
            statement.close();
        }
    }
}

