/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.sql.BLOB;
import org.dbunit.dataset.datatype.BlobDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleBlobDataType
extends BlobDataType {
    private static final Logger logger = LoggerFactory.getLogger(OracleBlobDataType.class);

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)column, (Object)resultSet);
        return this.typeCast(resultSet.getBlob(column));
    }

    @Override
    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, column, statement});
        statement.setObject(column, this.getBlob(value, statement.getConnection()));
    }

    private Object getBlob(Object value, Connection connection) throws TypeCastException {
        logger.debug("getBlob(value={}, connection={}) - start", value, (Object)connection);
        BLOB tempBlob = null;
        try {
            tempBlob = oracle.sql.BLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
            tempBlob.open(1);
            OutputStream tempBlobOutputStream = tempBlob.getBinaryOutputStream();
            tempBlobOutputStream.write((byte[])this.typeCast(value));
            tempBlobOutputStream.flush();
            tempBlobOutputStream.close();
            tempBlob.close();
        }
        catch (SQLException e) {
            this.freeTemporaryBlob(tempBlob);
            throw new TypeCastException(value, this, e);
        }
        catch (IOException e) {
            this.freeTemporaryBlob(tempBlob);
            throw new TypeCastException(value, this, e);
        }
        return tempBlob;
    }

    private void freeTemporaryBlob(BLOB tempBlob) throws TypeCastException {
        logger.debug("freeTemporaryBlob(tempBlob={}) - start", (Object)tempBlob);
        if (tempBlob == null) {
            return;
        }
        try {
            tempBlob.freeTemporary();
        }
        catch (SQLException e) {
            throw new TypeCastException("Error freeing Oracle BLOB", e);
        }
    }
}

