/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.topology.CacheTopology;

@ProtoTypeId(value=1158)
public class RebalanceStartCommand
extends AbstractCacheControlCommand {
    @ProtoField(value=1)
    final String cacheName;
    @ProtoField(value=2)
    final WrappedMessage currentCH;
    @ProtoField(value=3)
    final WrappedMessage pendingCH;
    @ProtoField(value=4)
    final CacheTopology.Phase phase;
    @ProtoField(value=5)
    final List<UUID> persistentUUIDs;
    @ProtoField(value=6)
    final int rebalanceId;
    @ProtoField(value=7)
    final int topologyId;
    @ProtoField(value=8)
    final int viewId;
    private final List<Address> actualMembers;

    @ProtoFactory
    RebalanceStartCommand(String cacheName, WrappedMessage currentCH, WrappedMessage pendingCH, CacheTopology.Phase phase, List<UUID> persistentUUIDs, int rebalanceId, int topologyId, int viewId, List<Address> actualMembers) {
        this.cacheName = cacheName;
        this.currentCH = currentCH;
        this.pendingCH = pendingCH;
        this.phase = phase;
        this.persistentUUIDs = persistentUUIDs;
        this.rebalanceId = rebalanceId;
        this.topologyId = topologyId;
        this.viewId = viewId;
        this.actualMembers = actualMembers;
    }

    public RebalanceStartCommand(String cacheName, Address origin, CacheTopology cacheTopology, int viewId) {
        super(origin);
        this.cacheName = cacheName;
        this.topologyId = cacheTopology.getTopologyId();
        this.rebalanceId = cacheTopology.getRebalanceId();
        this.currentCH = new WrappedMessage((Object)cacheTopology.getCurrentCH());
        this.pendingCH = new WrappedMessage((Object)cacheTopology.getPendingCH());
        this.phase = cacheTopology.getPhase();
        this.actualMembers = cacheTopology.getActualMembers();
        this.persistentUUIDs = cacheTopology.getMembersPersistentUUIDs();
        this.viewId = viewId;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        CacheTopology topology = new CacheTopology(this.topologyId, this.rebalanceId, this.getCurrentCH(), this.getPendingCH(), this.phase, this.actualMembers, this.persistentUUIDs);
        return gcr.getLocalTopologyManager().handleRebalance(this.cacheName, topology, this.viewId, this.origin);
    }

    @ProtoField(value=9)
    List<Address> getActualMembers() {
        return this.actualMembers;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public ConsistentHash getCurrentCH() {
        return (ConsistentHash)this.currentCH.getValue();
    }

    public ConsistentHash getPendingCH() {
        return (ConsistentHash)this.pendingCH.getValue();
    }

    public CacheTopology.Phase getPhase() {
        return this.phase;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    public String toString() {
        return "RebalanceStartCommand{cacheName='" + this.cacheName + "', origin=" + String.valueOf(this.origin) + ", currentCH=" + String.valueOf(this.getCurrentCH()) + ", pendingCH=" + String.valueOf(this.getPendingCH()) + ", phase=" + String.valueOf((Object)this.phase) + ", actualMembers=" + String.valueOf(this.actualMembers) + ", persistentUUIDs=" + String.valueOf(this.persistentUUIDs) + ", rebalanceId=" + this.rebalanceId + ", topologyId=" + this.topologyId + ", viewId=" + this.viewId + "}";
    }
}

