/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.triangle;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.triangle.FunctionalBackupWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.encoding.DataConversion;
import org.infinispan.functional.impl.Params;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.annotations.Proto;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1171)
public class SingleKeyFunctionalBackupWriteCommand
extends FunctionalBackupWriteCommand {
    private Operation operation;
    private Object key;
    private Object value;
    private Object prevValue;
    private Metadata prevMetadata;

    private SingleKeyFunctionalBackupWriteCommand(ByteString cacheName, AbstractWriteKeyCommand<?, ?> command, long sequence, int segmentId, Operation operation, Object key, Object value, Object prevValue, Metadata prevMetadata, Object function) {
        super(cacheName, command, sequence, segmentId, function);
        this.operation = operation;
        this.key = key;
        this.value = value;
        this.prevValue = prevValue;
        this.prevMetadata = prevMetadata;
    }

    @ProtoFactory
    SingleKeyFunctionalBackupWriteCommand(ByteString cacheName, CommandInvocationId commandInvocationId, int topologyId, long flags, long sequence, int segmentId, MarshallableObject<?> function, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion, Operation operation, MarshallableObject<?> key, MarshallableObject<?> value, MarshallableObject<?> prevValue, MarshallableObject<Metadata> prevMetadata) {
        super(cacheName, commandInvocationId, topologyId, flags, sequence, segmentId, function, params, keyDataConversion, valueDataConversion);
        this.operation = operation;
        this.key = MarshallableObject.unwrap(key);
        this.value = MarshallableObject.unwrap(value);
        this.prevValue = MarshallableObject.unwrap(prevValue);
        this.prevMetadata = MarshallableObject.unwrap(prevMetadata);
    }

    public static SingleKeyFunctionalBackupWriteCommand create(ByteString cacheName, ReadWriteKeyCommand<?, ?, ?> command, long sequence, int segmentId) {
        return new SingleKeyFunctionalBackupWriteCommand(cacheName, command, sequence, segmentId, Operation.READ_WRITE, command.getKey(), null, null, null, command.getFunction());
    }

    public static SingleKeyFunctionalBackupWriteCommand create(ByteString cacheName, ReadWriteKeyValueCommand<?, ?, ?, ?> command, long sequence, int segmentId) {
        return new SingleKeyFunctionalBackupWriteCommand(cacheName, command, sequence, segmentId, Operation.READ_WRITE_KEY_VALUE, command.getKey(), command.getArgument(), command.getPrevValue(), command.getPrevMetadata(), command.getBiFunction());
    }

    public static SingleKeyFunctionalBackupWriteCommand create(ByteString cacheName, WriteOnlyKeyValueCommand<?, ?, ?> command, long sequence, int segmentId) {
        return new SingleKeyFunctionalBackupWriteCommand(cacheName, command, sequence, segmentId, Operation.WRITE_ONLY_KEY_VALUE, command.getKey(), command.getArgument(), null, null, command.getBiConsumer());
    }

    public static SingleKeyFunctionalBackupWriteCommand create(ByteString cacheName, WriteOnlyKeyCommand<?, ?> command, long sequence, int segmentId) {
        return new SingleKeyFunctionalBackupWriteCommand(cacheName, command, sequence, segmentId, Operation.WRITE_ONLY, command.getKey(), null, null, null, command.getConsumer());
    }

    @ProtoField(value=11)
    Operation getOperation() {
        return this.operation;
    }

    @ProtoField(value=12)
    MarshallableObject<?> getKey() {
        return MarshallableObject.create(this.key);
    }

    @ProtoField(value=13)
    MarshallableObject<?> getValue() {
        return MarshallableObject.create(this.value);
    }

    @ProtoField(value=14)
    MarshallableObject<?> getPrevValue() {
        return MarshallableObject.create(this.prevValue);
    }

    @ProtoField(value=15)
    MarshallableObject<Metadata> getPrevMetadata() {
        return MarshallableObject.create(this.prevMetadata);
    }

    @Override
    WriteCommand createWriteCommand() {
        switch (this.operation.ordinal()) {
            case 1: {
                return new ReadWriteKeyCommand(this.cacheName, this.key, (Function)this.function, this.segmentId, this.getCommandInvocationId(), ValueMatcher.MATCH_ALWAYS, this.params, this.keyDataConversion, this.valueDataConversion);
            }
            case 0: {
                ReadWriteKeyValueCommand cmd = new ReadWriteKeyValueCommand(this.cacheName, this.key, this.value, (BiFunction)this.function, this.segmentId, this.getCommandInvocationId(), ValueMatcher.MATCH_ALWAYS, this.params, this.keyDataConversion, this.valueDataConversion);
                cmd.setPrevValueAndMetadata(this.prevValue, this.prevMetadata);
                return cmd;
            }
            case 3: {
                return new WriteOnlyKeyCommand(this.cacheName, this.key, (Consumer)this.function, this.segmentId, this.getCommandInvocationId(), ValueMatcher.MATCH_ALWAYS, this.params, this.keyDataConversion, this.valueDataConversion);
            }
            case 2: {
                return new WriteOnlyKeyValueCommand(this.cacheName, this.key, this.value, (BiConsumer)this.function, this.segmentId, this.getCommandInvocationId(), ValueMatcher.MATCH_ALWAYS, this.params, this.keyDataConversion, this.valueDataConversion);
            }
        }
        throw new IllegalStateException("Unknown operation " + String.valueOf((Object)this.operation));
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Proto
    @ProtoName(value="SingleKeyFunctionBackupOperation")
    @ProtoTypeId(value=1172)
    public static enum Operation {
        READ_WRITE_KEY_VALUE,
        READ_WRITE,
        WRITE_ONLY_KEY_VALUE,
        WRITE_ONLY;

    }
}

