/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Objects;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=29)
public class RemoveExpiredCommand
extends RemoveCommand {
    @ProtoField(value=12)
    boolean maxIdle;
    @ProtoField(value=13)
    Long lifespan;

    @ProtoFactory
    RemoveExpiredCommand(ByteString cacheName, MarshallableObject<?> wrappedKey, int segment, int topologyId, long flagsWithoutRemote, CommandInvocationId commandInvocationId, MarshallableObject<?> wrappedValue, MarshallableObject<Metadata> wrappedMetadata, ValueMatcher valueMatcher, PrivateMetadata internalMetadata, boolean returnEntryNecessary, boolean maxIdle, Long lifespan) {
        super(cacheName, wrappedKey, flagsWithoutRemote, topologyId, segment, commandInvocationId, wrappedValue, null, valueMatcher, internalMetadata, returnEntryNecessary);
        this.maxIdle = maxIdle;
        this.lifespan = lifespan;
    }

    public RemoveExpiredCommand(ByteString cacheName, Object key, Object value, Long lifespan, boolean maxIdle, int segment, long flagBitSet, CommandInvocationId commandInvocationId) {
        super(cacheName, key, value, false, segment, flagBitSet, commandInvocationId);
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
        this.valueMatcher = ValueMatcher.MATCH_EXPECTED_OR_NULL;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitRemoveExpiredCommand(ctx, this);
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public boolean shouldReplicate(InvocationContext ctx, boolean requireReplicateIfRemote) {
        return this.isSuccessful();
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Override
    public String toString() {
        return "RemoveExpiredCommand{key=" + Util.toStr((Object)this.key) + ", value=" + Util.toStr((Object)this.value) + ", lifespan=" + this.lifespan + ", maxIdle=" + this.maxIdle + ", internalMetadata=" + String.valueOf(this.getInternalMetadata()) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoveExpiredCommand that = (RemoveExpiredCommand)o;
        return this.maxIdle == that.maxIdle && Objects.equals(this.lifespan, that.lifespan);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lifespan, this.maxIdle);
    }

    public boolean isMaxIdle() {
        return this.maxIdle;
    }

    public Long getLifespan() {
        return this.lifespan;
    }

    @Override
    public boolean logThrowable(Throwable t) {
        Throwable cause = t;
        do {
            if (!(cause instanceof TimeoutException)) continue;
            return !this.hasAnyFlag(FlagBitSets.ZERO_LOCK_ACQUISITION_TIMEOUT);
        } while ((cause = cause.getCause()) != null);
        return true;
    }
}

