/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Objects;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=30)
public class ReplaceCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    private Object oldValue;
    private Object newValue;
    private Metadata metadata;
    private ValueMatcher valueMatcher;
    private boolean returnEntry;
    private PrivateMetadata internalMetadata;
    private transient boolean successful = true;

    public ReplaceCommand(ByteString cacheName, Object key, Object oldValue, Object newValue, boolean returnEntry, Metadata metadata, int segment, long flagsBitSet, CommandInvocationId commandInvocationId) {
        super(cacheName, key, segment, flagsBitSet, commandInvocationId);
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.returnEntry = returnEntry;
        this.metadata = metadata;
        this.valueMatcher = oldValue != null ? ValueMatcher.MATCH_EXPECTED : ValueMatcher.MATCH_NON_NULL;
    }

    @ProtoFactory
    ReplaceCommand(ByteString cacheName, MarshallableObject<?> wrappedKey, long flagsWithoutRemote, int topologyId, int segment, CommandInvocationId commandInvocationId, MarshallableObject<?> wrappedOldValue, MarshallableObject<?> wrappedNewValue, MarshallableObject<Metadata> wrappedMetadata, ValueMatcher valueMatcher, PrivateMetadata internalMetadata, boolean returnEntry) {
        super(cacheName, wrappedKey, flagsWithoutRemote, topologyId, segment, commandInvocationId);
        this.oldValue = MarshallableObject.unwrap(wrappedOldValue);
        this.newValue = MarshallableObject.unwrap(wrappedNewValue);
        this.metadata = MarshallableObject.unwrap(wrappedMetadata);
        this.valueMatcher = valueMatcher;
        this.internalMetadata = internalMetadata;
        this.returnEntry = returnEntry;
    }

    @ProtoField(number=7, name="oldValue")
    MarshallableObject<?> getWrappedOldValue() {
        return MarshallableObject.create(this.oldValue);
    }

    @ProtoField(number=8, name="newValue")
    MarshallableObject<?> getWrappedNewValue() {
        return MarshallableObject.create(this.newValue);
    }

    @ProtoField(number=9, name="metadata")
    MarshallableObject<Metadata> getWrappedMetadata() {
        return MarshallableObject.create(this.metadata);
    }

    @Override
    @ProtoField(value=10)
    public ValueMatcher getValueMatcher() {
        return this.valueMatcher;
    }

    @Override
    @ProtoField(value=11)
    public PrivateMetadata getInternalMetadata() {
        return this.internalMetadata;
    }

    @Override
    public void setInternalMetadata(PrivateMetadata internalMetadata) {
        this.internalMetadata = internalMetadata;
    }

    @ProtoField(value=12)
    public final boolean isReturnEntry() {
        return this.returnEntry;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReplaceCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.PRIMARY;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplaceCommand that = (ReplaceCommand)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.newValue, that.newValue) && Objects.equals(this.oldValue, that.oldValue);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
        result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
        this.valueMatcher = valueMatcher;
    }

    @Override
    public void fail() {
        this.successful = false;
    }

    @Override
    public final boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Override
    public String toString() {
        return "ReplaceCommand{key=" + Util.toStr((Object)this.key) + ", oldValue=" + Util.toStr((Object)this.oldValue) + ", newValue=" + Util.toStr((Object)this.newValue) + ", metadata=" + String.valueOf(this.metadata) + ", flags=" + this.printFlags() + ", commandInvocationId=" + CommandInvocationId.show(this.commandInvocationId) + ", successful=" + this.successful + ", valueMatcher=" + String.valueOf((Object)this.valueMatcher) + ", topologyId=" + this.topologyId + "}";
    }
}

