/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.util.ByteQuantity;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.util.logging.Log;

public class MemoryConfiguration
extends ConfigurationElement<MemoryConfiguration> {
    public static final AttributeDefinition<StorageType> STORAGE = AttributeDefinition.builder((Enum)Attribute.STORAGE, (Object)((Object)StorageType.HEAP)).immutable().build();
    public static final AttributeDefinition<String> MAX_SIZE = AttributeDefinition.builder((Enum)Attribute.MAX_SIZE, null, String.class).matcher((a1, a2) -> MemoryConfiguration.maxSizeToBytes((String)a1.get()) == MemoryConfiguration.maxSizeToBytes((String)a2.get())).build();
    public static final AttributeDefinition<Long> MAX_COUNT = AttributeDefinition.builder((Enum)Attribute.MAX_COUNT, (Object)-1L).build();
    public static final AttributeDefinition<EvictionStrategy> WHEN_FULL = AttributeDefinition.builder((Enum)Attribute.WHEN_FULL, (Object)((Object)EvictionStrategy.NONE)).immutable().build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(MemoryConfiguration.class, new AttributeDefinition[]{STORAGE, MAX_SIZE, MAX_COUNT, WHEN_FULL});
    }

    MemoryConfiguration(AttributeSet attributes) {
        super((Enum)Element.MEMORY, attributes, new ConfigurationElement[0]);
    }

    public boolean isOffHeap() {
        return this.attributes.attribute(STORAGE).get() == StorageType.OFF_HEAP;
    }

    public long maxSizeBytes() {
        return MemoryConfiguration.maxSizeToBytes(this.maxSize());
    }

    public String maxSize() {
        return (String)this.attributes.attribute(MAX_SIZE).get();
    }

    public void maxSize(String maxSize) {
        if (!this.isSizeBounded()) {
            throw Log.CONFIG.cannotChangeMaxSize();
        }
        this.attributes.attribute(MAX_SIZE).set((Object)maxSize);
    }

    public void maxSize(long maxSize) {
        this.maxSize(Long.toString(maxSize));
    }

    public long maxCount() {
        return (Long)this.attributes.attribute(MAX_COUNT).get();
    }

    public void maxCount(long maxCount) {
        if (!this.isCountBounded()) {
            throw Log.CONFIG.cannotChangeMaxCount();
        }
        this.attributes.attribute(MAX_COUNT).set((Object)maxCount);
    }

    public StorageType storage() {
        return (StorageType)((Object)this.attributes.attribute(STORAGE).get());
    }

    public EvictionStrategy whenFull() {
        return (EvictionStrategy)((Object)this.attributes.attribute(WHEN_FULL).get());
    }

    public boolean isEvictionEnabled() {
        return (this.isSizeBounded() || this.isCountBounded()) && this.whenFull().isRemovalBased();
    }

    private boolean isSizeBounded() {
        return this.maxSize() != null;
    }

    private boolean isCountBounded() {
        return this.maxCount() > 0L;
    }

    static long maxSizeToBytes(String maxSizeStr) {
        return maxSizeStr != null ? ByteQuantity.parse((String)maxSizeStr) : -1L;
    }
}

