/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Function;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.reactive.RxJavaInterop;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.LocalPublisherManager;
import org.infinispan.reactive.publisher.impl.Notifications;
import org.infinispan.reactive.publisher.impl.SegmentAwarePublisherSupplier;
import org.infinispan.reactive.publisher.impl.commands.batch.InitialPublisherCommand;
import org.infinispan.reactive.publisher.impl.commands.batch.KeyPublisherResponse;
import org.infinispan.reactive.publisher.impl.commands.batch.PublisherResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

@Listener(observation=Listener.Observation.POST)
@Scope(value=Scopes.NAMED_CACHE)
public class PublisherHandler {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final ConcurrentMap<Object, PublisherState> currentRequests = new ConcurrentHashMap<Object, PublisherState>();
    @Inject
    CacheManagerNotifier managerNotifier;
    @Inject
    @ComponentName(value="org.infinispan.executors.non-blocking")
    ExecutorService nonBlockingExecutor;
    @Inject
    LocalPublisherManager localPublisherManager;

    @ViewChanged
    public void viewChange(ViewChangedEvent event) {
        List<Address> newMembers = event.getNewMembers();
        Iterator iter = this.currentRequests.values().iterator();
        while (iter.hasNext()) {
            PublisherState state = (PublisherState)iter.next();
            Address owner = state.getOrigin();
            if (owner == null || newMembers.contains(owner)) continue;
            log.tracef("View changed and no longer contains %s, closing %s publisher", owner, state.requestId);
            state.cancel();
            iter.remove();
        }
    }

    @Start
    public void start() {
        this.managerNotifier.addListener(this);
    }

    @Stop
    public void stop() {
        this.managerNotifier.removeListener(this);
    }

    public <I, R> CompletableFuture<PublisherResponse> register(InitialPublisherCommand<?, I, R> command) {
        PublisherState publisherState;
        String requestId = command.getRequestId();
        PublisherState previousState = this.currentRequests.put(requestId, publisherState = command.isTrackKeys() ? new KeyPublisherState(requestId, command.getOrigin(), command.getBatchSize()) : new PublisherState(requestId, command.getOrigin(), command.getBatchSize()));
        if (previousState != null) {
            if (!previousState.complete) {
                this.currentRequests.remove(requestId);
                throw new IllegalStateException("There was already a publisher registered for id " + requestId + " that wasn't complete!");
            }
            if (log.isTraceEnabled()) {
                log.tracef("Closing prior state for %s to make room for a new request", requestId);
            }
            previousState.cancel();
        }
        publisherState.startProcessing(command);
        return publisherState.results();
    }

    public CompletableFuture<PublisherResponse> getNext(String requestId) {
        PublisherState publisherState = (PublisherState)this.currentRequests.get(requestId);
        if (publisherState == null) {
            throw new IllegalStateException("Publisher for requestId " + requestId + " doesn't exist!");
        }
        return publisherState.results();
    }

    public int openPublishers() {
        return this.currentRequests.size();
    }

    public void closePublisher(String requestId) {
        PublisherState state = (PublisherState)this.currentRequests.remove(requestId);
        if (state != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Closed publisher using requestId %s", requestId);
            }
            state.cancel();
        }
    }

    private void closePublisher(String requestId, PublisherState state) {
        if (this.currentRequests.remove(requestId, state)) {
            if (log.isTraceEnabled()) {
                log.tracef("Closed publisher from completion using requestId %s", requestId);
            }
            state.cancel();
        } else if (log.isTraceEnabled()) {
            log.tracef("A concurrent request already closed the prior state for %s", requestId);
        }
    }

    private class PublisherState
    implements FlowableSubscriber<SegmentAwarePublisherSupplier.NotificationWithLost<Object>>,
    Runnable {
        final String requestId;
        final Address origin;
        final int batchSize;
        @GuardedBy(value="this")
        private CompletableFuture<PublisherResponse> futureResponse = null;
        Subscription upstream;
        Object[] results;
        List<SegmentResult> segmentResults;
        int pos;
        IntSet completedSegments;
        IntSet lostSegments;
        int currentSegment = -1;
        int segmentEntries;
        volatile boolean complete;

        private PublisherState(String requestId, Address origin, int batchSize) {
            this.requestId = requestId;
            this.origin = origin;
            this.batchSize = batchSize;
            this.results = new Object[batchSize];
        }

        void startProcessing(InitialPublisherCommand command) {
            SegmentAwarePublisherSupplier sap = command.isEntryStream() ? PublisherHandler.this.localPublisherManager.entryPublisher(command.getSegments(), command.getKeys(), command.getExcludedKeys(), command.getExplicitFlags(), command.getDeliveryGuarantee(), command.getTransformer()) : PublisherHandler.this.localPublisherManager.keyPublisher(command.getSegments(), command.getKeys(), command.getExcludedKeys(), command.getExplicitFlags(), command.getDeliveryGuarantee(), command.getTransformer());
            Flowable.fromPublisher(sap.publisherWithLostSegments(true)).subscribe((FlowableSubscriber)this);
        }

        public void onSubscribe(Subscription s) {
            if (this.upstream != null) {
                throw new IllegalStateException("Subscription was already set!");
            }
            this.upstream = Objects.requireNonNull(s);
            this.requestMore(s, this.batchSize);
        }

        protected void requestMore(Subscription subscription, int requestAmount) {
            subscription.request((long)requestAmount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            this.complete = true;
            log.trace("Exception encountered while processing publisher", t);
            PublisherState publisherState = this;
            synchronized (publisherState) {
                if (this.futureResponse == null) {
                    this.futureResponse = CompletableFuture.failedFuture(t);
                } else {
                    this.futureResponse.completeExceptionally(t);
                }
            }
        }

        public void onComplete() {
            this.prepareResponse(true);
            if (log.isTraceEnabled()) {
                log.tracef("Completed state for %s", this.requestId);
            }
        }

        public void onNext(SegmentAwarePublisherSupplier.NotificationWithLost notification) {
            if (!notification.isValue()) {
                if (notification.isSegmentComplete()) {
                    int segment = notification.completedSegment();
                    if (this.segmentEntries > 0) {
                        this.addToSegmentResults(segment, this.segmentEntries);
                    }
                    this.segmentComplete(segment);
                } else {
                    int segment = notification.lostSegment();
                    this.segmentLost(segment);
                }
                this.requestMore(this.upstream, 1);
                return;
            }
            int segment = notification.valueSegment();
            assert (this.currentSegment == segment || this.currentSegment == -1);
            this.currentSegment = segment;
            ++this.segmentEntries;
            this.results[this.pos++] = notification.value();
            if (this.pos == this.results.length) {
                this.prepareResponse(false);
            }
        }

        public void segmentComplete(int segment) {
            assert (this.currentSegment == segment || this.currentSegment == -1);
            if (log.isTraceEnabled()) {
                log.tracef("Completing segment %s for %s", segment, this.requestId);
            }
            if (this.completedSegments == null) {
                this.completedSegments = IntSets.mutableEmptySet();
            }
            this.completedSegments.set(segment);
            this.segmentEntries = 0;
            this.currentSegment = -1;
        }

        public void segmentLost(int segment) {
            assert (this.currentSegment == segment || this.currentSegment == -1);
            if (log.isTraceEnabled()) {
                log.tracef("Lost segment %s for %s", segment, this.requestId);
            }
            if (this.lostSegments == null) {
                this.lostSegments = IntSets.mutableEmptySet();
            }
            this.lostSegments.set(segment);
            this.pos -= this.segmentEntries;
            this.segmentEntries = 0;
            this.currentSegment = -1;
        }

        public void cancel() {
            Subscription subscription = this.upstream;
            if (subscription != null) {
                subscription.cancel();
            }
        }

        void resetValues() {
            this.results = new Object[this.batchSize];
            this.segmentResults = null;
            this.completedSegments = null;
            this.lostSegments = null;
            this.pos = 0;
            this.currentSegment = -1;
            this.segmentEntries = 0;
        }

        PublisherResponse generateResponse(boolean complete) {
            return new PublisherResponse(this.results, this.completedSegments, this.lostSegments, this.pos, complete, this.segmentResults == null ? Collections.emptyList() : this.segmentResults);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void prepareResponse(boolean complete) {
            if (this.currentSegment != -1) {
                this.addToSegmentResults(this.currentSegment, this.segmentEntries);
            }
            PublisherResponse response = this.generateResponse(complete);
            if (log.isTraceEnabled()) {
                log.tracef("Response ready %s with id %s for requestor %s", response, this.requestId, this.origin);
            }
            if (!complete) {
                this.resetValues();
            }
            this.complete = complete;
            CompletableFuture<PublisherResponse> futureToComplete = null;
            PublisherState publisherState = this;
            synchronized (publisherState) {
                if (this.futureResponse != null) {
                    if (this.futureResponse.isDone()) {
                        if (!this.futureResponse.isCompletedExceptionally()) {
                            throw new IllegalStateException("Response already completed with " + String.valueOf(CompletionStages.join(this.futureResponse)) + " but we want to complete with " + String.valueOf(response));
                        }
                        log.tracef("Response %s already completed with an exception, ignoring values", System.identityHashCode(this.futureResponse));
                    }
                    futureToComplete = this.futureResponse;
                    this.futureResponse = null;
                } else {
                    this.futureResponse = CompletableFuture.completedFuture(response);
                    if (log.isTraceEnabled()) {
                        log.tracef("Eager response completed %d for request id %s", System.identityHashCode(this.futureResponse), this.requestId);
                    }
                }
            }
            if (futureToComplete != null) {
                if (log.isTraceEnabled()) {
                    log.tracef("Completing waiting future %d for request id %s", System.identityHashCode(futureToComplete), this.requestId);
                }
                futureToComplete.complete(response);
            }
        }

        public Address getOrigin() {
            return this.origin;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CompletableFuture<PublisherResponse> results() {
            CompletableFuture<PublisherResponse> currentFuture;
            boolean submitRequest = false;
            PublisherState publisherState = this;
            synchronized (publisherState) {
                if (this.futureResponse == null) {
                    currentFuture = new CompletableFuture();
                    currentFuture.thenRunAsync(this, PublisherHandler.this.nonBlockingExecutor);
                    this.futureResponse = currentFuture;
                } else {
                    currentFuture = this.futureResponse;
                    this.futureResponse = null;
                    submitRequest = true;
                }
            }
            if (submitRequest) {
                PublisherHandler.this.nonBlockingExecutor.execute(this);
            }
            if (log.isTraceEnabled()) {
                log.tracef("Retrieved future %d for request id %s", System.identityHashCode(currentFuture), this.requestId);
            }
            return currentFuture;
        }

        void addToSegmentResults(int segment, int entryCount) {
            if (this.segmentResults == null) {
                this.segmentResults = new ArrayList<SegmentResult>();
            }
            this.segmentResults.add(new SegmentResult(segment, entryCount));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (log.isTraceEnabled()) {
                log.tracef("Running handler for request id %s", this.requestId);
            }
            if (!this.complete) {
                int requestAmount = this.batchSize;
                if (log.isTraceEnabled()) {
                    log.tracef("Requesting %d additional entries for %s", requestAmount, this.requestId);
                }
                this.requestMore(this.upstream, requestAmount);
            } else {
                PublisherState publisherState = this;
                synchronized (publisherState) {
                    if (this.futureResponse == null) {
                        PublisherHandler.this.closePublisher(this.requestId, this);
                    } else if (log.isTraceEnabled()) {
                        log.tracef("Skipping run as handler is complete, but still has some results for id %s", this.requestId);
                    }
                }
            }
        }
    }

    class KeyPublisherState
    extends PublisherState {
        Object[] extraValues;
        int extraPos;
        Object[] keys;
        int keyPos;
        int keyStartPosition;

        private KeyPublisherState(String requestId, Address origin, int batchSize) {
            super(requestId, origin, batchSize);
        }

        @Override
        void startProcessing(InitialPublisherCommand command) {
            Function toKeyFunction;
            SegmentAwarePublisherSupplier sap;
            if (command.isEntryStream()) {
                sap = PublisherHandler.this.localPublisherManager.entryPublisher(command.getSegments(), command.getKeys(), command.getExcludedKeys(), command.getExplicitFlags(), DeliveryGuarantee.EXACTLY_ONCE, java.util.function.Function.identity());
                toKeyFunction = RxJavaInterop.entryToKeyFunction();
            } else {
                sap = PublisherHandler.this.localPublisherManager.keyPublisher(command.getSegments(), command.getKeys(), command.getExcludedKeys(), command.getExplicitFlags(), DeliveryGuarantee.EXACTLY_ONCE, java.util.function.Function.identity());
                toKeyFunction = RxJavaInterop.identityFunction();
            }
            java.util.function.Function functionToApply = command.getTransformer();
            Notifications.NotificationBuilder builder = Notifications.reuseBuilder();
            KeyCompleted keyBuilder = new KeyCompleted();
            Flowable.fromPublisher(sap.publisherWithLostSegments()).concatMap(notification -> {
                if (!notification.isValue()) {
                    return Flowable.just((Object)notification);
                }
                Object originalValue = notification.value();
                Object key = toKeyFunction.apply(originalValue);
                return Flowable.fromPublisher((Publisher)((Publisher)functionToApply.apply(Flowable.just(originalValue)))).map(v -> builder.value(v, notification.valueSegment())).concatWith((SingleSource)Single.just(keyBuilder.value(key, notification.valueSegment())));
            }).subscribe((FlowableSubscriber)this);
        }

        @Override
        PublisherResponse generateResponse(boolean complete) {
            return new KeyPublisherResponse(this.results, this.completedSegments, this.lostSegments, this.pos, complete, this.segmentResults == null ? Collections.emptyList() : this.segmentResults, this.extraValues, this.extraPos, this.keys, this.keyPos);
        }

        @Override
        public void onNext(SegmentAwarePublisherSupplier.NotificationWithLost notification) {
            if (!notification.isValue()) {
                super.onNext(notification);
                return;
            }
            boolean requestMore = true;
            if (notification instanceof KeyCompleted) {
                if (this.keyStartPosition != this.pos) {
                    Object key = notification.value();
                    if (this.keys == null) {
                        this.keys = new Object[this.batchSize];
                    }
                    this.keys[this.keyPos++] = key;
                    if (this.pos == this.results.length) {
                        this.prepareResponse(false);
                        requestMore = false;
                    } else {
                        this.keyStartPosition = this.pos;
                    }
                }
                if (requestMore) {
                    this.requestMore(this.upstream, 1);
                }
                return;
            }
            int segment = notification.valueSegment();
            assert (this.currentSegment == segment || this.currentSegment == -1);
            this.currentSegment = segment;
            ++this.segmentEntries;
            Object value = notification.value();
            if (this.pos == this.results.length) {
                if (this.extraValues == null) {
                    this.extraValues = new Object[8];
                }
                if (this.extraPos == this.extraValues.length) {
                    Object[] expandedArray = new Object[this.extraValues.length << 1];
                    System.arraycopy(this.extraValues, 0, expandedArray, 0, this.extraPos);
                    this.extraValues = expandedArray;
                }
                this.extraValues[this.extraPos++] = value;
                this.requestMore(this.upstream, 1);
            } else {
                this.results[this.pos++] = value;
                if (this.pos == this.results.length) {
                    this.requestMore(this.upstream, 1);
                }
            }
        }

        @Override
        void resetValues() {
            super.resetValues();
            this.keyResetValues();
        }

        void keyResetValues() {
            this.extraValues = null;
            this.extraPos = 0;
            this.keys = null;
            this.keyPos = 0;
            this.keyStartPosition = 0;
        }

        @Override
        public void segmentComplete(int segment) {
            super.segmentComplete(segment);
            this.keys = null;
            this.keyPos = 0;
            this.keyStartPosition = 0;
        }

        @Override
        public void segmentLost(int segment) {
            super.segmentLost(segment);
            this.keyResetValues();
        }

        class KeyCompleted<E>
        extends Notifications.ReuseNotificationBuilder<E> {
            KeyCompleted() {
            }

            @Override
            public String toString() {
                return "KeyCompleted{key=" + String.valueOf(this.value) + ", segment=" + this.segment + "}";
            }
        }
    }

    @ProtoTypeId(value=1145)
    public static class SegmentResult {
        @ProtoField(value=1)
        final int segment;
        @ProtoField(value=2)
        final int entryCount;

        @ProtoFactory
        public SegmentResult(int segment, int entryCount) {
            this.segment = segment;
            this.entryCount = entryCount;
        }

        public int getEntryCount() {
            return this.entryCount;
        }

        public int getSegment() {
            return this.segment;
        }

        public String toString() {
            return "SegmentResult{segment=" + this.segment + ", entryCount=" + this.entryCount + "}";
        }
    }
}

