/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.util.ByteString;

public final class XSiteNamedCache {
    private static final Map<String, ByteString> CACHE = new ConcurrentHashMap<String, ByteString>(4);

    private XSiteNamedCache() {
    }

    public static ByteString cachedByteString(String siteName) {
        return CACHE.computeIfAbsent(siteName, ByteString::fromString);
    }

    public static String cachedString(String siteName) {
        return XSiteNamedCache.cachedByteString(siteName).toString();
    }

    public static ByteString cachedByteString(ByteString siteName) {
        ByteString old = CACHE.putIfAbsent(siteName.toString(), siteName);
        return old == null ? siteName : old;
    }
}

