/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1261)
public class XSiteSetStateTransferModeCommand
extends BaseRpcCommand {
    @ProtoField(value=2)
    final String site;
    @ProtoField(value=3)
    final XSiteStateTransferMode mode;

    @ProtoFactory
    public XSiteSetStateTransferModeCommand(ByteString cacheName, String site, XSiteStateTransferMode mode) {
        super(cacheName);
        this.site = site;
        this.mode = mode;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    public CompletionStage<Void> invokeAsync(ComponentRegistry registry) throws Throwable {
        registry.getXSiteStateTransferManager().running().setAutomaticStateTransfer(this.site, this.mode);
        return CompletableFutures.completedNull();
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }
}

