/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.json;

import java.util.List;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.impl.json.BaseJsonWriter;
import org.infinispan.protostream.impl.json.FieldAwareTagHandler;
import org.infinispan.protostream.impl.json.JsonToken;
import org.infinispan.protostream.impl.json.JsonTokenWriter;

class ObjectJsonWriter
extends BaseJsonWriter {
    private FieldAwareTagHandler delegate = null;
    private final boolean complexObject;

    ObjectJsonWriter(ImmutableSerializationContext ctx, List<JsonTokenWriter> ast, FieldDescriptor descriptor) {
        super(ctx, ast, descriptor);
        this.complexObject = BaseJsonWriter.isComplexType(descriptor);
    }

    @Override
    public void onStartNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor == null) {
            return;
        }
        if (fieldDescriptor != this.descriptor) {
            this.delegate = this.createDelegate(fieldNumber, fieldDescriptor);
            this.delegate.onStartNested(fieldNumber, fieldDescriptor);
            return;
        }
        if (JsonToken.followedByComma(this.lastToken())) {
            this.pushToken(JsonToken.COMMA);
            this.pushToken(JsonTokenWriter.string(fieldDescriptor.getName()));
            this.pushToken(JsonToken.COLON);
        }
        this.pushToken(JsonToken.LEFT_BRACE);
        if (this.complexObject) {
            this.writeType(fieldDescriptor);
        }
    }

    @Override
    public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
        if (this.delegate != null && !this.delegate.isDone()) {
            this.delegate.onTag(fieldNumber, fieldDescriptor, tagValue);
            return;
        }
        super.onTag(fieldNumber, fieldDescriptor, tagValue);
    }

    @Override
    public void onEnd() {
        if (this.delegate != null && !this.delegate.isDone()) {
            this.delegate.onEnd();
            return;
        }
        super.onEnd();
    }

    @Override
    public void onEndNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        if (this.delegate != null && !this.delegate.isDone()) {
            this.delegate.onEndNested(fieldNumber, fieldDescriptor);
            return;
        }
        this.onEnd();
    }

    @Override
    protected boolean isRoot() {
        return false;
    }

    final boolean isComplexObject() {
        return this.complexObject;
    }

    private FieldAwareTagHandler createDelegate(int fieldNumber, FieldDescriptor fd) {
        if (this.delegate == null) {
            if (!fd.isRepeated()) {
                return this.objectWriter(fieldNumber, fd);
            }
            if (fd.isMap()) {
                return this.mapWriter(fieldNumber, fd);
            }
            return this.repeatedWriter(fieldNumber, fd);
        }
        if (this.delegate.field() == fieldNumber) {
            return this.delegate;
        }
        if (!this.delegate.isDone()) {
            return this.delegate;
        }
        this.delegate.onEndNested(fieldNumber, fd);
        this.delegate = null;
        return this.createDelegate(fieldNumber, fd);
    }
}

