/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.schema;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.protostream.schema.Enum;
import org.infinispan.protostream.schema.EnumValue;
import org.infinispan.protostream.schema.Field;
import org.infinispan.protostream.schema.Map;
import org.infinispan.protostream.schema.Message;
import org.infinispan.protostream.schema.OneOf;
import org.infinispan.protostream.schema.ReservedNumbers;
import org.infinispan.protostream.schema.Schema;
import org.infinispan.protostream.schema.SchemaByBuilder;
import org.infinispan.protostream.schema.SchemaByString;

class SchemaWriter {
    private final int indent;
    private int offset;

    SchemaWriter(int indent) {
        this.indent = indent;
    }

    SchemaWriter() {
        this(2);
    }

    public void write(Writer w, Schema s) throws IOException {
        if (s instanceof SchemaByBuilder) {
            SchemaByBuilder sbb = (SchemaByBuilder)s;
            this.write(w, sbb);
            return;
        }
        if (s instanceof SchemaByString) {
            SchemaByString sbs = (SchemaByString)s;
            w.write(sbs.getContent());
        }
        throw new IllegalArgumentException("Unknown schema type: " + String.valueOf(s));
    }

    private void write(Writer w, SchemaByBuilder s) throws IOException {
        w.write("syntax = \"");
        w.write(s.getSyntax().toString());
        w.write("\";\n");
        if (s.getPackageName() != null) {
            w.write("package ");
            w.write(s.getPackageName());
            w.write(";\n");
        }
        for (String d : s.getDependencies()) {
            w.write("import \"");
            w.write(d);
            w.write("\";\n");
        }
        for (String d : s.getPublicDependencies()) {
            w.write("import public \"");
            w.write(d);
            w.write("\";\n");
        }
        this.writeOptions(w, s.getOptions(), false);
        this.writeEnums(w, s.getEnums());
        this.writeMessages(w, s.getMessages());
    }

    private void writeComments(Writer w, Collection<String> comments) throws IOException {
        if (!comments.isEmpty()) {
            this.writeOffset(w);
            w.write("/*\n");
            for (String c : comments) {
                this.writeOffset(w);
                w.write(" * ");
                w.write(c);
                w.write("\n");
            }
            this.writeOffset(w);
            w.write(" */\n");
        }
    }

    private void writeOffset(Writer w) throws IOException {
        w.write(" ".repeat(this.offset));
    }

    private void writeMessages(Writer w, Collection<Message> messages) throws IOException {
        for (Message m : messages) {
            this.writeComments(w, m.getComments());
            this.writeOffset(w);
            w.write("message ");
            w.write(m.getName());
            w.write(" {\n");
            this.indent();
            this.writeOptions(w, m.getOptions(), false);
            this.writeEnums(w, m.getNestedEnums().values());
            this.writeMessages(w, m.getNestedMessages().values());
            this.writeFields(w, m.getFields());
            this.writeOneOfs(w, m.getOneOfs());
            this.writeReserved(w, m.getReservedNumbers());
            this.writeReserved(w, m.getReservedNames());
            this.outdent();
            this.writeOffset(w);
            w.write("}\n");
        }
    }

    private void writeReserved(Writer w, Set<String> reservedNames) throws IOException {
        if (!reservedNames.isEmpty()) {
            this.writeOffset(w);
            w.write("reserved ");
            w.write(reservedNames.stream().collect(Collectors.joining("\", \"", "\"", "\"")));
            w.write(";\n");
        }
    }

    private void writeReserved(Writer w, ReservedNumbers reservedNumbers) throws IOException {
        if (!reservedNumbers.isEmpty()) {
            this.writeOffset(w);
            w.write("reserved ");
            int i = reservedNumbers.nextSetBit(0);
            while (i >= 0) {
                w.write(Integer.toString(i));
                int j = reservedNumbers.nextSetBit(i + 1);
                if (j < 0) break;
                if (j == i + 1) {
                    j = reservedNumbers.nextClearBit(i + 1);
                    w.write(" to ");
                    w.write(Integer.toString(j - 1));
                    i = reservedNumbers.nextSetBit(j);
                    if (i <= 0) continue;
                    w.write(", ");
                    continue;
                }
                w.write(", ");
                i = j;
            }
            w.write(";\n");
        }
    }

    private void writeOneOfs(Writer w, List<OneOf> oneOfs) throws IOException {
        for (OneOf o : oneOfs) {
            this.writeComments(w, o.getComments());
            this.writeOffset(w);
            w.write("oneof ");
            w.write(o.getName());
            w.write(" {\n");
            this.indent();
            this.writeFields(w, o.getFields());
            this.outdent();
            this.writeOffset(w);
            w.write("}\n");
        }
    }

    private void writeFields(Writer w, java.util.Map<String, Field> fields) throws IOException {
        for (Field f : fields.values()) {
            this.writeComments(w, f.getComments());
            this.writeOffset(w);
            if (f instanceof Map) {
                Map m = (Map)f;
                w.write("map<");
                w.write(m.getType().toString());
                w.write(", ");
                w.write(m.getValueType().toString());
                w.write("> ");
            } else if (f.isRepeated()) {
                w.write("repeated ");
                w.write(f.getType().toString());
                w.write(" ");
            } else {
                w.write(f.getType().toString());
                w.write(" ");
            }
            w.write(f.getName());
            w.write(" = ");
            w.write(Integer.toString(f.getNumber()));
            w.write(";\n");
        }
    }

    private void writeEnums(Writer w, Collection<Enum> enums) throws IOException {
        for (Enum e : enums) {
            this.writeComments(w, e.getComments());
            this.writeOffset(w);
            w.write("enum ");
            w.write(e.getName());
            w.write(" {\n");
            this.indent();
            this.writeOptions(w, e.getOptions(), false);
            for (EnumValue v : e.getValues().values()) {
                this.writeComments(w, v.getComments());
                this.writeOffset(w);
                w.write(v.getName());
                w.write(" = ");
                w.write(Integer.toString(v.getNumber()));
                this.writeOptions(w, v.getOptions(), true);
                w.write(";\n");
            }
            this.writeReserved(w, e.getReservedNumbers());
            this.writeReserved(w, e.getReservedNames());
            this.outdent();
            w.write("};\n");
        }
    }

    private void writeOptions(Writer w, java.util.Map<String, Object> options, boolean single) throws IOException {
        if (options.isEmpty()) {
            return;
        }
        if (single) {
            w.write(" [");
        }
        Iterator<Map.Entry<String, Object>> it = options.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> o = it.next();
            if (!single) {
                this.writeOffset(w);
                w.write("option ");
            }
            w.write(o.getKey());
            w.write(" = ");
            if (o.getValue() instanceof String) {
                w.write("\"");
                w.write(o.getValue().toString());
                w.write("\"");
            } else {
                w.write(o.getValue().toString());
            }
            if (single) {
                if (!it.hasNext()) continue;
                w.write(", ");
                continue;
            }
            w.write(";\n");
        }
        if (single) {
            w.write("]");
        }
    }

    private void indent() {
        this.offset += this.indent;
    }

    private void outdent() {
        this.offset -= this.indent;
    }
}

