/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jgroups.Constructable;
import org.jgroups.Header;
import org.jgroups.util.IntHashMap;
import org.jgroups.util.Triple;
import org.jgroups.util.Util;

public class ClassConfigurator {
    public static final String MAGIC_NUMBER_FILE = "jg-magic-map.xml";
    public static final String PROTOCOL_ID_FILE = "jg-protocol-ids.xml";
    protected static final String CLASS = "<class";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String EXTERNAL = "external";
    private static final int MAX_MAGIC_VALUE = 124;
    private static final int MAX_PROT_ID_VALUE = 256;
    private static final short MIN_CUSTOM_MAGIC_NUMBER = 1024;
    private static final short MIN_CUSTOM_PROTOCOL_ID = 512;
    private static final Map<Class<?>, Short> classMap = new IdentityHashMap(124);
    private static final Supplier<? extends Object>[] magicMap = new Supplier[124];
    private static final Map<Short, Object> magicMapUser = new HashMap<Short, Object>();
    private static final Map<Class<?>, Short> protocol_ids = new IdentityHashMap(256);
    private static final IntHashMap<Class<?>> protocol_names = new IntHashMap(256);

    public static void addIfAbsent(short magic, Class<?> clazz) {
        if (!magicMapUser.containsKey(magic) && !classMap.containsKey(clazz)) {
            ClassConfigurator.add(magic, clazz);
        }
    }

    public static void add(short magic, Class<?> clazz) {
        if (magic < 1024) {
            throw new IllegalArgumentException("magic ID (" + magic + ") must be >= 1024");
        }
        if (magicMapUser.containsKey(magic) || classMap.containsKey(clazz)) {
            ClassConfigurator.alreadyInMagicMap(magic, clazz.getName());
        }
        Object inst = null;
        try {
            inst = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed creating instance " + String.valueOf(clazz), e);
        }
        Supplier val = clazz;
        if (Header.class.isAssignableFrom(clazz)) {
            ClassConfigurator.checkSameId((Header)inst, magic);
            val = ((Header)inst).create();
        }
        if (Constructable.class.isAssignableFrom(clazz) && !(inst = (Object)(val = ((Constructable)inst).create()).get()).getClass().equals(clazz)) {
            throw new IllegalStateException(String.format("%s.create() returned the wrong class: %s\n", clazz.getSimpleName(), inst.getClass().getSimpleName()));
        }
        magicMapUser.put(magic, val);
        classMap.put(clazz, magic);
    }

    public static void addProtocol(short id, Class<?> protocol) {
        if (id < 512) {
            throw new IllegalArgumentException("protocol ID (" + id + ") needs to be greater than or equal to 512");
        }
        if (protocol_ids.containsKey(protocol)) {
            ClassConfigurator.alreadyInProtocolsMap(id, protocol.getName());
        }
        protocol_ids.put(protocol, id);
        protocol_names.put(id, protocol);
    }

    public static <T> T create(short id) throws ClassNotFoundException {
        if (id >= 1024) {
            Object val = magicMapUser.get(id);
            if (val == null) {
                throw new ClassNotFoundException("Class for magic number " + id + " cannot be found, map: " + String.valueOf(magicMapUser));
            }
            if (val instanceof Supplier) {
                return ((Supplier)val).get();
            }
            try {
                return ((Class)val).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
        }
        if (id < 0 || id > 124) {
            throw new IllegalArgumentException(String.format("invalid magic number %d; needs to be in range [0..%d]", id, 124));
        }
        Supplier<? extends Object> supplier = magicMap[id];
        if (supplier == null) {
            throw new ClassNotFoundException("Class for magic number " + id + " cannot be found");
        }
        return (T)supplier.get();
    }

    public static Class<?> get(String clazzname, ClassLoader loader) throws ClassNotFoundException {
        return Util.loadClass(clazzname, loader != null ? loader : ClassConfigurator.class.getClassLoader());
    }

    public static Class<?> get(String clazzname) throws ClassNotFoundException {
        return Util.loadClass(clazzname, ClassConfigurator.class);
    }

    public static short getMagicNumber(Class<?> clazz) {
        Short i = classMap.get(clazz);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public static short getProtocolId(Class<?> protocol) {
        Short retval = protocol_ids.get(protocol);
        return retval != null ? retval : (short)0;
    }

    public static Class<?> getProtocol(short id) {
        return protocol_names.get(id);
    }

    public static String printClassMap() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Class<?>, Short> entry : classMap.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    protected static void init() throws Exception {
        Class<?> clazz;
        boolean external;
        short m;
        String magic_number_file = null;
        String protocol_id_file = null;
        try {
            magic_number_file = Util.getProperty(new String[]{"jgroups.conf.magic_number_file", "org.jgroups.conf.magicNumberFile"}, null, null, MAGIC_NUMBER_FILE);
            protocol_id_file = Util.getProperty(new String[]{"jgroups.conf.protocol_id_file", "org.jgroups.conf.protocolIDFile"}, null, null, PROTOCOL_ID_FILE);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        List<Triple<Short, String, Boolean>> mapping = ClassConfigurator.readMappings(magic_number_file);
        for (Triple<Short, String, Boolean> tuple : mapping) {
            Object inst;
            m = tuple.val1();
            if (m >= 124) {
                throw new IllegalArgumentException("ID " + m + " is bigger than MAX_MAGIC_VALUE (124); increase MAX_MAGIC_VALUE");
            }
            external = tuple.val3();
            if (external) {
                if (magicMap[m] == null) continue;
                ClassConfigurator.alreadyInMagicMap(m, tuple.val2());
                continue;
            }
            clazz = Util.loadClass(tuple.val2(), ClassConfigurator.class);
            if (magicMap[m] != null) {
                ClassConfigurator.alreadyInMagicMap(m, clazz.getName());
            }
            if (Constructable.class.isAssignableFrom(clazz)) {
                Constructable obj = (Constructable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ClassConfigurator.magicMap[m] = obj.create();
            } else {
                Supplier<Object> supplier = () -> {
                    try {
                        return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable throwable) {
                        return null;
                    }
                };
                ClassConfigurator.magicMap[m] = supplier;
            }
            if ((inst = magicMap[m].get()) == null) continue;
            if (!inst.getClass().equals(clazz)) {
                throw new IllegalStateException(String.format("%s.create() returned the wrong class: %s\n", clazz.getSimpleName(), inst.getClass().getSimpleName()));
            }
            if (inst instanceof Header) {
                ClassConfigurator.checkSameId((Header)inst, m);
            }
            classMap.put(clazz, m);
        }
        mapping = ClassConfigurator.readMappings(protocol_id_file);
        for (Triple<Short, String, Boolean> tuple : mapping) {
            m = tuple.val1();
            external = tuple.val3();
            if (external) {
                if (!protocol_names.containsKey(m)) continue;
                ClassConfigurator.alreadyInProtocolsMap(m, tuple.val2());
                continue;
            }
            clazz = Util.loadClass(tuple.val2(), ClassConfigurator.class);
            if (protocol_ids.containsKey(clazz)) {
                ClassConfigurator.alreadyInProtocolsMap(m, clazz.getName());
            }
            protocol_ids.put(clazz, m);
            protocol_names.put(m, clazz);
        }
    }

    protected static void checkSameId(Header hdr, short magic) {
        short tmp_id = hdr.getMagicId();
        if (tmp_id != magic) {
            throw new IllegalStateException(String.format("mismatch between %s.getId() (%d) and the defined ID (%d)", hdr.getClass().getSimpleName(), magic, tmp_id));
        }
    }

    protected static void alreadyInMagicMap(short magic, String classname) {
        throw new IllegalArgumentException("key " + magic + " (" + classname + ") is already in magic map; make sure that all keys are unique");
    }

    protected static void alreadyInProtocolsMap(short prot_id, String classname) {
        throw new IllegalArgumentException("ID " + prot_id + " (" + classname + ") is already in protocol-ids map; make sure that all protocol IDs are unique");
    }

    protected static List<Triple<Short, String, Boolean>> readMappings(String name) throws Exception {
        InputStream stream = Util.getResourceAsStream(name, ClassConfigurator.class);
        if (stream == null) {
            stream = new FileInputStream(name);
        }
        return ClassConfigurator.parse(stream);
    }

    protected static List<Triple<Short, String, Boolean>> parse(InputStream in) throws Exception {
        List<String> lines = ClassConfigurator.parseLines(in);
        ArrayList<Triple<Short, String, Boolean>> retval = new ArrayList<Triple<Short, String, Boolean>>();
        for (String line : lines) {
            boolean external = false;
            int index = line.indexOf(ID);
            if (index == -1) {
                ClassConfigurator.notFound(ID, line);
            }
            short id = Short.parseShort(ClassConfigurator.parseNextString(line, index += ID.length() + 1));
            index = line.indexOf(NAME);
            if (index == -1) {
                ClassConfigurator.notFound(NAME, line);
            }
            String name = ClassConfigurator.parseNextString(line, index += NAME.length() + 1);
            index = line.indexOf(EXTERNAL);
            if (index >= 0) {
                external = Boolean.parseBoolean(ClassConfigurator.parseNextString(line, index += EXTERNAL.length() + 1));
            }
            Triple<Short, String, Boolean> t = new Triple<Short, String, Boolean>(id, name, external);
            retval.add(t);
        }
        return retval;
    }

    protected static void notFound(String id, String line) {
        throw new IllegalStateException(String.format("%s not found in line %s", id, line));
    }

    protected static String parseNextString(String line, int index) {
        int start = line.indexOf("\"", index);
        if (index == -1) {
            ClassConfigurator.notFound("\"", line.substring(index));
        }
        int end = line.indexOf("\"", start + 1);
        if (index == -1) {
            ClassConfigurator.notFound("\"", line.substring(index + 1));
        }
        return line.substring(start + 1, end);
    }

    protected static List<String> parseLines(InputStream in) throws IOException {
        String token;
        LinkedList<String> lines = new LinkedList<String>();
        while ((token = Util.readToken(in)) != null) {
            if (!(token = token.trim()).startsWith(CLASS)) continue;
            String line = token + " " + ClassConfigurator.readTillMatchingParens(in);
            lines.add(line);
        }
        return lines;
    }

    protected static String readTillMatchingParens(InputStream in) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = in.read()) != -1) {
            sb.append((char)ch);
            if (ch != 62) continue;
            break;
        }
        return sb.toString();
    }

    static {
        try {
            ClassConfigurator.init();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

