/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jgroups.util.BaseDataOutputStream;
import org.jgroups.util.ByteArray;
import org.jgroups.util.Util;

public class ByteArrayDataOutputStream
extends BaseDataOutputStream {
    protected byte[] buf;
    protected boolean grow_exponentially;

    public ByteArrayDataOutputStream() {
        this(32, false);
    }

    public ByteArrayDataOutputStream(int capacity) {
        this(capacity, false);
    }

    public ByteArrayDataOutputStream(int capacity, boolean grow_exponentially) {
        this.buf = new byte[capacity];
        this.grow_exponentially = grow_exponentially;
    }

    public byte[] buffer() {
        return this.buf;
    }

    public ByteArray getBuffer() {
        return new ByteArray(this.buf, 0, this.pos);
    }

    public ByteBuffer byteBuffer() {
        return ByteBuffer.wrap(this.buf, 0, this.pos);
    }

    public int capacity() {
        return this.buf.length;
    }

    public boolean growExponentially() {
        return this.grow_exponentially;
    }

    public ByteArrayDataOutputStream growExponentially(boolean b) {
        this.grow_exponentially = b;
        return this;
    }

    @Override
    public void writeChar(int v) {
        this.writeShort((short)v);
    }

    @Override
    public void writeInt(int v) {
        this.ensureCapacity(4);
        Util.INT_ARRAY_VIEW.set(this.buf, this.pos, v);
        this.pos += 4;
    }

    @Override
    public void writeLong(long v) {
        this.ensureCapacity(8);
        Util.LONG_ARRAY_VIEW.set(this.buf, this.pos, v);
        this.pos += 8;
    }

    @Override
    public void writeShort(int v) {
        this.ensureCapacity(2);
        byte[] array = this.buf;
        int index = this.pos;
        array[index] = (byte)(v >> 8 & 0xFF);
        array[index + 1] = (byte)(v & 0xFF);
        this.pos += 2;
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(1);
        this.buf[this.pos++] = (byte)b;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException(String.format("off=%d, len=%d, b.length=%d", off, len, b.length));
        }
        this.ensureCapacity(len);
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
    }

    @Override
    public String toString() {
        return super.toString() + String.format(", lim=%d", this.buf.length);
    }

    @Override
    protected int checkBounds(int pos) {
        super.checkBounds(pos);
        if (pos > this.buf.length) {
            throw new IndexOutOfBoundsException("length=" + this.buf.length);
        }
        return pos;
    }

    @Override
    public void ensureCapacity(int bytes) {
        int minCapacity = this.pos + bytes;
        if (minCapacity - this.buf.length > 0) {
            int newCapacity;
            int n = newCapacity = this.grow_exponentially ? this.buf.length << 1 : this.pos + bytes + 32;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity < 0) {
                if (minCapacity < 0) {
                    throw new OutOfMemoryError();
                }
                newCapacity = Integer.MAX_VALUE;
            }
            this.buf = Arrays.copyOf(this.buf, newCapacity);
        }
    }
}

