/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FastArray<T>
implements Iterable<T>,
List<T> {
    protected T[] elements;
    protected int index;
    protected int size;
    protected int increment;
    protected int print_limit = 20;

    public FastArray() {
        this(16);
    }

    public FastArray(int capacity) {
        this.elements = new Object[capacity];
    }

    public FastArray(T[] elements, int index) {
        this.elements = Objects.requireNonNull(elements);
        this.index = index;
        this.size = this.count();
    }

    public FastArray(Collection<? extends T> c) {
        this(c != null ? c.size() : 16);
        this.addAll(c);
    }

    public int capacity() {
        return this.elements.length;
    }

    public int index() {
        return this.index;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public int increment() {
        return this.increment;
    }

    public FastArray<T> increment(int i) {
        this.increment = i;
        return this;
    }

    public int printLimit() {
        return this.print_limit;
    }

    public FastArray<T> printLimit(int l) {
        this.print_limit = l;
        return this;
    }

    @Override
    public boolean add(T el) {
        return this.add(el, true);
    }

    public boolean add(T el, boolean resize) {
        if (el == null) {
            return false;
        }
        if (this.index == this.elements.length) {
            if (!resize) {
                return false;
            }
            this.resize(this.index + 1);
        }
        this.elements[this.index++] = el;
        ++this.size;
        return true;
    }

    @Override
    public void add(int idx, T el) {
        this.checkIndex(idx);
        if (this.index + 1 > this.elements.length) {
            this.resize(this.index + 1);
        }
        System.arraycopy(this.elements, idx, this.elements, idx + 1, this.index - idx);
        this.elements[idx] = el;
        if (el != null) {
            ++this.size;
        }
        ++this.index;
    }

    public boolean addAll(T[] els, int length) {
        if (els == null) {
            return false;
        }
        if (length > els.length) {
            length = els.length;
        }
        if (this.index + length > this.elements.length) {
            this.resize(this.index + length);
        }
        System.arraycopy(els, 0, this.elements, this.index, length);
        int added = 0;
        int end_index = this.index + length;
        while (this.index < end_index) {
            if (this.elements[this.index++] == null) continue;
            ++added;
        }
        this.size += added;
        return true;
    }

    @SafeVarargs
    public final boolean addAll(T ... els) {
        return els != null && this.addAll(els, els.length);
    }

    @Override
    public boolean addAll(Collection<? extends T> list) {
        if (list == null) {
            return false;
        }
        int list_size = list.size();
        if (this.index + list_size > this.elements.length) {
            this.resize(this.index + list_size);
        }
        int old_size = this.size;
        for (T el : list) {
            if (el == null) continue;
            this.elements[this.index++] = el;
            ++this.size;
        }
        return this.size > old_size;
    }

    @Override
    public boolean addAll(FastArray<T> fa) {
        return this.addAll(fa, true);
    }

    public boolean addAll(FastArray<T> fa, boolean resize) {
        if (fa == null) {
            return false;
        }
        if (this == fa) {
            throw new IllegalArgumentException("cannot add FastArray to itself");
        }
        int fa_size = fa.size();
        if (this.index + fa_size > this.elements.length && resize) {
            this.resize(this.index + fa_size);
        }
        int old_size = this.size;
        for (Object el : fa) {
            if (this.index >= this.elements.length) {
                return this.size > old_size;
            }
            this.elements[this.index++] = el;
            ++this.size;
        }
        return this.size > old_size;
    }

    @Override
    public boolean addAll(int idx, Collection<? extends T> c) {
        int elements_to_move;
        this.checkIndex(idx);
        if (c == null || c.isEmpty()) {
            return false;
        }
        int old_size = this.size;
        int new_elements = c.size();
        if (this.index + new_elements > this.elements.length) {
            this.resize(this.index + new_elements);
        }
        if ((elements_to_move = this.index - idx) > 0) {
            System.arraycopy(this.elements, idx, this.elements, idx + new_elements, elements_to_move);
        }
        Iterator<T> it = c.iterator();
        for (int i = 0; i < new_elements; ++i) {
            T el = it.next();
            this.elements[idx + i] = el;
            if (el == null) continue;
            ++this.size;
        }
        this.index += new_elements;
        return this.size != old_size;
    }

    public int transferFrom(FastArray<T> other, boolean clear) {
        if (other == null || this == other || other.isEmpty()) {
            return 0;
        }
        int capacity = this.elements.length;
        int other_index = other.index();
        int other_size = other.size();
        if (capacity < other_index) {
            this.elements = Arrays.copyOf(other.elements, other_index);
        } else {
            System.arraycopy(other.elements, 0, this.elements, 0, other_index);
        }
        if (this.index > other.index) {
            for (int i = other.index; i < this.index; ++i) {
                this.elements[i] = null;
            }
        }
        this.index = other.index;
        this.size = other_size;
        if (clear) {
            other.clear(true);
        }
        return other_size;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        return obj.getClass() == FastArray.class ? this.equalsArrayList((FastArray)obj) : this.equalsRange((List)obj, 0, this.size);
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.index; ++i) {
            T el = this.elements[i];
            if (!(el != null ? Objects.equals(el, o) : o == null)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.index - 1; i >= 0; --i) {
            T el = this.elements[i];
            if (!(el != null ? Objects.equals(el, o) : o == null)) continue;
            return i;
        }
        return -1;
    }

    public boolean anyMatch(Predicate<T> pred) {
        if (pred == null) {
            return false;
        }
        for (int i = 0; i < this.index; ++i) {
            T el = this.elements[i];
            if (el == null || !pred.test(el)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T get(int idx) {
        if (idx < 0 || idx >= this.index) {
            return null;
        }
        return this.elements[idx];
    }

    @Override
    public T set(int idx, T el) {
        if (idx < 0 || idx >= this.index) {
            return null;
        }
        T old_el = this.elements[idx];
        if (old_el == null) {
            if (el != null) {
                ++this.size;
            }
        } else if (el == null) {
            --this.size;
        }
        this.elements[idx] = el;
        return old_el;
    }

    public FastArray<T> set(T[] elements) {
        this.elements = Objects.requireNonNull(elements);
        this.index = elements.length;
        this.size = this.count();
        return this;
    }

    @Override
    public T remove(int idx) {
        return this.set(idx, (T)null);
    }

    @Override
    public boolean remove(Object o) {
        int idx = this.indexOf(o);
        if (idx >= 0) {
            this.remove(idx);
            return true;
        }
        return false;
    }

    @Override
    public T removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        for (int i = 0; i < this.index; ++i) {
            if (this.elements[i] == null) continue;
            T el = this.elements[i];
            this.elements[i] = null;
            --this.size;
            return el;
        }
        return null;
    }

    @Override
    public T removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        for (int i = this.index - 1; i >= 0; --i) {
            if (this.elements[i] == null) continue;
            T el = this.elements[i];
            this.elements[i] = null;
            --this.size;
            this.index = i;
            return el;
        }
        return null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        boolean removed = false;
        for (Object obj : c) {
            if (!this.remove(obj)) continue;
            removed = true;
        }
        return removed;
    }

    public FastArray<T> removeIf(Predicate<T> filter, boolean replace_all) {
        return this.replaceIf(filter, null, replace_all);
    }

    public FastArray<T> replaceIf(Predicate<T> filter, T new_el, boolean replace_all) {
        if (filter == null) {
            return this;
        }
        FastIterator it = this.iterator(filter);
        while (it.hasNext()) {
            it.next();
            int saved_cursor = it.cursor;
            int saved_last_idx = it.last_idx;
            it.replace(new_el);
            if (!replace_all) break;
            it.cursor = saved_cursor;
            it.last_idx = saved_last_idx;
        }
        return this;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int old_size = this.size;
        if (c == null || c.isEmpty()) {
            return false;
        }
        this.replaceIf(el -> !c.contains(el), null, true);
        return this.size != old_size;
    }

    @Override
    public void clear() {
        this.clear(true);
    }

    public FastArray<T> clear(boolean null_elements) {
        if (null_elements) {
            for (int i = 0; i < this.index; ++i) {
                this.elements[i] = null;
            }
        }
        this.size = 0;
        this.index = 0;
        return this;
    }

    public FastArray<T> trimTo(int new_capacity) {
        if (new_capacity >= this.elements.length) {
            return this;
        }
        if (new_capacity <= this.index) {
            return this;
        }
        this.elements = Arrays.copyOf(this.elements, new_capacity);
        return this;
    }

    public FastIterator iterator() {
        return new FastIterator(null);
    }

    public FastIterator iterator(Predicate<T> filter) {
        return new FastIterator(filter);
    }

    @Override
    public Stream<T> stream() {
        Spliterator sp = Spliterators.spliterator(this.iterator(), (long)this.size, 0);
        return StreamSupport.stream(sp, false);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new FastListIterator(null);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new FastListIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elements, this.index);
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return Arrays.copyOf(this.elements, this.index, a.getClass());
    }

    public int count() {
        int cnt = 0;
        for (int i = 0; i < this.index; ++i) {
            if (this.elements[i] == null) continue;
            ++cnt;
        }
        return cnt;
    }

    public String toString() {
        return String.format("%d elements: [%s]", this.size, this.print());
    }

    public String print() {
        return this.print(this.print_limit);
    }

    public FastArray<T> resize(int new_capacity) {
        int new_cap;
        if (new_capacity <= this.elements.length) {
            return this;
        }
        if (this.increment > 0) {
            new_cap = new_capacity + this.increment;
        } else {
            int old_capacity = this.elements.length;
            int min_growth = new_capacity - old_capacity;
            int preferred_growth = old_capacity >> 1;
            new_cap = old_capacity + Math.max(min_growth, preferred_growth);
        }
        this.elements = Arrays.copyOf(this.elements, new_cap);
        return this;
    }

    protected boolean equalsArrayList(FastArray<?> other) {
        if (this.size != other.size()) {
            return false;
        }
        T[] other_elements = other.elements;
        T[] es = this.elements;
        for (int i = 0; i < this.size; ++i) {
            if (Objects.equals(es[i], other_elements[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean equalsRange(List<?> other, int from, int to) {
        T[] es = this.elements;
        Iterator<?> oit = other.iterator();
        while (from < to) {
            if (!oit.hasNext() || !Objects.equals(es[from], oit.next())) {
                return false;
            }
            ++from;
        }
        return !oit.hasNext();
    }

    protected String print(int limit) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (int i = 0; i < this.index; ++i) {
            T el = this.elements[i];
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(el);
            if (limit <= 0 || ++count < limit) continue;
            return sb.append(" ...").toString();
        }
        return sb.toString();
    }

    protected int checkIndex(int idx) {
        if (idx > this.index || idx < 0) {
            throw new IndexOutOfBoundsException(String.format("0 >= idx (%d) < index (%d)", idx, this.index));
        }
        return idx;
    }

    public class FastIterator
    implements Iterator<T> {
        protected int cursor;
        protected int last_idx = -1;
        protected final Predicate<T> filter;
        protected int hit_count;

        public FastIterator(Predicate<T> filter) {
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            while (this.cursor < FastArray.this.index && this.hit_count < FastArray.this.size && this.nullOrNoFilterMatch(this.cursor)) {
                ++this.cursor;
            }
            return this.cursor < FastArray.this.index && this.hit_count < FastArray.this.size;
        }

        @Override
        public T next() {
            int i = this.cursor;
            if (i >= FastArray.this.index) {
                throw new NoSuchElementException();
            }
            if (i >= FastArray.this.elements.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i + 1;
            ++this.hit_count;
            this.last_idx = i;
            return FastArray.this.elements[this.last_idx];
        }

        @Override
        public void remove() {
            if (this.last_idx < 0) {
                throw new IllegalStateException();
            }
            this.replace(null);
        }

        public void replace(T el) {
            if (this.last_idx < 0) {
                throw new IllegalStateException();
            }
            int old_size = FastArray.this.size;
            FastArray.this.set(this.last_idx, el);
            if (FastArray.this.size < old_size) {
                this.hit_count = Math.max(this.hit_count - 1, 0);
            }
        }

        public int cursor() {
            return this.cursor;
        }

        public int hitCount() {
            return this.hit_count;
        }

        protected boolean nullOrNoFilterMatch(int idx) {
            boolean result;
            if (FastArray.this.elements[idx] == null) {
                return true;
            }
            boolean bl = result = this.filter != null && !this.filter.test(FastArray.this.elements[idx]);
            if (result) {
                ++this.hit_count;
            }
            return result;
        }

        public String toString() {
            return String.format("cursor=%d hit-count=%d", this.cursor, this.hit_count);
        }
    }

    public class FastListIterator
    extends FastIterator
    implements ListIterator<T> {
        public FastListIterator(int idx) {
            this(null, idx);
        }

        public FastListIterator(Predicate<T> filter) {
            this(filter, 0);
        }

        public FastListIterator(Predicate<T> filter, int idx) {
            super(filter);
            this.cursor = FastArray.this.checkIndex(idx);
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public T previous() {
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            if (i >= FastArray.this.elements.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i;
            this.last_idx = i;
            return FastArray.this.elements[this.last_idx];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(T el) {
            if (this.last_idx < 0) {
                throw new IllegalStateException();
            }
            FastArray.this.set(this.last_idx, el);
        }

        @Override
        public void add(T el) {
            int i = this.cursor;
            FastArray.this.add(i, el);
            this.cursor = i + 1;
            this.last_idx = -1;
        }
    }
}

