/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.AuthenticationSteps;
import org.springframework.vault.authentication.AuthenticationStepsFactory;
import org.springframework.vault.authentication.AuthenticationUtil;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.LoginTokenUtil;
import org.springframework.vault.authentication.UsernamePasswordAuthenticationOptions;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

public class UsernamePasswordAuthentication
implements ClientAuthentication,
AuthenticationStepsFactory {
    private static final Log logger = LogFactory.getLog(UsernamePasswordAuthentication.class);
    private final UsernamePasswordAuthenticationOptions options;
    private final RestOperations restOperations;

    public UsernamePasswordAuthentication(UsernamePasswordAuthenticationOptions options, RestOperations restOperations) {
        Assert.notNull((Object)options, (String)"UsernamePasswordAuthenticationOptions must not be null");
        Assert.notNull((Object)restOperations, (String)"RestOperations must not be null");
        this.options = options;
        this.restOperations = restOperations;
    }

    public static AuthenticationSteps createAuthenticationSteps(UsernamePasswordAuthenticationOptions options) {
        Assert.notNull((Object)options, (String)"UsernamePasswordAuthenticationOptions must not be null");
        Map<String, Object> body = UsernamePasswordAuthentication.createLoginBody(options);
        return AuthenticationSteps.fromSupplier(() -> body).login("%s/%s".formatted(AuthenticationUtil.getLoginPath(options.getPath()), options.getUsername()), new String[0]);
    }

    @Override
    public VaultToken login() throws VaultException {
        return this.createTokenUsingUsernamePasswordAuthentication();
    }

    @Override
    public AuthenticationSteps getAuthenticationSteps() {
        return UsernamePasswordAuthentication.createAuthenticationSteps(this.options);
    }

    private VaultToken createTokenUsingUsernamePasswordAuthentication() {
        try {
            VaultResponse response = (VaultResponse)this.restOperations.postForObject("%s/%s".formatted(AuthenticationUtil.getLoginPath(this.options.getPath()), this.options.getUsername()), UsernamePasswordAuthentication.createLoginBody(this.options), VaultResponse.class, new Object[0]);
            logger.debug((Object)"Login successful using username and password credentials");
            return LoginTokenUtil.from(response.getAuth());
        }
        catch (HttpStatusCodeException e) {
            throw new VaultException("Cannot login using username and password: %s".formatted(VaultResponses.getError(e.getResponseBodyAsString())), e);
        }
    }

    private static Map<String, Object> createLoginBody(UsernamePasswordAuthenticationOptions options) {
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("password", options.getPassword());
        CharSequence totp = options.getTotp();
        if (totp != null) {
            body.put("totp", totp);
        }
        return body;
    }
}

