/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.support.Certificate;
import org.springframework.vault.support.KeyFactories;
import org.springframework.vault.support.KeystoreUtil;
import org.springframework.vault.support.PemObject;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CertificateBundle
extends Certificate {
    private final String privateKey;
    @Nullable
    private final String privateKeyType;

    CertificateBundle(@JsonProperty(value="serial_number") String serialNumber, @JsonProperty(value="certificate") String certificate, @JsonProperty(value="issuing_ca") String issuingCaCertificate, @JsonProperty(value="ca_chain") List<String> caChain, @JsonProperty(value="private_key") String privateKey, @Nullable @JsonProperty(value="private_key_type") String privateKeyType, @JsonProperty(value="revocation_time") Long revocationTime) {
        super(serialNumber, certificate, issuingCaCertificate, caChain, revocationTime);
        this.privateKey = privateKey;
        this.privateKeyType = privateKeyType;
    }

    public static CertificateBundle of(String serialNumber, String certificate, String issuingCaCertificate, String privateKey) {
        Assert.hasText((String)serialNumber, (String)"Serial number must not be empty");
        Assert.hasText((String)certificate, (String)"Certificate must not be empty");
        Assert.hasText((String)issuingCaCertificate, (String)"Issuing CA certificate must not be empty");
        Assert.hasText((String)privateKey, (String)"Private key must not be empty");
        return new CertificateBundle(serialNumber, certificate, issuingCaCertificate, Collections.singletonList(issuingCaCertificate), privateKey, privateKey, null);
    }

    public static CertificateBundle of(String serialNumber, String certificate, String issuingCaCertificate, String privateKey, @Nullable String privateKeyType) {
        Assert.hasText((String)serialNumber, (String)"Serial number must not be empty");
        Assert.hasText((String)certificate, (String)"Certificate must not be empty");
        Assert.hasText((String)issuingCaCertificate, (String)"Issuing CA certificate must not be empty");
        Assert.hasText((String)privateKey, (String)"Private key must not be empty");
        Assert.hasText((String)privateKeyType, (String)"Private key type must not be empty");
        return new CertificateBundle(serialNumber, certificate, issuingCaCertificate, Collections.singletonList(issuingCaCertificate), privateKey, privateKeyType, null);
    }

    public static CertificateBundle of(String serialNumber, String certificate, String issuingCaCertificate, String privateKey, @Nullable String privateKeyType, Long revocationTime) {
        Assert.hasText((String)serialNumber, (String)"Serial number must not be empty");
        Assert.hasText((String)certificate, (String)"Certificate must not be empty");
        Assert.hasText((String)issuingCaCertificate, (String)"Issuing CA certificate must not be empty");
        Assert.hasText((String)privateKey, (String)"Private key must not be empty");
        Assert.hasText((String)privateKeyType, (String)"Private key type must not be empty");
        Assert.notNull((Object)revocationTime, (String)"Revocation time must not be null");
        return new CertificateBundle(serialNumber, certificate, issuingCaCertificate, Collections.singletonList(issuingCaCertificate), privateKey, privateKeyType, revocationTime);
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    @Nullable
    public String getPrivateKeyType() {
        return this.privateKeyType;
    }

    public String getRequiredPrivateKeyType() {
        String type = this.getPrivateKeyType();
        if (type == null) {
            throw new IllegalStateException("Private key type is not set");
        }
        return type;
    }

    public KeySpec getPrivateKeySpec() {
        try {
            return CertificateBundle.getPrivateKey(this.getPrivateKey(), this.getRequiredPrivateKeyType());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new VaultException("Cannot create KeySpec from private key", e);
        }
    }

    public KeyStore createKeyStore(String keyAlias) {
        return this.createKeyStore(keyAlias, false);
    }

    public KeyStore createKeyStore(String keyAlias, CharSequence password) {
        return this.createKeyStore(keyAlias, false, password);
    }

    public KeyStore createKeyStore(String keyAlias, char[] password) {
        return this.createKeyStore(keyAlias, false, password);
    }

    public KeyStore createKeyStore(String keyAlias, boolean includeCaChain) {
        return this.createKeyStore(keyAlias, includeCaChain, new char[0]);
    }

    public KeyStore createKeyStore(String keyAlias, boolean includeCaChain, CharSequence password) {
        Assert.notNull((Object)password, (String)"Password must not be null");
        char[] passwordChars = new char[password.length()];
        for (int i = 0; i < passwordChars.length; ++i) {
            passwordChars[i] = password.charAt(i);
        }
        return this.createKeyStore(keyAlias, includeCaChain, passwordChars);
    }

    public KeyStore createKeyStore(String keyAlias, boolean includeCaChain, char[] password) {
        Assert.hasText((String)keyAlias, (String)"Key alias must not be empty");
        Assert.notNull((Object)password, (String)"Password must not be null");
        try {
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            certificates.add(this.getX509Certificate());
            if (includeCaChain) {
                certificates.addAll(this.getX509IssuerCertificates());
            } else {
                certificates.add(this.getX509IssuerCertificate());
            }
            return KeystoreUtil.createKeyStore(keyAlias, this.getPrivateKeySpec(), password, certificates.toArray(new X509Certificate[0]));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new VaultException("Cannot create KeyStore", e);
        }
    }

    private static KeySpec getPrivateKey(String privateKey, String keyType) throws GeneralSecurityException, IOException {
        Assert.hasText((String)privateKey, (String)"Private key must not be empty");
        Assert.hasText((String)keyType, (String)"Private key type must not be empty");
        if (PemObject.isPemEncoded(privateKey)) {
            List<PemObject> pemObjects = PemObject.parse(privateKey);
            for (PemObject pemObject : pemObjects) {
                if (!pemObject.isPrivateKey()) continue;
                return CertificateBundle.getPrivateKey(pemObject.getContent(), keyType);
            }
            throw new IllegalArgumentException("No private key found in PEM-encoded key spec");
        }
        return CertificateBundle.getPrivateKey(Base64.getDecoder().decode(privateKey), keyType);
    }

    private static KeySpec getPrivateKey(byte[] privateKey, String keyType) throws GeneralSecurityException, IOException {
        return switch (keyType.toLowerCase(Locale.ROOT)) {
            case "rsa" -> KeyFactories.RSA_PRIVATE.getKey(privateKey);
            case "ec" -> KeyFactories.EC.getKey(privateKey);
            default -> throw new IllegalArgumentException("Key type %s not supported. Supported types are: rsa, ec.".formatted(keyType));
        };
    }
}

