/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class VaultCertificateRequest {
    private static String DEFAULT_FORMAT = "der";
    private final String commonName;
    private final boolean excludeCommonNameFromSubjectAltNames;
    private final List<String> altNames;
    private final List<String> ipSubjectAltNames;
    private final List<String> uriSubjectAltNames;
    private final List<String> otherSans;
    @Nullable
    private final Duration ttl;
    @Nullable
    private final Instant notAfter;
    private final String format;
    @Nullable
    private final String privateKeyFormat;
    @Nullable
    private final String userIds;

    private VaultCertificateRequest(String commonName, boolean excludeCommonNameFromSubjectAltNames, List<String> altNames, List<String> ipSubjectAltNames, List<String> uriSubjectAltNames, List<String> otherSans, @Nullable Duration ttl, @Nullable Instant notAfter, String format, @Nullable String privateKeyFormat, @Nullable String userIds) {
        this.commonName = commonName;
        this.excludeCommonNameFromSubjectAltNames = excludeCommonNameFromSubjectAltNames;
        this.altNames = altNames;
        this.ipSubjectAltNames = ipSubjectAltNames;
        this.uriSubjectAltNames = uriSubjectAltNames;
        this.otherSans = otherSans;
        this.ttl = ttl;
        this.notAfter = notAfter;
        this.format = format;
        this.privateKeyFormat = privateKeyFormat;
        this.userIds = userIds;
    }

    public static VaultCertificateRequestBuilder builder() {
        return new VaultCertificateRequestBuilder();
    }

    public static VaultCertificateRequest create(String commonName) {
        return VaultCertificateRequest.builder().commonName(commonName).build();
    }

    public String getCommonName() {
        return this.commonName;
    }

    public List<String> getAltNames() {
        return this.altNames;
    }

    public List<String> getIpSubjectAltNames() {
        return this.ipSubjectAltNames;
    }

    public List<String> getUriSubjectAltNames() {
        return this.uriSubjectAltNames;
    }

    public List<String> getOtherSans() {
        return this.otherSans;
    }

    @Nullable
    public Duration getTtl() {
        return this.ttl;
    }

    public String getFormat() {
        return this.format;
    }

    @Nullable
    public String getPrivateKeyFormat() {
        return this.privateKeyFormat;
    }

    public boolean isExcludeCommonNameFromSubjectAltNames() {
        return this.excludeCommonNameFromSubjectAltNames;
    }

    @Nullable
    public Instant getNotAfter() {
        return this.notAfter;
    }

    @Nullable
    public String getUserIds() {
        return this.userIds;
    }

    public static class VaultCertificateRequestBuilder {
        @Nullable
        private String commonName;
        private List<String> altNames = new ArrayList<String>();
        private List<String> ipSubjectAltNames = new ArrayList<String>();
        private List<String> uriSubjectAltNames = new ArrayList<String>();
        private List<String> otherSans = new ArrayList<String>();
        @Nullable
        private Duration ttl;
        private String format = DEFAULT_FORMAT;
        @Nullable
        private String privateKeyFormat;
        private boolean excludeCommonNameFromSubjectAltNames;
        @Nullable
        private Instant notAfter;
        @Nullable
        private String userIds;

        VaultCertificateRequestBuilder() {
        }

        public VaultCertificateRequestBuilder commonName(String commonName) {
            Assert.hasText((String)commonName, (String)"Common name must not be empty");
            this.commonName = commonName;
            return this;
        }

        public VaultCertificateRequestBuilder excludeCommonNameFromSubjectAltNames() {
            this.excludeCommonNameFromSubjectAltNames = true;
            return this;
        }

        public VaultCertificateRequestBuilder altNames(Iterable<String> altNames) {
            Assert.notNull(altNames, (String)"Alt names must not be null");
            this.altNames = VaultCertificateRequestBuilder.toList(altNames);
            return this;
        }

        public VaultCertificateRequestBuilder withAltName(String altName) {
            Assert.hasText((String)altName, (String)"Alt name must not be empty");
            this.altNames.add(altName);
            return this;
        }

        public VaultCertificateRequestBuilder ipSubjectAltNames(Iterable<String> ipSubjectAltNames) {
            Assert.notNull(ipSubjectAltNames, (String)"IP subject alt names must not be null");
            this.ipSubjectAltNames = VaultCertificateRequestBuilder.toList(ipSubjectAltNames);
            return this;
        }

        public VaultCertificateRequestBuilder withIpSubjectAltName(String ipSubjectAltName) {
            Assert.hasText((String)ipSubjectAltName, (String)"IP subject alt name must not be empty");
            this.ipSubjectAltNames.add(ipSubjectAltName);
            return this;
        }

        public VaultCertificateRequestBuilder uriSubjectAltNames(Iterable<String> uriSubjectAltNames) {
            Assert.notNull(uriSubjectAltNames, (String)"URI subject alt names must not be null");
            this.uriSubjectAltNames = VaultCertificateRequestBuilder.toList(uriSubjectAltNames);
            return this;
        }

        public VaultCertificateRequestBuilder withUriSubjectAltName(String uriSubjectAltName) {
            Assert.hasText((String)uriSubjectAltName, (String)"URI subject alt name must not be empty");
            this.uriSubjectAltNames.add(uriSubjectAltName);
            return this;
        }

        public VaultCertificateRequestBuilder otherSans(Iterable<String> otherSans) {
            Assert.notNull(otherSans, (String)"Other subject alt names must not be null");
            this.otherSans = VaultCertificateRequestBuilder.toList(otherSans);
            return this;
        }

        public VaultCertificateRequestBuilder withOtherSans(String otherSans) {
            Assert.hasText((String)otherSans, (String)"Other subject alt name must not be empty");
            this.otherSans.add(otherSans);
            return this;
        }

        public VaultCertificateRequestBuilder ttl(long ttl, TimeUnit timeUnit) {
            Assert.isTrue((ttl > 0L ? 1 : 0) != 0, (String)"TTL must not be negative");
            Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must be greater 0");
            this.ttl = Duration.ofSeconds(timeUnit.toSeconds(ttl));
            return this;
        }

        public VaultCertificateRequestBuilder ttl(Duration ttl) {
            Assert.notNull((Object)ttl, (String)"TTL must not be null");
            Assert.isTrue((!ttl.isNegative() ? 1 : 0) != 0, (String)"TTL must not be negative");
            this.ttl = ttl;
            return this;
        }

        public VaultCertificateRequestBuilder notAfter(Instant notAfter) {
            Assert.notNull((Object)notAfter, (String)"Not after must not be null");
            this.notAfter = Instant.from(notAfter).truncatedTo(ChronoUnit.SECONDS);
            return this;
        }

        public VaultCertificateRequestBuilder format(String format) {
            Assert.hasText((String)format, (String)"Format must not be empty or null");
            this.format = format;
            return this;
        }

        public VaultCertificateRequestBuilder privateKeyFormat(String privateKeyFormat) {
            Assert.hasText((String)privateKeyFormat, (String)"Private key format must not be empty or null");
            this.privateKeyFormat = privateKeyFormat;
            return this;
        }

        public VaultCertificateRequestBuilder userId(String userId) {
            Assert.hasText((String)userId, (String)"User ID must not be empty or null");
            this.userIds = userId;
            return this;
        }

        public VaultCertificateRequestBuilder userIds(Collection<String> userIds) {
            Assert.notNull(userIds, (String)"User IDs must not be null");
            this.userIds = StringUtils.collectionToCommaDelimitedString(userIds);
            return this;
        }

        public VaultCertificateRequest build() {
            Assert.notNull((Object)this.commonName, (String)"Common name must not be null");
            Assert.hasText((String)this.commonName, (String)"Common name must not be empty");
            List<String> altNames = switch (this.altNames.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.altNames.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.altNames));
            };
            List<String> ipSubjectAltNames = switch (this.ipSubjectAltNames.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.ipSubjectAltNames.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.ipSubjectAltNames));
            };
            List<String> uriSubjectAltNames = switch (this.uriSubjectAltNames.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.uriSubjectAltNames.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.uriSubjectAltNames));
            };
            List<String> otherSans = switch (this.otherSans.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.otherSans.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.otherSans));
            };
            return new VaultCertificateRequest(this.commonName, this.excludeCommonNameFromSubjectAltNames, altNames, ipSubjectAltNames, uriSubjectAltNames, otherSans, this.ttl, this.notAfter, this.format, this.privateKeyFormat, this.userIds);
        }

        private static <E> List<E> toList(Iterable<E> iter) {
            ArrayList<E> list = new ArrayList<E>();
            for (E item : iter) {
                list.add(item);
            }
            return list;
        }
    }
}

