/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.server;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser$;
import org.apache.pekko.http.impl.engine.parsing.HttpRequestParser;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput;
import org.apache.pekko.http.impl.engine.rendering.DateHeaderRendering;
import org.apache.pekko.http.impl.engine.rendering.HttpResponseRendererFactory;
import org.apache.pekko.http.impl.engine.rendering.ResponseRenderingContext;
import org.apache.pekko.http.impl.engine.rendering.ResponseRenderingOutput;
import org.apache.pekko.http.impl.engine.server.HttpServerBluePrint;
import org.apache.pekko.http.impl.util.LogByteStringTools$;
import org.apache.pekko.http.impl.util.One2OneBidiFlow$;
import org.apache.pekko.http.scaladsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.IllegalUriException;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.TLSProtocol;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.BidiFlow$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;

@InternalApi
public final class HttpServerBluePrint$ {
    public static final HttpServerBluePrint$ MODULE$ = new HttpServerBluePrint$();
    private static final BidiFlow<ByteString, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SessionBytes, NotUsed> tlsSupport = BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1 & Serializable)x$1 -> new TLSProtocol.SendBytes(x$1)), (Graph)Flow$.MODULE$.apply().collect((PartialFunction)new Serializable(){
        private static final long serialVersionUID = 0L;

        public final <A1 extends TLSProtocol.SslTlsInbound, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
            if (x1 instanceof TLSProtocol.SessionBytes) {
                return (B1)((TLSProtocol.SessionBytes)x1);
            }
            return (B1)function1.apply(x1);
        }

        public final boolean isDefinedAt(TLSProtocol.SslTlsInbound x1) {
            return x1 instanceof TLSProtocol.SessionBytes;
        }
    }));

    public BidiFlow<HttpResponse, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, HttpRequest, NotUsed> apply(ServerSettings settings, LoggingAdapter log, boolean isSecureConnection, DateHeaderRendering dateHeaderRendering) {
        return this.userHandlerGuard(settings.pipeliningLimit()).atop(this.requestTimeoutSupport(settings.timeouts().requestTimeout(), log)).atop(this.requestPreparation(settings)).atop(this.controller(settings, log)).atop(this.parsingRendering(settings, log, isSecureConnection, dateHeaderRendering)).atop(this.websocketSupport(settings, log)).atop(this.tlsSupport()).atop(LogByteStringTools$.MODULE$.logTLSBidiBySetting("server-plain-text", settings.logUnencryptedNetworkBytes()));
    }

    public BidiFlow<ByteString, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SessionBytes, NotUsed> tlsSupport() {
        return tlsSupport;
    }

    public BidiFlow<ResponseRenderingOutput, ByteString, TLSProtocol.SessionBytes, TLSProtocol.SessionBytes, NotUsed> websocketSupport(ServerSettings settings, LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromGraph((Graph)new HttpServerBluePrint.ProtocolSwitchStage(settings, log));
    }

    public BidiFlow<ResponseRenderingContext, ResponseRenderingOutput, TLSProtocol.SessionBytes, ParserOutput.RequestOutput, NotUsed> parsingRendering(ServerSettings settings, LoggingAdapter log, boolean isSecureConnection, DateHeaderRendering dateHeaderRendering) {
        return BidiFlow$.MODULE$.fromFlows(this.rendering(settings, log, dateHeaderRendering), this.parsing(settings, log, isSecureConnection));
    }

    public BidiFlow<HttpResponse, ResponseRenderingContext, ParserOutput.RequestOutput, ParserOutput.RequestOutput, NotUsed> controller(ServerSettings settings, LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromGraph((Graph)new HttpServerBluePrint.ControllerStage(settings, log)).reversed();
    }

    public BidiFlow<HttpResponse, HttpResponse, ParserOutput.RequestOutput, HttpRequest, NotUsed> requestPreparation(ServerSettings settings) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply(), (Graph)new HttpServerBluePrint.PrepareRequests(settings));
    }

    public BidiFlow<HttpResponse, HttpResponse, HttpRequest, HttpRequest, NotUsed> requestTimeoutSupport(Duration timeout, LoggingAdapter log) {
        Duration duration = timeout;
        FiniteDuration finiteDuration = Duration$.MODULE$.Zero();
        if (!(duration != null ? !duration.equals(finiteDuration) : finiteDuration != null)) {
            return BidiFlow$.MODULE$.identity();
        }
        return BidiFlow$.MODULE$.fromGraph((Graph)new HttpServerBluePrint.RequestTimeoutSupport(timeout, log)).reversed();
    }

    public Flow<TLSProtocol.SessionBytes, ParserOutput.RequestOutput, NotUsed> parsing(ServerSettings settings, LoggingAdapter log, boolean isSecureConnection) {
        HttpRequestParser rootParser = new HttpRequestParser(settings.parserSettings(), settings.websocketSettings(), settings.rawRequestUriHeader(), HttpHeaderParser$.MODULE$.apply(settings.parserSettings(), log));
        return (Flow)Flow$.MODULE$.apply().via((Graph)rootParser).map((Function1 & Serializable)requestOutput -> HttpServerBluePrint$.establishAbsoluteUri$1(requestOutput, isSecureConnection, settings));
    }

    public Flow<ResponseRenderingContext, ResponseRenderingOutput, NotUsed> rendering(ServerSettings settings, LoggingAdapter log, DateHeaderRendering dateHeaderRendering) {
        HttpResponseRendererFactory responseRendererFactory = new HttpResponseRendererFactory(settings.serverHeader(), settings.responseHeaderSizeHint(), log, dateHeaderRendering);
        return Flow$.MODULE$.apply().via((Graph)responseRendererFactory.renderer().named("renderer"));
    }

    public BidiFlow<HttpResponse, HttpResponse, HttpRequest, HttpRequest, NotUsed> userHandlerGuard(int pipeliningLimit) {
        return One2OneBidiFlow$.MODULE$.apply(pipeliningLimit, One2OneBidiFlow$.MODULE$.apply$default$2(), One2OneBidiFlow$.MODULE$.apply$default$3()).reversed();
    }

    /*
     * WARNING - void declaration
     */
    private static final ParserOutput.RequestOutput establishAbsoluteUri$1(ParserOutput.RequestOutput requestOutput, boolean isSecureConnection$1, ServerSettings settings$1) {
        boolean bl = false;
        ParserOutput.RequestStart requestStart = null;
        if (requestOutput instanceof ParserOutput.RequestStart) {
            bl = true;
            requestStart = (ParserOutput.RequestStart)requestOutput;
            HttpMethod httpMethod = requestStart.method();
            HttpMethod httpMethod2 = HttpMethods$.MODULE$.CONNECT();
            if (!(httpMethod != null ? !((Object)httpMethod).equals(httpMethod2) : httpMethod2 != null)) {
                void apply_detail;
                String string = new StringBuilder(31).append("Rejecting CONNECT request to '").append(requestStart.uri()).append("'").toString();
                String apply_summary = "CONNECT requests are not supported";
                Object var15_7 = null;
                string = null;
                return new ParserOutput.MessageStartError(StatusCodes$.MODULE$.BadRequest(), new ErrorInfo(apply_summary, (String)apply_detail, ""));
            }
        }
        if (bl) {
            try {
                Uri effectiveUri = HttpRequest$.MODULE$.effectiveUri(requestStart.uri(), (Seq<HttpHeader>)requestStart.headers(), isSecureConnection$1, settings$1.defaultHostHeader());
                HttpMethod x$2 = requestStart.copy$default$1();
                HttpProtocol x$3 = requestStart.copy$default$3();
                Map<AttributeKey<?>, Object> x$4 = requestStart.copy$default$4();
                List<HttpHeader> x$5 = requestStart.copy$default$5();
                ParserOutput.EntityCreator<ParserOutput.RequestOutput, RequestEntity> x$6 = requestStart.copy$default$6();
                boolean x$7 = requestStart.copy$default$7();
                boolean x$8 = requestStart.copy$default$8();
                return requestStart.copy(x$2, effectiveUri, x$3, x$4, x$5, x$6, x$7, x$8);
            }
            catch (IllegalUriException e) {
                return new ParserOutput.MessageStartError(StatusCodes$.MODULE$.BadRequest(), e.info());
            }
        }
        return requestOutput;
    }

    private HttpServerBluePrint$() {
    }
}

