/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.UUID;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class AwsEc2AuthenticationOptions {
    public static final URI DEFAULT_PKCS7_IDENTITY_DOCUMENT_URI = URI.create("http://169.254.169.254/latest/dynamic/instance-identity/pkcs7");
    public static final URI DEFAULT_IMDSV2_TOKEN_URI = URI.create("http://169.254.169.254/latest/api/token");
    public static final String DEFAULT_AWS_AUTHENTICATION_PATH = "aws-ec2";
    public static final AwsEc2AuthenticationOptions DEFAULT = new AwsEc2AuthenticationOptions();
    private final String path;
    private final URI identityDocumentUri;
    @Nullable
    private final String role;
    private final Nonce nonce;
    private final Duration metadataTokenTtl;
    private final URI metadataTokenRequestUri;
    private final InstanceMetadataServiceVersion version;

    private AwsEc2AuthenticationOptions() {
        this(DEFAULT_AWS_AUTHENTICATION_PATH, DEFAULT_PKCS7_IDENTITY_DOCUMENT_URI, "", Nonce.generated(), Duration.ofMinutes(1L), DEFAULT_IMDSV2_TOKEN_URI, InstanceMetadataServiceVersion.V2);
    }

    private AwsEc2AuthenticationOptions(String path, URI identityDocumentUri, @Nullable String role, Nonce nonce, Duration metadataTokenTtl, URI metadataTokenRequestUri, InstanceMetadataServiceVersion version) {
        this.path = path;
        this.identityDocumentUri = identityDocumentUri;
        this.role = role;
        this.nonce = nonce;
        this.metadataTokenTtl = metadataTokenTtl;
        this.metadataTokenRequestUri = metadataTokenRequestUri;
        this.version = version;
    }

    public static AwsEc2AuthenticationOptionsBuilder builder() {
        return new AwsEc2AuthenticationOptionsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public URI getIdentityDocumentUri() {
        return this.identityDocumentUri;
    }

    @Nullable
    public String getRole() {
        return this.role;
    }

    public Nonce getNonce() {
        return this.nonce;
    }

    public InstanceMetadataServiceVersion getVersion() {
        return this.version;
    }

    public Duration getMetadataTokenTtl() {
        return this.metadataTokenTtl;
    }

    public URI getMetadataTokenRequestUri() {
        return this.metadataTokenRequestUri;
    }

    public static class Nonce {
        private final char[] value;

        protected Nonce(char[] value) {
            this.value = value;
        }

        public static Nonce generated() {
            return new Generated();
        }

        public static Nonce provided(char[] nonce) {
            Assert.notNull((Object)nonce, (String)"Nonce must not be null");
            return new Provided(Arrays.copyOf(nonce, nonce.length));
        }

        public char[] getValue() {
            return this.value;
        }

        static class Generated
        extends Nonce {
            Generated() {
                super(UUID.randomUUID().toString().toCharArray());
            }
        }

        static class Provided
        extends Nonce {
            Provided(char[] nonce) {
                super(nonce);
            }
        }
    }

    public static enum InstanceMetadataServiceVersion {
        V1,
        V2;

    }

    public static class AwsEc2AuthenticationOptionsBuilder {
        private String path = "aws-ec2";
        private URI identityDocumentUri = DEFAULT_PKCS7_IDENTITY_DOCUMENT_URI;
        @Nullable
        private String role;
        private Nonce nonce = Nonce.generated();
        private Duration metadataTokenTtl = Duration.ofMinutes(1L);
        private URI metadataTokenRequestUri = DEFAULT_IMDSV2_TOKEN_URI;
        private InstanceMetadataServiceVersion version = InstanceMetadataServiceVersion.V2;

        AwsEc2AuthenticationOptionsBuilder() {
        }

        public AwsEc2AuthenticationOptionsBuilder path(String path) {
            Assert.hasText((String)path, (String)"Path must not be empty");
            this.path = path;
            return this;
        }

        public AwsEc2AuthenticationOptionsBuilder identityDocumentUri(URI identityDocumentUri) {
            Assert.notNull((Object)identityDocumentUri, (String)"Identity document URI must not be null");
            this.identityDocumentUri = identityDocumentUri;
            return this;
        }

        public AwsEc2AuthenticationOptionsBuilder role(@Nullable String role) {
            this.role = role;
            return this;
        }

        public AwsEc2AuthenticationOptionsBuilder nonce(Nonce nonce) {
            Assert.notNull((Object)nonce, (String)"Nonce must not be null");
            this.nonce = nonce;
            return this;
        }

        public AwsEc2AuthenticationOptionsBuilder metadataTokenTtl(Duration ttl) {
            Assert.notNull((Object)ttl, (String)"Duration must not be null");
            Assert.isTrue((!ttl.isNegative() && !ttl.isZero() ? 1 : 0) != 0, (String)"Duration must not be zero or negative");
            this.metadataTokenTtl = ttl;
            return this;
        }

        public AwsEc2AuthenticationOptionsBuilder metadataTokenRequestUri(URI metadataTokenRequestUri) {
            Assert.notNull((Object)metadataTokenRequestUri, (String)"Metadata token request URI must not be null");
            this.metadataTokenRequestUri = metadataTokenRequestUri;
            return this;
        }

        public AwsEc2AuthenticationOptionsBuilder version(InstanceMetadataServiceVersion version) {
            Assert.notNull((Object)((Object)version), (String)"Version must not be null");
            this.version = version;
            return this;
        }

        public AwsEc2AuthenticationOptions build() {
            Assert.notNull((Object)this.identityDocumentUri, (String)"IdentityDocumentUri must not be null");
            return new AwsEc2AuthenticationOptions(this.path, this.identityDocumentUri, this.role, this.nonce, this.metadataTokenTtl, this.metadataTokenRequestUri, this.version);
        }
    }
}

